/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider.modules;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.modules.IArchiveFile;
import com.mapbox.mapboxsdk.tileprovider.tilesource.ITileLayer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;

public class MBTilesFileArchive
implements IArchiveFile {
    private final SQLiteDatabase mDatabase;
    public static final String TABLE_TILES = "tiles";
    public static final String TABLE_METADATA = "metadata";
    public static final String COL_TILES_TILE_DATA = "tile_data";
    public static final String COL_VALUE = "value";
    private static final String TAG = "MBTilesFileArchive";

    public MBTilesFileArchive(SQLiteDatabase pDatabase) {
        this.mDatabase = pDatabase;
    }

    public static MBTilesFileArchive getDatabaseFileArchive(File pFile) throws SQLiteException {
        return new MBTilesFileArchive(SQLiteDatabase.openDatabase((String)pFile.getAbsolutePath(), null, (int)17));
    }

    @Override
    public InputStream getInputStream(ITileLayer pTileSource, MapTile pTile) {
        try {
            ByteArrayInputStream ret = null;
            String[] tile = new String[]{COL_TILES_TILE_DATA};
            String[] xyz = new String[]{Integer.toString(pTile.getX()), Double.toString(Math.pow(2.0, pTile.getZ()) - (double)pTile.getY() - 1.0), Integer.toString(pTile.getZ())};
            Cursor cur = this.mDatabase.query(TABLE_TILES, tile, "tile_column=? and tile_row=? and zoom_level=?", xyz, null, null, null);
            if (cur.getCount() != 0) {
                cur.moveToFirst();
                ret = new ByteArrayInputStream(cur.getBlob(0));
            }
            cur.close();
            if (ret != null) {
                return ret;
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("Error getting db stream: " + pTile), (Throwable)e);
        }
        return null;
    }

    public String toString() {
        return "MBTiles [mDatabase=" + this.mDatabase.getPath() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringValue(String key) {
        String[] column = new String[]{COL_VALUE};
        String[] query = new String[]{key};
        try (Cursor c = this.mDatabase.query(TABLE_METADATA, column, "name = ?", query, null, null, null);){
            c.moveToFirst();
            String string = c.getString(0);
            return string;
        }
    }

    public float getMinZoomLevel() {
        String result = this.getStringValue("minzoom");
        if (result != null) {
            return Float.parseFloat(result);
        }
        return 0.0f;
    }

    public float getMaxZoomLevel() {
        String result = this.getStringValue("maxzoom");
        if (result != null) {
            return Float.parseFloat(result);
        }
        return 22.0f;
    }

    public String getName() {
        return this.getStringValue("name");
    }

    public String getType() {
        return this.getStringValue("template");
    }

    public String getVersion() {
        return this.getStringValue("version");
    }

    public String getDescription() {
        return this.getStringValue("description");
    }

    public String getAttribution() {
        return this.getStringValue("attribution");
    }

    public BoundingBox getBounds() {
        String result = this.getStringValue("bounds");
        if (result != null) {
            String[] boundsArray = result.split(",\\s*");
            return new BoundingBox(Double.parseDouble(boundsArray[3]), Double.parseDouble(boundsArray[2]), Double.parseDouble(boundsArray[1]), Double.parseDouble(boundsArray[0]));
        }
        return null;
    }

    public LatLng getCenter() {
        String result = this.getStringValue("center");
        if (result != null) {
            String[] centerArray = result.split(",\\s*");
            return new LatLng(Double.parseDouble(centerArray[0]), Double.parseDouble(centerArray[1]), Double.parseDouble(centerArray[2]));
        }
        return null;
    }

    public void close() {
        if (this.mDatabase != null) {
            this.mDatabase.close();
        }
    }
}

