/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views.safecanvas;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import com.mapbox.mapboxsdk.views.safecanvas.ISafeCanvas;

public class SafeTranslatedPath
extends Path {
    private static final RectF sRectF = new RectF();
    public int xOffset = 0;
    public int yOffset = 0;

    public void onDrawCycleStart(ISafeCanvas canvas) {
        int deltaX = canvas.getXOffset() - this.xOffset;
        int deltaY = canvas.getYOffset() - this.yOffset;
        super.offset((float)deltaX, (float)deltaY);
        this.xOffset = canvas.getXOffset();
        this.yOffset = canvas.getYOffset();
    }

    public void reset() {
        super.reset();
    }

    public void rewind() {
        super.rewind();
    }

    public void set(Path src) {
        super.set(src);
    }

    public Path.FillType getFillType() {
        return super.getFillType();
    }

    public void setFillType(Path.FillType ft) {
        super.setFillType(ft);
    }

    public boolean isInverseFillType() {
        return super.isInverseFillType();
    }

    public void toggleInverseFillType() {
        super.toggleInverseFillType();
    }

    public boolean isEmpty() {
        return super.isEmpty();
    }

    public boolean isRect(Rect rect) {
        rect.offset(this.xOffset, this.yOffset);
        boolean result = super.isRect(this.toOffsetRectF(rect, sRectF));
        rect.offset(-this.xOffset, -this.yOffset);
        return result;
    }

    public void computeBounds(Rect bounds, boolean exact) {
        super.computeBounds(sRectF, exact);
        bounds.set((int)SafeTranslatedPath.sRectF.left, (int)SafeTranslatedPath.sRectF.top, (int)SafeTranslatedPath.sRectF.right, (int)SafeTranslatedPath.sRectF.bottom);
        bounds.offset(-this.xOffset, -this.yOffset);
    }

    public void incReserve(int extraPtCount) {
        super.incReserve(extraPtCount);
    }

    public void moveTo(double x, double y) {
        super.moveTo((float)(x + (double)this.xOffset), (float)(y + (double)this.yOffset));
    }

    public void rMoveTo(float dx, float dy) {
        super.rMoveTo(dx, dy);
    }

    public void lineTo(double x, double y) {
        super.lineTo((float)(x + (double)this.xOffset), (float)(y + (double)this.yOffset));
    }

    public void rLineTo(float dx, float dy) {
        super.rLineTo(dx, dy);
    }

    public void quadTo(double x1, double y1, double x2, double y2) {
        super.quadTo((float)(x1 + (double)this.xOffset), (float)(y1 + (double)this.yOffset), (float)(x2 + (double)this.xOffset), (float)(y2 + (double)this.yOffset));
    }

    public void rQuadTo(float dx1, float dy1, float dx2, float dy2) {
        super.rQuadTo(dx1, dy1, dx2, dy2);
    }

    public void cubicTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        super.cubicTo((float)(x1 + (double)this.xOffset), (float)(y1 + (double)this.yOffset), (float)(x2 + (double)this.xOffset), (float)(y2 + (double)this.yOffset), (float)(x3 + (double)this.xOffset), (float)(y3 + (double)this.yOffset));
    }

    public void rCubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        super.rCubicTo(x1, y1, x2, y2, x3, y3);
    }

    public void arcTo(Rect oval, float startAngle, float sweepAngle, boolean forceMoveTo) {
        oval.offset(this.xOffset, this.yOffset);
        super.arcTo(this.toOffsetRectF(oval, sRectF), startAngle, sweepAngle, forceMoveTo);
        oval.offset(-this.xOffset, -this.yOffset);
    }

    public void arcTo(Rect oval, float startAngle, float sweepAngle) {
        oval.offset(this.xOffset, this.yOffset);
        super.arcTo(this.toOffsetRectF(oval, sRectF), startAngle, sweepAngle);
        oval.offset(-this.xOffset, -this.yOffset);
    }

    public void close() {
        super.close();
    }

    public void addRect(Rect rect, Path.Direction dir) {
        rect.offset(this.xOffset, this.yOffset);
        super.addRect(this.toOffsetRectF(rect, sRectF), dir);
        rect.offset(-this.xOffset, -this.yOffset);
    }

    public void addRect(double left, double top, double right, double bottom, Path.Direction dir) {
        super.addRect((float)(left + (double)this.xOffset), (float)(top + (double)this.yOffset), (float)(right + (double)this.xOffset), (float)(bottom + (double)this.yOffset), dir);
    }

    public void addOval(Rect oval, Path.Direction dir) {
        oval.offset(this.xOffset, this.yOffset);
        super.addOval(this.toOffsetRectF(oval, sRectF), dir);
        oval.offset(-this.xOffset, -this.yOffset);
    }

    public void addCircle(double x, double y, float radius, Path.Direction dir) {
        super.addCircle((float)(x + (double)this.xOffset), (float)(y + (double)this.yOffset), radius, dir);
    }

    public void addArc(Rect oval, float startAngle, float sweepAngle) {
        oval.offset(this.xOffset, this.yOffset);
        super.addArc(this.toOffsetRectF(oval, sRectF), startAngle, sweepAngle);
        oval.offset(-this.xOffset, -this.yOffset);
    }

    public void addRoundRect(Rect rect, float rx, float ry, Path.Direction dir) {
        rect.offset(this.xOffset, this.yOffset);
        super.addRoundRect(this.toOffsetRectF(rect, sRectF), rx, ry, dir);
        rect.offset(-this.xOffset, -this.yOffset);
    }

    public void addRoundRect(Rect rect, float[] radii, Path.Direction dir) {
        rect.offset(this.xOffset, this.yOffset);
        super.addRoundRect(this.toOffsetRectF(rect, sRectF), radii, dir);
        rect.offset(-this.xOffset, -this.yOffset);
    }

    public void addPath(Path src, float dx, float dy) {
        boolean safePath = src instanceof SafeTranslatedPath;
        if (!safePath) {
            src.offset((float)this.xOffset, (float)this.yOffset);
        }
        super.addPath(src, dx, dy);
        if (!safePath) {
            src.offset((float)(-this.xOffset), (float)(-this.yOffset));
        }
    }

    public void addPath(Path src) {
        boolean safePath = src instanceof SafeTranslatedPath;
        if (!safePath) {
            src.offset((float)this.xOffset, (float)this.yOffset);
        }
        super.addPath(src);
        if (!safePath) {
            src.offset((float)(-this.xOffset), (float)(-this.yOffset));
        }
    }

    public void addPath(Path src, Matrix matrix) {
        boolean safePath = src instanceof SafeTranslatedPath;
        if (!safePath) {
            matrix.preTranslate((float)this.xOffset, (float)this.yOffset);
        }
        super.addPath(src, matrix);
        if (!safePath) {
            matrix.preTranslate((float)(-this.xOffset), (float)(-this.yOffset));
        }
    }

    public void offset(float dx, float dy, Path dst) {
        super.offset(dx, dy, dst);
    }

    public void offset(float dx, float dy) {
        super.offset(dx, dy);
    }

    public void setLastPoint(double dx, double dy) {
        super.setLastPoint((float)(dx + (double)this.xOffset), (float)(dy + (double)this.yOffset));
    }

    public void transform(Matrix matrix, Path dst) {
        super.transform(matrix, dst);
    }

    public void transform(Matrix matrix) {
        super.transform(matrix);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected final RectF toOffsetRectF(Rect rect, RectF reuse) {
        if (reuse == null) {
            reuse = new RectF();
        }
        reuse.set((float)(rect.left + this.xOffset), (float)(rect.top + this.yOffset), (float)(rect.right + this.xOffset), (float)(rect.bottom + this.yOffset));
        return reuse;
    }
}

