/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.graphics.Canvas;
import android.graphics.Point;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import com.mapbox.mapboxsdk.overlay.IOverlayMenuProvider;
import com.mapbox.mapboxsdk.overlay.Overlay;
import com.mapbox.mapboxsdk.overlay.SafeDrawOverlay;
import com.mapbox.mapboxsdk.overlay.TilesOverlay;
import com.mapbox.mapboxsdk.views.MapView;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class OverlayManager
extends AbstractList<Overlay> {
    private TilesOverlay mTilesOverlay;
    private boolean mUseSafeCanvas = true;
    private final CopyOnWriteArrayList<Overlay> mOverlayList;

    public OverlayManager(TilesOverlay tilesOverlay) {
        this.setTilesOverlay(tilesOverlay);
        this.mOverlayList = new CopyOnWriteArrayList();
    }

    @Override
    public Overlay get(int pIndex) {
        return this.mOverlayList.get(pIndex);
    }

    @Override
    public int size() {
        return this.mOverlayList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int pIndex, Overlay pElement) {
        try {
            this.mOverlayList.add(pIndex, pElement);
            if (pElement instanceof SafeDrawOverlay) {
                ((SafeDrawOverlay)pElement).setUseSafeCanvas(this.isUsingSafeCanvas());
            }
        }
        finally {
            this.sortOverlays();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Overlay remove(int pIndex) {
        try {
            Overlay overlay = this.mOverlayList.remove(pIndex);
            return overlay;
        }
        finally {
            this.sortOverlays();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Overlay set(int pIndex, Overlay pElement) {
        try {
            Overlay overlay = this.mOverlayList.set(pIndex, pElement);
            if (pElement instanceof SafeDrawOverlay) {
                ((SafeDrawOverlay)pElement).setUseSafeCanvas(this.isUsingSafeCanvas());
            }
            Overlay overlay2 = overlay;
            return overlay2;
        }
        finally {
            this.sortOverlays();
        }
    }

    private void sortOverlays() {
        Overlay[] array = this.mOverlayList.toArray(new Overlay[this.mOverlayList.size()]);
        Arrays.sort(array, new Comparator<Overlay>(){

            @Override
            public int compare(Overlay lhs, Overlay rhs) {
                return Integer.valueOf(lhs.getOverlayIndex()).compareTo(rhs.getOverlayIndex());
            }
        });
        this.mOverlayList.clear();
        this.mOverlayList.addAll(Arrays.asList(array));
    }

    public boolean isUsingSafeCanvas() {
        return this.mUseSafeCanvas;
    }

    public void setUseSafeCanvas(boolean useSafeCanvas) {
        this.mUseSafeCanvas = useSafeCanvas;
        for (Overlay overlay : this.mOverlayList) {
            if (!(overlay instanceof SafeDrawOverlay)) continue;
            ((SafeDrawOverlay)overlay).setUseSafeCanvas(this.isUsingSafeCanvas());
        }
        if (this.mTilesOverlay != null) {
            this.mTilesOverlay.setUseSafeCanvas(this.isUsingSafeCanvas());
        }
    }

    public TilesOverlay getTilesOverlay() {
        return this.mTilesOverlay;
    }

    public void setTilesOverlay(TilesOverlay tilesOverlay) {
        this.mTilesOverlay = tilesOverlay;
        if (this.mTilesOverlay != null) {
            this.mTilesOverlay.setUseSafeCanvas(this.isUsingSafeCanvas());
        }
    }

    public Iterable<Overlay> overlaysReversed() {
        return new Iterable<Overlay>(){

            @Override
            public Iterator<Overlay> iterator() {
                final ListIterator i = OverlayManager.this.mOverlayList.listIterator(OverlayManager.this.mOverlayList.size());
                return new Iterator<Overlay>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasPrevious();
                    }

                    @Override
                    public Overlay next() {
                        return (Overlay)i.previous();
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }
        };
    }

    public void draw(Canvas c, MapView pMapView) {
        if (this.mTilesOverlay != null && this.mTilesOverlay.isEnabled()) {
            this.mTilesOverlay.draw(c, pMapView, true);
        }
        if (this.mTilesOverlay != null && this.mTilesOverlay.isEnabled()) {
            this.mTilesOverlay.draw(c, pMapView, false);
        }
        for (Overlay overlay : this.mOverlayList) {
            if (!overlay.isEnabled()) continue;
            overlay.draw(c, pMapView, true);
        }
        for (Overlay overlay : this.mOverlayList) {
            if (!overlay.isEnabled()) continue;
            overlay.draw(c, pMapView, false);
        }
    }

    public void onDetach(MapView pMapView) {
        if (this.mTilesOverlay != null) {
            this.mTilesOverlay.onDetach(pMapView);
        }
        for (Overlay overlay : this.overlaysReversed()) {
            overlay.onDetach(pMapView);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onKeyDown(keyCode, event, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onKeyUp(keyCode, event, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onTouchEvent(event, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent event, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onTrackballEvent(event, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onSnapToItem(int x, int y, Point snapPoint, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!(overlay instanceof Overlay.Snappable) || !((Overlay.Snappable)((Object)overlay)).onSnapToItem(x, y, snapPoint, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onDoubleTap(MotionEvent e, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onDoubleTap(e, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onDoubleTapEvent(MotionEvent e, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onDoubleTapEvent(e, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent e, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onSingleTapConfirmed(e, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onDown(MotionEvent pEvent, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onDown(pEvent, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onFling(MotionEvent pEvent1, MotionEvent pEvent2, float pVelocityX, float pVelocityY, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onFling(pEvent1, pEvent2, pVelocityX, pVelocityY, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onLongPress(MotionEvent pEvent, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onLongPress(pEvent, pMapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onScroll(MotionEvent pEvent1, MotionEvent pEvent2, float pDistanceX, float pDistanceY, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onScroll(pEvent1, pEvent2, pDistanceX, pDistanceY, pMapView)) continue;
            return true;
        }
        return false;
    }

    public void onShowPress(MotionEvent pEvent, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            overlay.onShowPress(pEvent, pMapView);
        }
    }

    public boolean onSingleTapUp(MotionEvent pEvent, MapView pMapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            if (!overlay.onSingleTapUp(pEvent, pMapView)) continue;
            return true;
        }
        return false;
    }

    public void setOptionsMenusEnabled(boolean pEnabled) {
        for (Overlay overlay : this.mOverlayList) {
            if (!(overlay instanceof IOverlayMenuProvider) || !((IOverlayMenuProvider)((Object)overlay)).isOptionsMenuEnabled()) continue;
            ((IOverlayMenuProvider)((Object)overlay)).setOptionsMenuEnabled(pEnabled);
        }
    }

    public boolean onCreateOptionsMenu(Menu pMenu, int menuIdOffset, MapView mapView) {
        boolean result = true;
        for (Overlay overlay : this.overlaysReversed()) {
            IOverlayMenuProvider overlayMenuProvider;
            if (!(overlay instanceof IOverlayMenuProvider) || !(overlayMenuProvider = (IOverlayMenuProvider)((Object)overlay)).isOptionsMenuEnabled()) continue;
            result &= overlayMenuProvider.onCreateOptionsMenu(pMenu, menuIdOffset, mapView);
        }
        return result;
    }

    public boolean onPrepareOptionsMenu(Menu pMenu, int menuIdOffset, MapView mapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            IOverlayMenuProvider overlayMenuProvider;
            if (!(overlay instanceof IOverlayMenuProvider) || !(overlayMenuProvider = (IOverlayMenuProvider)((Object)overlay)).isOptionsMenuEnabled()) continue;
            overlayMenuProvider.onPrepareOptionsMenu(pMenu, menuIdOffset, mapView);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item, int menuIdOffset, MapView mapView) {
        for (Overlay overlay : this.overlaysReversed()) {
            IOverlayMenuProvider overlayMenuProvider;
            if (!(overlay instanceof IOverlayMenuProvider) || !(overlayMenuProvider = (IOverlayMenuProvider)((Object)overlay)).isOptionsMenuEnabled() || !overlayMenuProvider.onOptionsItemSelected(item, menuIdOffset, mapView)) continue;
            return true;
        }
        return false;
    }
}

