/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.util;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public class BitmapUtils {
    private static final String TAG = "BitmapUtils";
    public static final int[] EXPIRED = new int[]{-1};

    public static BitmapFactory.Options getBitmapOptions(DisplayMetrics mDisplayMetrics) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inDensity = 160;
        options.inTargetDensity = mDisplayMetrics.densityDpi;
        return options;
    }

    public static boolean isCacheDrawableExpired(Drawable drawable2) {
        return drawable2 != null && drawable2.getState() == EXPIRED;
    }

    public static void setCacheDrawableExpired(CacheableBitmapDrawable drawable2) {
        if (drawable2 != null) {
            drawable2.setState(EXPIRED);
        }
    }

    public static int calculateMemoryCacheSize(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        boolean largeHeap = (context.getApplicationInfo().flags & 0x100000) != 0;
        int memoryClass = am.getMemoryClass();
        if (largeHeap && Build.VERSION.SDK_INT >= 11) {
            memoryClass = ActivityManagerHoneycomb.getLargeMemoryClass(am);
        }
        Log.d((String)TAG, (String)("LargeHeap enabled? = '" + largeHeap + "'"));
        int heapRes = 0x100000 * memoryClass / 7;
        Log.d((String)TAG, (String)("Heap Reserve Request For Cache Size = '" + heapRes + "'"));
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(memoryInfo);
        Log.d((String)TAG, (String)("Available Memory = '" + memoryInfo.availMem + "'"));
        return heapRes;
    }

    @TargetApi(value=11)
    private static class ActivityManagerHoneycomb {
        private ActivityManagerHoneycomb() {
        }

        static int getLargeMemoryClass(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }
}

