/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.content.ContentValues;
import android.content.Context;
import android.content.ContextWrapper;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.geometry.CoordinateRegion;
import com.mapbox.mapboxsdk.offline.OfflineDatabaseManager;
import com.mapbox.mapboxsdk.offline.OfflineMapDatabase;
import com.mapbox.mapboxsdk.offline.OfflineMapDownloaderListener;
import com.mapbox.mapboxsdk.util.AppUtils;
import com.mapbox.mapboxsdk.util.DataLoadingUtils;
import com.mapbox.mapboxsdk.util.MapboxUtils;
import com.mapbox.mapboxsdk.util.NetworkUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OfflineMapDownloader
implements MapboxConstants {
    private static final String TAG = "OfflineMapDownloader";
    private static OfflineMapDownloader offlineMapDownloader;
    private ArrayList<OfflineMapDownloaderListener> listeners;
    private Context context;
    private String uniqueID;
    private String mapID;
    private boolean includesMetadata;
    private boolean includesMarkers;
    private MapboxConstants.RasterImageQuality imageQuality;
    private CoordinateRegion mapRegion;
    private int minimumZ;
    private int maximumZ;
    private MBXOfflineMapDownloaderState state;
    private int totalFilesWritten;
    private int totalFilesExpectedToWrite;
    private ArrayList<OfflineMapDatabase> mutableOfflineMapDatabases;

    private OfflineMapDownloader(Context context) {
        this.context = context;
        this.listeners = new ArrayList();
        this.mutableOfflineMapDatabases = new ArrayList();
        ContextWrapper cw = new ContextWrapper(context);
        for (String s : cw.databaseList()) {
            if (s.toLowerCase().contains("partial") || s.toLowerCase().contains("journal")) continue;
            OfflineDatabaseManager.getOfflineDatabaseManager(context).getOfflineDatabaseHandlerForMapId(s, true);
            OfflineMapDatabase omd = new OfflineMapDatabase(context, s);
            omd.initializeDatabase();
            this.mutableOfflineMapDatabases.add(omd);
        }
        this.state = MBXOfflineMapDownloaderState.MBXOfflineMapDownloaderStateAvailable;
    }

    public static OfflineMapDownloader getOfflineMapDownloader(Context context) {
        if (offlineMapDownloader == null) {
            offlineMapDownloader = new OfflineMapDownloader(context);
        }
        return offlineMapDownloader;
    }

    public boolean addOfflineMapDownloaderListener(OfflineMapDownloaderListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeOfflineMapDownloaderListener(OfflineMapDownloaderListener listener) {
        return this.listeners.remove(listener);
    }

    public void notifyDelegateOfStateChange() {
        for (OfflineMapDownloaderListener listener : this.listeners) {
            listener.stateChanged(this.state);
        }
    }

    public void notifyDelegateOfInitialCount() {
        for (OfflineMapDownloaderListener listener : this.listeners) {
            listener.initialCountOfFiles(this.totalFilesExpectedToWrite);
        }
    }

    public void notifyDelegateOfProgress() {
        for (OfflineMapDownloaderListener listener : this.listeners) {
            listener.progressUpdate(this.totalFilesWritten, this.totalFilesExpectedToWrite);
        }
    }

    public void notifyDelegateOfNetworkConnectivityError(Throwable error) {
        for (OfflineMapDownloaderListener listener : this.listeners) {
            listener.networkConnectivityError(error);
        }
    }

    public void notifyDelegateOfSqliteError(Throwable error) {
        for (OfflineMapDownloaderListener listener : this.listeners) {
            listener.sqlLiteError(error);
        }
    }

    public void notifyDelegateOfHTTPStatusError(int status, String url) {
        for (OfflineMapDownloaderListener listener : this.listeners) {
            listener.httpStatusError(new Exception(String.format("HTTP Status Error %d, for url = %s", status, url)));
        }
    }

    public void notifyDelegateOfCompletionWithOfflineMapDatabase(OfflineMapDatabase offlineMap) {
        for (OfflineMapDownloaderListener listener : this.listeners) {
            listener.completionOfOfflineDatabaseMap(offlineMap);
        }
    }

    public OfflineMapDatabase completeDatabaseAndInstantiateOfflineMapWithError() {
        SQLiteDatabase db = OfflineDatabaseManager.getOfflineDatabaseManager(this.context).getOfflineDatabaseHandlerForMapId(this.mapID).getReadableDatabase();
        String dbPath = db.getPath();
        db.close();
        if (dbPath.endsWith("-PARTIAL")) {
            File oldDb = new File(dbPath);
            String newDb = dbPath.substring(0, dbPath.indexOf("-PARTIAL"));
            boolean result = oldDb.renameTo(new File(newDb));
            Log.i((String)TAG, (String)("Result of rename = " + result + " for oldDb = '" + dbPath + "'; newDB = '" + newDb + "'"));
        }
        OfflineDatabaseManager.getOfflineDatabaseManager(this.context).switchHandlerFromPartialToRegular(this.mapID);
        OfflineMapDatabase offlineMapDatabase = new OfflineMapDatabase(this.context, this.mapID);
        offlineMapDatabase.initializeDatabase();
        return offlineMapDatabase;
    }

    public void startDownloading() {
        this.sqliteQueryWrittenAndExpectedCountsWithError();
        Log.d((String)TAG, (String)String.format("totalFilesExpectedToWrite = %d, totalFilesWritten = %d", this.totalFilesExpectedToWrite, this.totalFilesWritten));
        ArrayList<String> urls = this.sqliteReadArrayOfOfflineMapURLsToBeDownloadLimit(-1);
        Log.d((String)TAG, (String)String.format("number of urls to download = %d", urls.size()));
        int totalDiff = this.totalFilesExpectedToWrite - this.totalFilesWritten;
        if (urls.size() != totalDiff) {
            Log.w((String)TAG, (String)String.format("totalDiff %d does not equal urls size of %d.  This is a problem.  Returning.", totalDiff, urls.size()));
            return;
        }
        if (urls.size() == 0 && totalDiff == 0) {
            this.finishUpDownloadProcess();
            return;
        }
        for (final String url : urls) {
            AsyncTask<String, Void, Void> foo = new AsyncTask<String, Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void doInBackground(String ... params) {
                    HttpURLConnection conn = null;
                    try {
                        conn = NetworkUtils.getHttpURLConnection(new URL(params[0]));
                        Log.d((String)OfflineMapDownloader.TAG, (String)("URL to download = " + conn.getURL().toString()));
                        conn.setConnectTimeout(60000);
                        conn.connect();
                        int rc = conn.getResponseCode();
                        if (rc != 200) {
                            String msg = String.format("HTTP Error connection.  Response Code = %d", rc);
                            Log.w((String)OfflineMapDownloader.TAG, (String)msg);
                            OfflineMapDownloader.this.notifyDelegateOfHTTPStatusError(rc, params[0]);
                            throw new IOException(msg);
                        }
                        ByteArrayOutputStream bais = new ByteArrayOutputStream();
                        InputStream is = null;
                        try {
                            int n;
                            is = conn.getInputStream();
                            byte[] byteChunk = new byte[4096];
                            while ((n = is.read(byteChunk)) > 0) {
                                bais.write(byteChunk, 0, n);
                            }
                        }
                        catch (IOException e) {
                            Log.e((String)OfflineMapDownloader.TAG, (String)String.format("Failed while reading bytes from %s: %s", conn.getURL().toString(), e.getMessage()));
                            e.printStackTrace();
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                            conn.disconnect();
                        }
                        OfflineMapDownloader.this.sqliteSaveDownloadedData(bais.toByteArray(), url);
                    }
                    catch (IOException e) {
                        Log.e((String)OfflineMapDownloader.TAG, (String)e.getMessage());
                        e.printStackTrace();
                    }
                    finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                    return null;
                }
            };
            foo.execute((Object[])new String[]{url});
        }
    }

    public void sqliteSaveDownloadedData(byte[] data, String url) {
        if (AppUtils.runningOnMainThread()) {
            Log.w((String)TAG, (String)"trying to run sqliteSaveDownloadedData() on main thread. Return.");
            return;
        }
        if (this.state != MBXOfflineMapDownloaderState.MBXOfflineMapDownloaderStateRunning) {
            Log.w((String)TAG, (String)("sqliteSaveDownloadedData() is not in a Running state so bailing.  State = " + (Object)((Object)this.state)));
            return;
        }
        SQLiteDatabase db = OfflineDatabaseManager.getOfflineDatabaseManager(this.context).getOfflineDatabaseHandlerForMapId(this.mapID).getWritableDatabase();
        db.beginTransaction();
        ContentValues values = new ContentValues();
        values.put("value", data);
        db.insert("data", null, values);
        db.execSQL(String.format("UPDATE %s SET %s=200, %s=last_insert_rowid() WHERE %s='%s';", "resources", "status", "id", "url", url));
        db.setTransactionSuccessful();
        db.endTransaction();
        db.close();
        ++this.totalFilesWritten;
        this.notifyDelegateOfProgress();
        Log.d((String)TAG, (String)("totalFilesWritten = " + this.totalFilesWritten + "; totalFilesExpectedToWrite = " + this.totalFilesExpectedToWrite));
        if (this.totalFilesWritten >= this.totalFilesExpectedToWrite) {
            this.finishUpDownloadProcess();
        }
    }

    private void finishUpDownloadProcess() {
        if (this.state == MBXOfflineMapDownloaderState.MBXOfflineMapDownloaderStateRunning) {
            Log.i((String)TAG, (String)"Just finished downloading all materials.  Persist the OfflineMapDatabase, change the state, and call it a day.");
            OfflineMapDatabase offlineMap = this.completeDatabaseAndInstantiateOfflineMapWithError();
            if (offlineMap != null) {
                this.mutableOfflineMapDatabases.add(offlineMap);
            }
            this.notifyDelegateOfCompletionWithOfflineMapDatabase(offlineMap);
            this.state = MBXOfflineMapDownloaderState.MBXOfflineMapDownloaderStateAvailable;
            this.notifyDelegateOfStateChange();
        }
    }

    public ArrayList<String> sqliteReadArrayOfOfflineMapURLsToBeDownloadLimit(int limit) {
        ArrayList<String> results = new ArrayList<String>();
        if (AppUtils.runningOnMainThread()) {
            Log.w((String)TAG, (String)"Attempting to run sqliteReadArrayOfOfflineMapURLsToBeDownloadLimit() on main thread.  Returning.");
            return results;
        }
        String query = String.format("SELECT %s FROM %s WHERE %s IS NULL", "url", "resources", "status");
        if (limit > 0) {
            query = query + String.format(" LIMIT %d", limit);
        }
        query = query + ";";
        SQLiteDatabase db = OfflineDatabaseManager.getOfflineDatabaseManager(this.context).getOfflineDatabaseHandlerForMapId(this.mapID).getReadableDatabase();
        Cursor cursor = db.rawQuery(query, null);
        if (cursor.moveToFirst()) {
            do {
                results.add(cursor.getString(0));
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return results;
    }

    public boolean sqliteQueryWrittenAndExpectedCountsWithError() {
        String query = "SELECT COUNT(url) AS totalFilesExpectedToWrite, (SELECT COUNT(url) FROM resources WHERE status IS NOT NULL) AS totalFilesWritten FROM resources;";
        boolean success = false;
        SQLiteDatabase db = OfflineDatabaseManager.getOfflineDatabaseManager(this.context).getOfflineDatabaseHandlerForMapId(this.mapID).getReadableDatabase();
        Cursor cursor = db.rawQuery(query, null);
        cursor.moveToFirst();
        this.totalFilesExpectedToWrite = cursor.getInt(0);
        this.totalFilesWritten = cursor.getInt(1);
        cursor.close();
        db.close();
        success = true;
        return success;
    }

    public boolean sqliteCreateDatabaseUsingMetadata(Hashtable<String, String> metadata, List<String> urlStrings) {
        ContentValues cv;
        if (AppUtils.runningOnMainThread()) {
            Log.w((String)TAG, (String)"sqliteCreateDatabaseUsingMetadata() running on main thread.  Returning.");
            return false;
        }
        boolean success = false;
        SQLiteDatabase db = OfflineDatabaseManager.getOfflineDatabaseManager(this.context).getOfflineDatabaseHandlerForMapId(this.mapID).getWritableDatabase();
        db.beginTransaction();
        for (String key : metadata.keySet()) {
            cv = new ContentValues();
            cv.put("name", key);
            cv.put("value", metadata.get(key));
            db.replace("metadata", null, cv);
        }
        for (String url : urlStrings) {
            cv = new ContentValues();
            cv.put("url", url);
            db.insert("resources", null, cv);
        }
        db.setTransactionSuccessful();
        db.endTransaction();
        db.close();
        this.totalFilesExpectedToWrite = urlStrings.size();
        this.totalFilesWritten = 0;
        success = true;
        return success;
    }

    public void beginDownloadingMapID(String mapID, CoordinateRegion mapRegion, Integer minimumZ, Integer maximumZ) {
        this.beginDownloadingMapID(mapID, mapRegion, minimumZ, maximumZ, true, true, MapboxConstants.RasterImageQuality.MBXRasterImageQualityFull);
    }

    public void beginDownloadingMapID(String mapID, CoordinateRegion mapRegion, Integer minimumZ, Integer maximumZ, boolean includeMetadata, boolean includeMarkers) {
        this.beginDownloadingMapID(mapID, mapRegion, minimumZ, maximumZ, includeMetadata, includeMarkers, MapboxConstants.RasterImageQuality.MBXRasterImageQualityFull);
    }

    public void beginDownloadingMapID(String mapID, CoordinateRegion mapRegion, Integer minimumZ, Integer maximumZ, boolean includeMetadata, boolean includeMarkers, MapboxConstants.RasterImageQuality imageQuality) {
        if (this.state != MBXOfflineMapDownloaderState.MBXOfflineMapDownloaderStateAvailable) {
            Log.w((String)TAG, (String)("state doesn't equal MBXOfflineMapDownloaderStateAvailable so return.  state = " + (Object)((Object)this.state)));
            return;
        }
        if (this.isMapIdAlreadyAnOfflineMapDatabase(mapID)) {
            Log.w((String)TAG, (String)String.format("MapId '%s' has already been downloaded.  Please delete it before trying to download again.", mapID));
            return;
        }
        this.uniqueID = UUID.randomUUID().toString();
        this.mapID = mapID;
        this.includesMetadata = includeMetadata;
        this.includesMarkers = includeMarkers;
        this.imageQuality = imageQuality;
        this.mapRegion = mapRegion;
        this.minimumZ = minimumZ;
        this.maximumZ = maximumZ;
        this.state = MBXOfflineMapDownloaderState.MBXOfflineMapDownloaderStateRunning;
        final Hashtable<String, String> metadataDictionary = new Hashtable<String, String>();
        metadataDictionary.put("uniqueID", this.uniqueID);
        metadataDictionary.put("mapID", this.mapID);
        metadataDictionary.put("includesMetadata", this.includesMetadata ? "YES" : "NO");
        metadataDictionary.put("includesMarkers", this.includesMarkers ? "YES" : "NO");
        metadataDictionary.put("imageQuality", String.format("%d", this.imageQuality.getValue()));
        metadataDictionary.put("region_latitude", String.format("%.8f", this.mapRegion.getCenter().getLatitude()));
        metadataDictionary.put("region_longitude", String.format("%.8f", this.mapRegion.getCenter().getLongitude()));
        metadataDictionary.put("region_latitude_delta", String.format("%.8f", this.mapRegion.getSpan().getLatitudeSpan()));
        metadataDictionary.put("region_longitude_delta", String.format("%.8f", this.mapRegion.getSpan().getLongitudeSpan()));
        metadataDictionary.put("minimumZ", String.format("%d", this.minimumZ));
        metadataDictionary.put("maximumZ", String.format("%d", this.maximumZ));
        final ArrayList<String> urls = new ArrayList<String>();
        String version = "v3";
        String dataName = "markers.geojson";
        if (includeMetadata) {
            urls.add(String.format("https://a.tiles.mapbox.com/v3/%s.json?secure%s", this.mapID, ""));
        }
        if (includeMarkers) {
            urls.add(String.format("https://a.tiles.mapbox.com/v3/%s/%s%s", this.mapID, dataName, ""));
        }
        double minLat = this.mapRegion.getCenter().getLatitude() - this.mapRegion.getSpan().getLatitudeSpan() / 2.0;
        double maxLat = minLat + this.mapRegion.getSpan().getLatitudeSpan();
        double minLon = this.mapRegion.getCenter().getLongitude() - this.mapRegion.getSpan().getLongitudeSpan() / 2.0;
        double maxLon = minLon + this.mapRegion.getSpan().getLongitudeSpan();
        for (int zoom = minimumZ.intValue(); zoom <= maximumZ; ++zoom) {
            int tilesPerSide = Double.valueOf(Math.pow(2.0, zoom)).intValue();
            int minX = Double.valueOf(Math.floor((minLon + 180.0) / 360.0 * (double)tilesPerSide)).intValue();
            int maxX = Double.valueOf(Math.floor((maxLon + 180.0) / 360.0 * (double)tilesPerSide)).intValue();
            int minY = Double.valueOf(Math.floor((1.0 - Math.log(Math.tan(maxLat * 3.1415927410125732 / 180.0) + 1.0 / Math.cos(maxLat * 3.1415927410125732 / 180.0)) / 3.1415927410125732) / 2.0 * (double)tilesPerSide)).intValue();
            int maxY = Double.valueOf(Math.floor((1.0 - Math.log(Math.tan(minLat * 3.1415927410125732 / 180.0) + 1.0 / Math.cos(minLat * 3.1415927410125732 / 180.0)) / 3.1415927410125732) / 2.0 * (double)tilesPerSide)).intValue();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    urls.add(MapboxUtils.getMapTileURL(this.context, this.mapID, zoom, x, y, this.imageQuality));
                }
            }
        }
        Log.i((String)TAG, (String)("Number of URLs so far: " + urls.size()));
        if (includeMarkers) {
            String dName = "markers.geojson";
            final String geojson = String.format("https://a.tiles.mapbox.com/v3/%s/%s", this.mapID, dName);
            if (!NetworkUtils.isNetworkAvailable(this.context)) {
                return;
            }
            AsyncTask<Void, Void, Void> foo = new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    try {
                        HttpURLConnection conn = NetworkUtils.getHttpURLConnection(new URL(geojson));
                        conn.setConnectTimeout(60000);
                        conn.connect();
                        if (conn.getResponseCode() != 200) {
                            throw new IOException();
                        }
                        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("UTF-8")));
                        String jsonText = DataLoadingUtils.readAll(rd);
                        HashSet<String> markerIconURLStrings = new HashSet<String>();
                        markerIconURLStrings.addAll(OfflineMapDownloader.this.parseMarkerIconURLStringsFromGeojsonData(jsonText));
                        Log.i((String)OfflineMapDownloader.TAG, (String)("Number of markerIconURLs = " + markerIconURLStrings.size()));
                        if (markerIconURLStrings.size() > 0) {
                            urls.addAll(markerIconURLStrings);
                        }
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }

                protected void onPostExecute(Void aVoid) {
                    super.onPostExecute((Object)aVoid);
                    Log.i((String)OfflineMapDownloader.TAG, (String)"Done figuring out marker icons, so now start downloading everything.");
                    OfflineMapDownloader.this.startDownloadProcess(metadataDictionary, urls);
                }
            };
            foo.execute((Object[])new Void[0]);
        } else {
            Log.i((String)TAG, (String)"No marker icons to worry about, so just start downloading.");
            this.startDownloadProcess(metadataDictionary, urls);
        }
    }

    private void startDownloadProcess(final Hashtable<String, String> metadata, final List<String> urls) {
        AsyncTask<Void, Void, Thread> startDownload = new AsyncTask<Void, Void, Thread>(){

            protected Thread doInBackground(Void ... params) {
                if (!OfflineMapDownloader.this.sqliteCreateDatabaseUsingMetadata(metadata, urls)) {
                    OfflineMapDownloader.this.cancelImmediatelyWithError("Map Database wasn't created");
                    return null;
                }
                OfflineMapDownloader.this.notifyDelegateOfInitialCount();
                OfflineMapDownloader.this.startDownloading();
                return null;
            }
        };
        startDownload.execute((Object[])new Void[0]);
    }

    public Set<String> parseMarkerIconURLStringsFromGeojsonData(String data) {
        HashSet<String> iconURLStrings = new HashSet<String>();
        JSONObject simplestyleJSONDictionary = null;
        try {
            simplestyleJSONDictionary = new JSONObject(data);
            JSONArray markers = simplestyleJSONDictionary.getJSONArray("features");
            if (markers != null && markers.length() > 0) {
                for (int lc = 0; lc < markers.length(); ++lc) {
                    String markerURL;
                    JSONObject feature;
                    String type;
                    Object value = markers.get(lc);
                    if (!(value instanceof JSONObject) || !"Point".equals(type = (feature = (JSONObject)value).getJSONObject("geometry").getString("type"))) continue;
                    String size = feature.getJSONObject("properties").getString("marker-size");
                    String color = feature.getJSONObject("properties").getString("marker-color");
                    String symbol = feature.getJSONObject("properties").getString("marker-symbol");
                    if (TextUtils.isEmpty((CharSequence)size) || TextUtils.isEmpty((CharSequence)color) || TextUtils.isEmpty((CharSequence)symbol) || TextUtils.isEmpty((CharSequence)(markerURL = MapboxUtils.markerIconURL(this.context, size, symbol, color)))) continue;
                    iconURLStrings.add(markerURL);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return iconURLStrings;
    }

    public void cancelImmediatelyWithError(String error) {
    }

    public void cancel() {
        Log.d((String)TAG, (String)("cancel called with state = " + (Object)((Object)this.state)));
    }

    public void resume() {
        if (this.state != MBXOfflineMapDownloaderState.MBXOfflineMapDownloaderStateSuspended) {
            return;
        }
    }

    public void suspend() {
        Log.d((String)TAG, (String)("suspend called with state = " + (Object)((Object)this.state)));
    }

    public ArrayList<OfflineMapDatabase> getMutableOfflineMapDatabases() {
        return this.mutableOfflineMapDatabases;
    }

    public boolean isMapIdAlreadyAnOfflineMapDatabase(String mapId) {
        for (OfflineMapDatabase db : this.getMutableOfflineMapDatabases()) {
            if (!db.getMapID().equals(mapId)) continue;
            return true;
        }
        return false;
    }

    public boolean removeOfflineMapDatabase(OfflineMapDatabase offlineMapDatabase) {
        offlineMapDatabase.invalidate();
        this.mutableOfflineMapDatabases.remove(offlineMapDatabase);
        SQLiteDatabase db = OfflineDatabaseManager.getOfflineDatabaseManager(this.context).getOfflineDatabaseHandlerForMapId(offlineMapDatabase.getMapID()).getReadableDatabase();
        String dbPath = db.getPath();
        db.close();
        File dbFile = new File(dbPath);
        boolean result = dbFile.delete();
        Log.i((String)TAG, (String)String.format("Result of removing database file: %s", result));
        return result;
    }

    public boolean removeOfflineMapDatabaseWithID(String mid) {
        for (OfflineMapDatabase database : this.getMutableOfflineMapDatabases()) {
            if (!database.getMapID().equals(mid)) continue;
            return this.removeOfflineMapDatabase(database);
        }
        return false;
    }

    public static enum MBXOfflineMapDownloaderState {
        MBXOfflineMapDownloaderStateRunning,
        MBXOfflineMapDownloaderStateSuspended,
        MBXOfflineMapDownloaderStateCanceling,
        MBXOfflineMapDownloaderStateAvailable;

    }
}

