/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.squareup.okhttp.Cache;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.SSLSocketFactory;

public class NetworkUtils {
    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public static HttpURLConnection getHttpURLConnection(URL url) {
        return NetworkUtils.getHttpURLConnection(url, null, null);
    }

    public static HttpURLConnection getHttpURLConnection(URL url, Cache cache) {
        return NetworkUtils.getHttpURLConnection(url, cache, null);
    }

    public static HttpURLConnection getHttpURLConnection(URL url, Cache cache, SSLSocketFactory sslSocketFactory) {
        OkHttpClient client = new OkHttpClient();
        if (cache != null) {
            client.setCache(cache);
        }
        if (sslSocketFactory != null) {
            client.setSslSocketFactory(sslSocketFactory);
        }
        HttpURLConnection connection = new OkUrlFactory(client).open(url);
        connection.setRequestProperty("User-Agent", "Mapbox Android SDK/0.5.1");
        return connection;
    }

    public static Cache getCache(File cacheDir, int maxSize) throws IOException {
        return new Cache(cacheDir, (long)maxSize);
    }
}

