/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.util;

import android.text.TextUtils;
import com.mapbox.mapboxsdk.constants.MapboxConstants;

public class MapboxUtils
implements MapboxConstants {
    public static String qualityExtensionForImageQuality(MapboxConstants.RasterImageQuality imageQuality) {
        String qualityExtension;
        switch (imageQuality) {
            case MBXRasterImageQualityPNG32: {
                qualityExtension = "png32";
                break;
            }
            case MBXRasterImageQualityPNG64: {
                qualityExtension = "png64";
                break;
            }
            case MBXRasterImageQualityPNG128: {
                qualityExtension = "png128";
                break;
            }
            case MBXRasterImageQualityPNG256: {
                qualityExtension = "png256";
                break;
            }
            case MBXRasterImageQualityJPEG70: {
                qualityExtension = "jpg70";
                break;
            }
            case MBXRasterImageQualityJPEG80: {
                qualityExtension = "jpg80";
                break;
            }
            case MBXRasterImageQualityJPEG90: {
                qualityExtension = "jpg90";
                break;
            }
            default: {
                qualityExtension = "png";
            }
        }
        return qualityExtension;
    }

    public static String markerIconURL(String size, String symbol, String color) {
        StringBuffer marker = new StringBuffer("pin-");
        if (size.toLowerCase(MapboxConstants.MAPBOX_LOCALE).charAt(0) == 'l') {
            marker.append("l");
        } else if (size.toLowerCase(MapboxConstants.MAPBOX_LOCALE).charAt(0) == 's') {
            marker.append("s");
        } else {
            marker.append("m");
        }
        if (!TextUtils.isEmpty((CharSequence)symbol)) {
            marker.append(String.format("-%s+", symbol));
        } else {
            marker.append("+");
        }
        marker.append(color.replaceAll("#", ""));
        marker.append("@2x.png");
        return String.format("https://a.tiles.mapbox.com/v3//marker/%s", marker);
    }

    public static String getMapTileURL(String mapID, int zoom, int x, int y, MapboxConstants.RasterImageQuality imageQuality) {
        return String.format("https://a.tiles.mapbox.com/v3/%s/%d/%d/%d%s.%s%s", mapID, zoom, x, y, "@2x", MapboxUtils.qualityExtensionForImageQuality(imageQuality), "");
    }
}

