/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import com.cocoahero.android.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.overlay.Icon;
import com.mapbox.mapboxsdk.overlay.Marker;
import com.mapbox.mapboxsdk.overlay.PathOverlay;
import com.mapbox.mapboxsdk.util.DataLoadingUtils;
import com.mapbox.mapboxsdk.views.MapView;
import java.util.ArrayList;

public class GeoJSONPainter {
    private final MapView mapView;
    private final Icon markerIcon;
    static final String TAG = "GeoJSONLayer";

    public GeoJSONPainter(MapView mapView, Icon markerIcon) {
        this.mapView = mapView;
        this.markerIcon = markerIcon;
    }

    public void loadFromURL(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        new LoadAndDisplay().execute(new String[]{url});
    }

    private class LoadAndDisplay
    extends AsyncTask<String, Void, ArrayList<Object>> {
        private LoadAndDisplay() {
        }

        protected ArrayList<Object> doInBackground(String ... params) {
            ArrayList<Object> uiObjects = new ArrayList();
            try {
                FeatureCollection parsed = DataLoadingUtils.loadGeoJSONFromUrl(params[0]);
                uiObjects = DataLoadingUtils.createUIObjectsFromGeoJSONObjects(parsed, GeoJSONPainter.this.markerIcon);
            }
            catch (Exception e) {
                Log.e((String)GeoJSONPainter.TAG, (String)("Error loading / parsing GeoJSON: " + e.toString()));
                e.printStackTrace();
            }
            return uiObjects;
        }

        protected void onPostExecute(ArrayList<Object> objects) {
            for (Object obj : objects) {
                if (obj instanceof Marker) {
                    GeoJSONPainter.this.mapView.addMarker((Marker)obj);
                    continue;
                }
                if (!(obj instanceof PathOverlay)) continue;
                GeoJSONPainter.this.mapView.getOverlays().add((PathOverlay)obj);
            }
            if (objects.size() > 0) {
                GeoJSONPainter.this.mapView.invalidate();
            }
        }
    }
}

