/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Scroller;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.api.ILatLng;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.events.MapListener;
import com.mapbox.mapboxsdk.events.ScrollEvent;
import com.mapbox.mapboxsdk.events.ZoomEvent;
import com.mapbox.mapboxsdk.format.GeoJSON;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.overlay.GeoJSONLayer;
import com.mapbox.mapboxsdk.overlay.ItemizedIconOverlay;
import com.mapbox.mapboxsdk.overlay.ItemizedOverlay;
import com.mapbox.mapboxsdk.overlay.MapEventsOverlay;
import com.mapbox.mapboxsdk.overlay.MapEventsReceiver;
import com.mapbox.mapboxsdk.overlay.Marker;
import com.mapbox.mapboxsdk.overlay.Overlay;
import com.mapbox.mapboxsdk.overlay.OverlayManager;
import com.mapbox.mapboxsdk.overlay.TilesOverlay;
import com.mapbox.mapboxsdk.tileprovider.MapTileLayerBase;
import com.mapbox.mapboxsdk.tileprovider.MapTileLayerBasic;
import com.mapbox.mapboxsdk.tileprovider.tilesource.ITileLayer;
import com.mapbox.mapboxsdk.tileprovider.tilesource.MapboxTileLayer;
import com.mapbox.mapboxsdk.tileprovider.util.SimpleInvalidationHandler;
import com.mapbox.mapboxsdk.util.BitmapUtils;
import com.mapbox.mapboxsdk.util.GeometryMath;
import com.mapbox.mapboxsdk.util.NetworkUtils;
import com.mapbox.mapboxsdk.views.InfoWindow;
import com.mapbox.mapboxsdk.views.MapController;
import com.mapbox.mapboxsdk.views.MapViewGestureDetectorListener;
import com.mapbox.mapboxsdk.views.MapViewListener;
import com.mapbox.mapboxsdk.views.MapViewScaleGestureDetectorListener;
import com.mapbox.mapboxsdk.views.util.Projection;
import com.mapbox.mapboxsdk.views.util.TileLoadedListener;
import com.mapbox.mapboxsdk.views.util.TilesLoadedListener;
import com.mapbox.mapboxsdk.views.util.constants.MapViewConstants;
import com.mapbox.mapboxsdk.views.util.constants.MapViewLayouts;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;

public class MapView
extends ViewGroup
implements MapViewConstants,
MapEventsReceiver,
MapboxConstants {
    private ItemizedIconOverlay defaultMarkerOverlay;
    private ArrayList<Marker> defaultMarkerList = new ArrayList();
    private MapEventsOverlay eventsOverlay;
    private Context context;
    private boolean firstMarker = true;
    private static final String TAG = "MapBox MapView";
    private static Method sMotionEventTransformMethod;
    private float mZoomLevel = 11.0f;
    protected float mRequestedMinimumZoomLevel = 0.0f;
    private float mMinimumZoomLevel = 0.0f;
    private float mMaximumZoomLevel = 22.0f;
    private MapViewListener mMapViewListener;
    private final OverlayManager mOverlayManager;
    private Projection mProjection;
    private boolean mLayedOut;
    private final TilesOverlay mMapOverlay;
    private final GestureDetector mGestureDetector;
    protected final Scroller mScroller;
    protected boolean mIsFlinging;
    protected final AtomicInteger mTargetZoomLevel = new AtomicInteger();
    protected final AtomicBoolean mIsAnimating = new AtomicBoolean(false);
    private final MapController mController;
    protected ScaleGestureDetector mScaleGestureDetector;
    protected float mMultiTouchScale = 1.0f;
    protected PointF mMultiTouchScalePoint = new PointF();
    protected List<MapListener> mListeners = new ArrayList<MapListener>();
    private float mapOrientation = 0.0f;
    private final float[] mRotatePoints = new float[2];
    private final Rect mInvalidateRect = new Rect();
    protected BoundingBox mScrollableAreaBoundingBox = null;
    protected RectF mScrollableAreaLimit = null;
    protected RectF mTempRect = new RectF();
    private BoundingBox mBoundingBoxToZoomOn = null;
    protected final MapTileLayerBase mTileProvider;
    private final Handler mTileRequestCompleteHandler;
    private final PointF mPoint = new PointF();
    private TilesLoadedListener tilesLoadedListener;
    TileLoadedListener tileLoadedListener;
    private InfoWindow currentTooltip;
    private int mDefaultPinRes = R.drawable.defpin;
    private Drawable mDefaultPinDrawable;
    private PointF mDefaultPinAnchor = DEFAULT_PIN_ANCHOR;
    private boolean canTapTwoFingers = false;
    private int multiTouchDownCount = 0;
    private PointF mDScroll = new PointF();

    protected MapView(Context aContext, int tileSizePixels, MapTileLayerBase tileProvider, Handler tileRequestCompleteHandler, AttributeSet attrs) {
        super(aContext, attrs);
        this.setWillNotDraw(false);
        this.mLayedOut = false;
        this.mController = new MapController(this);
        this.mScroller = new Scroller(aContext);
        Projection.setTileSize(tileSizePixels);
        if (tileProvider == null) {
            tileProvider = new MapTileLayerBasic(aContext, null, this);
        }
        this.mTileRequestCompleteHandler = tileRequestCompleteHandler == null ? new SimpleInvalidationHandler(this) : tileRequestCompleteHandler;
        this.mTileProvider = tileProvider;
        this.mTileProvider.setTileRequestCompleteHandler(this.mTileRequestCompleteHandler);
        this.mMapOverlay = new TilesOverlay(this.mTileProvider);
        this.mOverlayManager = new OverlayManager(this.mMapOverlay);
        this.mGestureDetector = new GestureDetector(aContext, (GestureDetector.OnGestureListener)new MapViewGestureDetectorListener(this));
        this.mScaleGestureDetector = new ScaleGestureDetector(aContext, (ScaleGestureDetector.OnScaleGestureListener)new MapViewScaleGestureDetectorListener(this));
        this.context = aContext;
        this.eventsOverlay = new MapEventsOverlay(aContext, this);
        this.getOverlays().add(this.eventsOverlay);
        TypedArray a = this.context.obtainStyledAttributes(attrs, R.styleable.MapView);
        String mapid = a.getString(0);
        if (mapid != null) {
            this.setTileSource(new MapboxTileLayer(mapid));
        } else {
            Log.w((String)TAG, (String)"mapid not set.");
        }
        String centerLat = a.getString(1);
        String centerLng = a.getString(2);
        if (centerLat != null && centerLng != null) {
            double lat = Double.parseDouble(centerLat);
            double lng = Double.parseDouble(centerLng);
            this.setCenter(new LatLng(lat, lng));
        } else {
            Log.d((String)TAG, (String)"centerLatLng is not specified in XML.");
        }
        String zoomLvl = a.getString(3);
        if (zoomLvl != null) {
            float lvl = Float.parseFloat(zoomLvl);
            this.setZoom(lvl);
        } else {
            Log.d((String)TAG, (String)"zoomLevel is not specified in XML.");
        }
        a.recycle();
    }

    public MapView(Context aContext) {
        this(aContext, 256, null, null, null);
    }

    public MapView(Context aContext, AttributeSet attrs) {
        this(aContext, 256, null, null, attrs);
    }

    protected MapView(Context aContext, int tileSizePixels, MapTileLayerBase aTileProvider) {
        this(aContext, tileSizePixels, aTileProvider, null, null);
    }

    public void addListener(MapListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(MapListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.remove(listener);
        }
    }

    public void addOverlay(Overlay overlay) {
        this.mOverlayManager.add(overlay);
        if (overlay instanceof MapListener) {
            this.addListener((MapListener)((Object)overlay));
        }
        this.invalidate();
    }

    public void removeOverlay(Overlay overlay) {
        this.mOverlayManager.remove(overlay);
        if (overlay instanceof MapListener) {
            this.removeListener((MapListener)((Object)overlay));
        }
        this.invalidate();
    }

    private void updateAfterSourceChange() {
        Projection.setTileSize(this.mTileProvider.getTileSizePixels());
        this.setScrollableAreaLimit(this.mTileProvider.getBoundingBox());
        this.setMinZoomLevel(this.mTileProvider.getMinimumZoomLevel());
        this.setMaxZoomLevel(this.mTileProvider.getMaximumZoomLevel());
        this.setZoom(this.mZoomLevel);
        this.scrollTo(this.mDScroll.x, this.mDScroll.y);
        this.postInvalidate();
    }

    public void setTileSource(ITileLayer[] value) {
        if (value != null && this.mTileProvider != null && this.mTileProvider instanceof MapTileLayerBasic) {
            ((MapTileLayerBasic)this.mTileProvider).setTileSources(value);
            this.updateAfterSourceChange();
        }
    }

    public void setTileSource(ITileLayer aTileSource) {
        if (aTileSource != null && this.mTileProvider != null && this.mTileProvider instanceof MapTileLayerBasic) {
            this.mTileProvider.setTileSource(aTileSource);
            this.updateAfterSourceChange();
        }
    }

    public void addTileSource(ITileLayer aTileSource) {
        if (aTileSource != null && this.mTileProvider != null && this.mTileProvider instanceof MapTileLayerBasic) {
            ((MapTileLayerBasic)this.mTileProvider).addTileSource(aTileSource);
            this.updateAfterSourceChange();
        }
    }

    public void addTileSource(ITileLayer aTileSource, int index) {
        if (aTileSource != null && this.mTileProvider != null && this.mTileProvider instanceof MapTileLayerBasic) {
            ((MapTileLayerBasic)this.mTileProvider).addTileSource(aTileSource, index);
            this.updateAfterSourceChange();
        }
    }

    public void removeTileSource(ITileLayer aTileSource) {
        if (aTileSource != null && this.mTileProvider != null && this.mTileProvider instanceof MapTileLayerBasic) {
            ((MapTileLayerBasic)this.mTileProvider).removeTileSource(aTileSource);
            this.updateAfterSourceChange();
        }
    }

    public void removeTileSource(int index) {
        if (this.mTileProvider != null && this.mTileProvider instanceof MapTileLayerBasic) {
            ((MapTileLayerBasic)this.mTileProvider).removeTileSource(index);
            this.updateAfterSourceChange();
        }
    }

    public Marker addMarker(Marker marker) {
        if (this.firstMarker) {
            this.defaultMarkerList.add(marker);
            this.setDefaultItemizedOverlay();
        } else {
            this.defaultMarkerOverlay.addItem(marker);
        }
        marker.addTo(this);
        this.firstMarker = false;
        return marker;
    }

    public void removeMarker(Marker marker) {
        this.defaultMarkerList.remove(marker);
        this.defaultMarkerOverlay.removeItem(marker);
        this.invalidate();
    }

    public void selectMarker(Marker marker) {
        InfoWindow toolTip = marker.getToolTip(this);
        if (this.mMapViewListener != null) {
            this.mMapViewListener.onTapMarker(this, marker);
        }
        this.closeCurrentTooltip();
        if (toolTip != this.currentTooltip && marker.hasContent()) {
            if (this.mMapViewListener != null) {
                this.mMapViewListener.onShowMarker(this, marker);
            }
            this.currentTooltip = toolTip;
            marker.showBubble(this.currentTooltip, this, true);
        }
    }

    public void addItemizedOverlay(ItemizedOverlay itemizedOverlay) {
        this.getOverlays().add(itemizedOverlay);
    }

    public ArrayList<ItemizedIconOverlay> getItemizedOverlays() {
        ArrayList<ItemizedIconOverlay> list = new ArrayList<ItemizedIconOverlay>();
        for (Overlay overlay : this.getOverlays()) {
            if (!(overlay instanceof ItemizedOverlay)) continue;
            list.add((ItemizedIconOverlay)overlay);
        }
        return list;
    }

    public void loadFromGeoJSONURL(String URL2) {
        if (NetworkUtils.isNetworkAvailable(this.getContext())) {
            new GeoJSONLayer(this).loadURL(URL2);
        }
    }

    public void loadFromGeoJSONString(String geoJSON) throws JSONException {
        GeoJSON.parseString(geoJSON, this);
    }

    private void closeCurrentTooltip() {
        if (this.currentTooltip != null) {
            if (this.mMapViewListener != null) {
                this.mMapViewListener.onHidemarker(this, this.currentTooltip.getBoundMarker());
            }
            this.currentTooltip.close();
            this.currentTooltip = null;
        }
    }

    private void setDefaultItemizedOverlay() {
        this.defaultMarkerOverlay = new ItemizedIconOverlay(this.getContext(), this.defaultMarkerList, new ItemizedIconOverlay.OnItemGestureListener<Marker>(){

            @Override
            public boolean onItemSingleTapUp(int index, Marker item) {
                MapView.this.selectMarker(item);
                return true;
            }

            @Override
            public boolean onItemLongPress(int index, Marker item) {
                if (MapView.this.mMapViewListener != null) {
                    MapView.this.mMapViewListener.onLongPressMarker(MapView.this, item);
                }
                return true;
            }
        });
        this.getOverlays().add(this.defaultMarkerOverlay);
    }

    @Override
    public boolean singleTapUpHelper(ILatLng p) {
        this.closeCurrentTooltip();
        this.onTap(p);
        return true;
    }

    @Override
    public boolean longPressHelper(ILatLng p) {
        this.onLongPress(p);
        return false;
    }

    public void onLongPress(ILatLng p) {
        if (this.mMapViewListener != null) {
            this.mMapViewListener.onLongPressMap(this, p);
        }
    }

    public void onTap(ILatLng p) {
        if (this.mMapViewListener != null) {
            this.mMapViewListener.onTapMap(this, p);
        }
    }

    public MapController getController() {
        return this.mController;
    }

    public TilesOverlay getMapOverlay() {
        return this.mMapOverlay;
    }

    public List<Overlay> getOverlays() {
        return this.getOverlayManager();
    }

    public OverlayManager getOverlayManager() {
        return this.mOverlayManager;
    }

    public MapTileLayerBase getTileProvider() {
        return this.mTileProvider;
    }

    public Scroller getScroller() {
        return this.mScroller;
    }

    public Handler getTileRequestCompleteHandler() {
        return this.mTileRequestCompleteHandler;
    }

    public BoundingBox getBoundingBoxInternal() {
        if (this.getMeasuredWidth() == 0 || this.getMeasuredHeight() == 0) {
            return null;
        }
        Rect screenRect = GeometryMath.viewPortRect(this.getProjection(), null);
        LatLng neGeoPoint = Projection.pixelXYToLatLong(screenRect.right, screenRect.top, this.mZoomLevel);
        LatLng swGeoPoint = Projection.pixelXYToLatLong(screenRect.left, screenRect.bottom, this.mZoomLevel);
        return new BoundingBox(neGeoPoint.getLatitude(), neGeoPoint.getLongitude(), swGeoPoint.getLatitude(), swGeoPoint.getLongitude());
    }

    public BoundingBox getBoundingBox() {
        return this.getProjection().getBoundingBox();
    }

    public LatLng getCenter() {
        int worldSize_current_2 = Projection.mapSize(this.mZoomLevel) >> 1;
        return Projection.pixelXYToLatLong(this.mDScroll.x + (float)worldSize_current_2, this.mDScroll.y + (float)worldSize_current_2, this.mZoomLevel);
    }

    public Rect getScreenRect(Rect reuse) {
        Rect out = this.getIntrinsicScreenRect(reuse);
        if (this.getMapOrientation() % 180.0f != 0.0f) {
            int centerX = this.getScrollX();
            int centerY = this.getScrollY();
            GeometryMath.getBoundingBoxForRotatedRectangle(out, centerX, centerY, this.getMapOrientation(), out);
        }
        return out;
    }

    public Rect getIntrinsicScreenRect(Rect reuse) {
        if (reuse == null) {
            reuse = new Rect();
        }
        int width_2 = this.getMeasuredWidth() >> 1;
        int height_2 = this.getMeasuredHeight() >> 1;
        int scrollX = this.getScrollX();
        int scrollY = this.getScrollY();
        reuse.set(scrollX - width_2, scrollY - height_2, scrollX + width_2, scrollY + height_2);
        return reuse;
    }

    public Projection getProjection() {
        if (this.mProjection == null) {
            this.mProjection = new Projection(this);
        }
        return this.mProjection;
    }

    public MapView setCenter(ILatLng aCenter) {
        return this.setCenter(aCenter, false);
    }

    public MapView setCenter(ILatLng aCenter, boolean userAction) {
        this.getController().setCurrentlyInUserAction(userAction);
        this.getController().setCenter(aCenter);
        this.getController().setCurrentlyInUserAction(false);
        return this;
    }

    public MapView panBy(int x, int y) {
        this.mController.panBy(x, y);
        return this;
    }

    public MapView setScale(float scale) {
        float zoomDelta = (float)(Math.log(scale) / Math.log(2.0));
        float newZoom = this.mZoomLevel + zoomDelta;
        if (newZoom <= this.mMaximumZoomLevel && newZoom >= this.mMinimumZoomLevel) {
            this.mMultiTouchScale = scale;
            this.invalidate();
        }
        return this;
    }

    public float getScale() {
        return this.mMultiTouchScale;
    }

    private void snapItems() {
        Point snapPoint = new Point();
        if (this.getOverlayManager().onSnapToItem(this.getScrollX(), this.getScrollY(), snapPoint, this)) {
            this.scrollTo(snapPoint.x, snapPoint.y);
        }
    }

    public MapView setZoom(float aZoomLevel) {
        return this.mController.setZoom(aZoomLevel);
    }

    protected MapView setZoomInternal(float aZoomLevel) {
        return this.setZoomInternal(aZoomLevel, null, null);
    }

    protected MapView setZoomInternal(float aZoomLevel, ILatLng center, PointF decale) {
        float newZoomLevel = this.getClampedZoomLevel(aZoomLevel);
        float curZoomLevel = this.mZoomLevel;
        this.mMultiTouchScale = 1.0f;
        if (newZoomLevel != curZoomLevel) {
            this.mZoomLevel = newZoomLevel;
            this.mTargetZoomLevel.set(Float.floatToIntBits(this.mZoomLevel));
            this.mScroller.forceFinished(true);
            this.mIsFlinging = false;
            this.updateScrollableAreaLimit();
        }
        if (center != null) {
            PointF centerPoint = Projection.toMapPixels(center.getLatitude(), center.getLongitude(), newZoomLevel, this.mDScroll.x, this.mDScroll.y, null);
            if (decale != null) {
                centerPoint.offset(decale.x, decale.y);
            }
            this.scrollTo(centerPoint.x, centerPoint.y);
        } else if (newZoomLevel > curZoomLevel) {
            int worldSize_new_2 = Projection.mapSize(newZoomLevel) >> 1;
            LatLng centerGeoPoint = this.getCenter();
            PointF centerPoint = Projection.latLongToPixelXY(centerGeoPoint.getLatitude(), centerGeoPoint.getLongitude(), newZoomLevel, null);
            this.scrollTo((int)centerPoint.x - worldSize_new_2, (int)centerPoint.y - worldSize_new_2);
        } else if (newZoomLevel < curZoomLevel) {
            this.scrollTo((int)GeometryMath.rightShift(this.getScrollX(), curZoomLevel - newZoomLevel), (int)GeometryMath.rightShift(this.getScrollY(), curZoomLevel - newZoomLevel));
        }
        this.mProjection = new Projection(this);
        this.snapItems();
        this.getMapOverlay().rescaleCache(newZoomLevel, curZoomLevel, this.mProjection);
        if (newZoomLevel != curZoomLevel && this.mListeners.size() > 0) {
            ZoomEvent event = new ZoomEvent(this, newZoomLevel, this.mController.currentlyInUserAction());
            for (MapListener listener : this.mListeners) {
                listener.onZoom(event);
            }
        }
        this.requestLayout();
        return this;
    }

    private double minimumZoomForBoundingBox(BoundingBox boundingBox, boolean regionFit, boolean roundedZoom) {
        double result;
        RectF rect = Projection.toMapPixels(boundingBox, 22.0f, this.mTempRect);
        float requiredLatitudeZoom = 22.0f - (float)(Math.log(rect.height() / (float)this.getMeasuredHeight()) / Math.log(2.0));
        float requiredLongitudeZoom = 22.0f - (float)(Math.log(rect.width() / (float)this.getMeasuredWidth()) / Math.log(2.0));
        double d = result = regionFit ? (double)Math.min(requiredLatitudeZoom, requiredLongitudeZoom) : (double)Math.max(requiredLatitudeZoom, requiredLongitudeZoom);
        if (roundedZoom) {
            result = regionFit ? Math.floor(result) : (double)Math.round(result);
        }
        return result;
    }

    public MapView zoomToBoundingBox(BoundingBox boundingBox, boolean regionFit, boolean animated, boolean roundedZoom, boolean userAction) {
        BoundingBox inter;
        BoundingBox boundingBox2 = inter = this.mScrollableAreaBoundingBox != null ? this.mScrollableAreaBoundingBox.intersect(boundingBox) : boundingBox;
        if (inter == null || !inter.isValid()) {
            return this;
        }
        if (!this.mLayedOut) {
            this.mBoundingBoxToZoomOn = inter;
            return this;
        }
        LatLng center = inter.getCenter();
        float zoom = (float)this.minimumZoomForBoundingBox(inter, regionFit, roundedZoom);
        if (animated) {
            this.getController().setZoomAnimated(center, zoom, true, userAction);
        } else {
            this.getController().setCurrentlyInUserAction(userAction);
            this.getController().setZoom(zoom);
            this.getController().setCenter(center);
            this.getController().setCurrentlyInUserAction(false);
        }
        return this;
    }

    public MapView zoomToBoundingBox(BoundingBox boundingBox, boolean regionFit, boolean animated, boolean roundedZoom) {
        return this.zoomToBoundingBox(boundingBox, regionFit, animated, roundedZoom, false);
    }

    public MapView zoomToBoundingBox(BoundingBox boundingBox, boolean regionFit, boolean animated) {
        return this.zoomToBoundingBox(boundingBox, regionFit, animated, false, false);
    }

    public MapView zoomToBoundingBox(BoundingBox boundingBox, boolean regionFit) {
        return this.zoomToBoundingBox(boundingBox, regionFit, false, false);
    }

    public MapView zoomToBoundingBox(BoundingBox boundingBox) {
        return this.zoomToBoundingBox(boundingBox, false);
    }

    public float getClampedZoomLevel(float zoom) {
        float minZoomLevel = this.getMinZoomLevel();
        float maxZoomLevel = this.getMaxZoomLevel();
        return Math.max(minZoomLevel, Math.min(maxZoomLevel, zoom));
    }

    public float getZoomLevel() {
        return this.getZoomLevel(true);
    }

    private float getAnimatedZoom() {
        return Float.intBitsToFloat(this.mTargetZoomLevel.get());
    }

    public float getZoomLevel(boolean aPending) {
        if (aPending && this.isAnimating()) {
            return this.getAnimatedZoom();
        }
        return this.mZoomLevel;
    }

    public float getMinZoomLevel() {
        return Math.max(this.mMinimumZoomLevel, 0.0f);
    }

    public float getMaxZoomLevel() {
        return this.mMaximumZoomLevel;
    }

    public void setMinZoomLevel(float zoomLevel) {
        this.mRequestedMinimumZoomLevel = this.mMinimumZoomLevel = Math.max(zoomLevel, this.mTileProvider.getMinimumZoomLevel());
        this.updateMinZoomLevel();
    }

    public void setMaxZoomLevel(float zoomLevel) {
        this.mMaximumZoomLevel = Math.min(zoomLevel, this.mTileProvider.getMaximumZoomLevel());
    }

    protected boolean canZoomIn() {
        float maxZoomLevel = this.getMaxZoomLevel();
        float f = this.isAnimating() ? this.getAnimatedZoom() : this.mZoomLevel;
        return !(f >= maxZoomLevel);
    }

    protected boolean canZoomOut() {
        float minZoomLevel = this.getMinZoomLevel();
        float f = this.isAnimating() ? this.getAnimatedZoom() : this.mZoomLevel;
        return !(f <= minZoomLevel);
    }

    public boolean zoomIn() {
        return this.getController().zoomIn();
    }

    public boolean zoomInFixing(ILatLng point, boolean userAction) {
        return this.getController().zoomInAbout(point, userAction);
    }

    public boolean zoomInFixing(ILatLng point) {
        return this.zoomInFixing(point, false);
    }

    public boolean zoomOut() {
        return this.getController().zoomOut();
    }

    public boolean zoomOutFixing(ILatLng point, boolean userAction) {
        return this.getController().zoomOutAbout(point, userAction);
    }

    public boolean zoomOutFixing(ILatLng point) {
        return this.zoomOutFixing(point, false);
    }

    public void setMapOrientation(float degrees) {
        this.mapOrientation = degrees % 360.0f;
        this.mProjection = null;
        this.invalidate();
    }

    public float getMapOrientation() {
        return this.mapOrientation;
    }

    public boolean useDataConnection() {
        return this.mMapOverlay.useDataConnection();
    }

    public void setUseDataConnection(boolean aMode) {
        this.mMapOverlay.setUseDataConnection(aMode);
    }

    private void updateMinZoomLevel() {
        if (this.mScrollableAreaBoundingBox == null || !this.mLayedOut) {
            return;
        }
        this.mMinimumZoomLevel = (float)Math.max((double)this.mRequestedMinimumZoomLevel, this.minimumZoomForBoundingBox(this.mScrollableAreaBoundingBox, false, false));
        if (this.mZoomLevel < this.mMinimumZoomLevel) {
            this.setZoom(this.mMinimumZoomLevel);
        }
    }

    public void updateScrollableAreaLimit() {
        if (this.mScrollableAreaBoundingBox == null) {
            return;
        }
        if (this.mScrollableAreaLimit == null) {
            this.mScrollableAreaLimit = new RectF();
        }
        Projection.toMapPixels(this.mScrollableAreaBoundingBox, this.getZoomLevel(false), this.mScrollableAreaLimit);
    }

    public void setScrollableAreaLimit(BoundingBox boundingBox) {
        this.mScrollableAreaBoundingBox = boundingBox;
        if (this.mScrollableAreaBoundingBox == null) {
            this.mMinimumZoomLevel = this.mRequestedMinimumZoomLevel;
            this.mScrollableAreaLimit = null;
        } else {
            this.updateScrollableAreaLimit();
            this.updateMinZoomLevel();
        }
    }

    public boolean canGoTo(ILatLng point) {
        return this.mScrollableAreaBoundingBox == null || this.mScrollableAreaBoundingBox.contains(point);
    }

    public boolean canGoTo(float x, float y) {
        return this.mScrollableAreaLimit == null || this.mScrollableAreaLimit.contains(x, y);
    }

    public BoundingBox getScrollableAreaBoundingBox() {
        return this.mScrollableAreaBoundingBox;
    }

    public boolean isLayedOut() {
        return this.mLayedOut;
    }

    public void invalidateMapCoordinates(Rect dirty) {
        this.mInvalidateRect.set(dirty);
        int width_2 = this.getWidth() / 2;
        int height_2 = this.getHeight() / 2;
        int centerX = this.getScrollX();
        int centerY = this.getScrollY();
        if (this.getMapOrientation() != 0.0f) {
            GeometryMath.getBoundingBoxForRotatedRectangle(this.mInvalidateRect, centerX, centerY, this.getMapOrientation() + 180.0f, this.mInvalidateRect);
        }
        this.mInvalidateRect.offset(width_2, height_2);
        super.invalidate(this.mInvalidateRect);
    }

    public void invalidateMapCoordinates(RectF dirty) {
        dirty.roundOut(this.mInvalidateRect);
        int width_2 = this.getWidth() / 2;
        int height_2 = this.getHeight() / 2;
        int centerX = this.getScrollX();
        int centerY = this.getScrollY();
        if (this.getMapOrientation() != 0.0f) {
            GeometryMath.getBoundingBoxForRotatedRectangle(this.mInvalidateRect, centerX, centerY, this.getMapOrientation() + 180.0f, this.mInvalidateRect);
        }
        this.mInvalidateRect.offset(width_2, height_2);
        super.invalidate(this.mInvalidateRect);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2, null, 8, 0, 0);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxHeight = 0;
        int maxWidth = 0;
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        Projection projection = this.getProjection();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int childWidth = child.getMeasuredWidth();
            projection.toMapPixels(lp.geoPoint, this.mPoint);
            int x = (int)this.mPoint.x + this.getWidth() / 2;
            int y = (int)this.mPoint.y + this.getHeight() / 2;
            int childRight = x;
            int childBottom = y;
            switch (lp.alignment) {
                case 1: {
                    childRight = x + childWidth;
                    childBottom = y;
                    break;
                }
                case 2: {
                    childRight = x + childWidth / 2;
                    childBottom = y;
                    break;
                }
                case 3: {
                    childRight = x;
                    childBottom = y;
                    break;
                }
                case 4: {
                    childRight = x + childWidth;
                    childBottom = y + childHeight / 2;
                    break;
                }
                case 5: {
                    childRight = x + childWidth / 2;
                    childBottom = y + childHeight / 2;
                    break;
                }
                case 6: {
                    childRight = x;
                    childBottom = y + childHeight / 2;
                    break;
                }
                case 7: {
                    childRight = x + childWidth;
                    childBottom = y + childHeight;
                    break;
                }
                case 8: {
                    childRight = x + childWidth / 2;
                    childBottom = y + childHeight;
                    break;
                }
                case 9: {
                    childRight = x;
                    childBottom = y + childHeight;
                }
            }
            maxWidth = Math.max(maxWidth, childRight += lp.offsetX);
            maxHeight = Math.max(maxHeight, childBottom += lp.offsetY);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(MapView.resolveSize((int)maxWidth, (int)widthMeasureSpec), MapView.resolveSize((int)maxHeight, (int)heightMeasureSpec));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != 0 && h != 0) {
            this.mProjection = null;
            if (!this.mLayedOut) {
                this.mLayedOut = true;
                this.mController.mapViewLayedOut();
            }
            this.updateMinZoomLevel();
            if (this.mBoundingBoxToZoomOn != null) {
                this.zoomToBoundingBox(this.mBoundingBoxToZoomOn);
                this.mBoundingBoxToZoomOn = null;
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        Projection projection = this.getProjection();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int childWidth = child.getMeasuredWidth();
            projection.toMapPixels(lp.geoPoint, this.mPoint);
            int x = (int)this.mPoint.x + this.getWidth() / 2;
            int y = (int)this.mPoint.y + this.getHeight() / 2;
            int childLeft = x;
            int childTop = y;
            switch (lp.alignment) {
                case 1: {
                    childLeft = this.getPaddingLeft() + x;
                    childTop = this.getPaddingTop() + y;
                    break;
                }
                case 2: {
                    childLeft = this.getPaddingLeft() + x - childWidth / 2;
                    childTop = this.getPaddingTop() + y;
                    break;
                }
                case 3: {
                    childLeft = this.getPaddingLeft() + x - childWidth;
                    childTop = this.getPaddingTop() + y;
                    break;
                }
                case 4: {
                    childLeft = this.getPaddingLeft() + x;
                    childTop = this.getPaddingTop() + y - childHeight / 2;
                    break;
                }
                case 5: {
                    childLeft = this.getPaddingLeft() + x - childWidth / 2;
                    childTop = this.getPaddingTop() + y - childHeight / 2;
                    break;
                }
                case 6: {
                    childLeft = this.getPaddingLeft() + x - childWidth;
                    childTop = this.getPaddingTop() + y - childHeight / 2;
                    break;
                }
                case 7: {
                    childLeft = this.getPaddingLeft() + x;
                    childTop = this.getPaddingTop() + y - childHeight;
                    break;
                }
                case 8: {
                    childLeft = this.getPaddingLeft() + x - childWidth / 2;
                    childTop = this.getPaddingTop() + y - childHeight;
                    break;
                }
                case 9: {
                    childLeft = this.getPaddingLeft() + x - childWidth;
                    childTop = this.getPaddingTop() + y - childHeight;
                }
            }
            child.layout(childLeft += lp.offsetX, childTop += lp.offsetY, childLeft + childWidth, childTop + childHeight);
        }
    }

    public void onDetach() {
        this.getOverlayManager().onDetach(this);
        this.mTileProvider.detach();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean result = this.getOverlayManager().onKeyDown(keyCode, event, this);
        return result || super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean result = this.getOverlayManager().onKeyUp(keyCode, event, this);
        return result || super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        if (this.getOverlayManager().onTrackballEvent(event, this)) {
            return true;
        }
        this.scrollBy((int)(event.getX() * 25.0f), (int)(event.getY() * 25.0f));
        return super.onTrackballEvent(event);
    }

    private boolean handleTwoFingersTap(MotionEvent event) {
        int pointerCount = event.getPointerCount();
        block6: for (int i = 0; i < pointerCount; ++i) {
            int action = event.getActionMasked();
            switch (action) {
                case 0: {
                    this.multiTouchDownCount = 0;
                    continue block6;
                }
                case 1: {
                    if (!this.isAnimating() && this.canTapTwoFingers) {
                        ILatLng center = this.getProjection().fromPixels(event.getX(), event.getY());
                        this.mController.zoomOutAbout(center);
                        this.canTapTwoFingers = false;
                        this.multiTouchDownCount = 0;
                        return true;
                    }
                    this.canTapTwoFingers = false;
                    this.multiTouchDownCount = 0;
                    continue block6;
                }
                case 5: {
                    ++this.multiTouchDownCount;
                    this.canTapTwoFingers = this.multiTouchDownCount > 1;
                    continue block6;
                }
                case 6: {
                    --this.multiTouchDownCount;
                    continue block6;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouchEvent(MotionEvent event) {
        MotionEvent rotatedEvent = this.rotateTouchEvent(event);
        try {
            boolean result;
            if (this.getOverlayManager().onTouchEvent(rotatedEvent, this)) {
                Log.d((String)TAG, (String)"OverlayManager handled onTouchEvent");
                boolean bl = true;
                return bl;
            }
            if (rotatedEvent.getPointerCount() != 1) {
                this.mScaleGestureDetector.onTouchEvent(rotatedEvent);
            }
            if (!(result = this.mScaleGestureDetector.isInProgress())) {
                result = this.mGestureDetector.onTouchEvent(rotatedEvent);
            } else {
                this.canTapTwoFingers = false;
            }
            boolean bl = result |= this.handleTwoFingersTap(rotatedEvent);
            return bl;
        }
        finally {
            if (rotatedEvent != event) {
                rotatedEvent.recycle();
            }
        }
    }

    private MotionEvent rotateTouchEvent(MotionEvent ev) {
        if (this.getMapOrientation() == 0.0f) {
            return ev;
        }
        MotionEvent rotatedEvent = MotionEvent.obtain((MotionEvent)ev);
        if (Build.VERSION.SDK_INT < 11) {
            this.mRotatePoints[0] = ev.getX();
            this.mRotatePoints[1] = ev.getY();
            this.getProjection().rotatePoints(this.mRotatePoints);
            rotatedEvent.setLocation(this.mRotatePoints[0], this.mRotatePoints[1]);
        } else {
            try {
                if (sMotionEventTransformMethod == null) {
                    sMotionEventTransformMethod = MotionEvent.class.getDeclaredMethod("transform", Matrix.class);
                }
                sMotionEventTransformMethod.invoke((Object)rotatedEvent, this.getProjection().getRotationMatrix());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rotatedEvent;
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            if (this.mScroller.isFinished()) {
                this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
                if (!this.isAnimating()) {
                    this.snapItems();
                }
                this.mIsFlinging = false;
            } else {
                this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            }
            this.postInvalidate();
        }
    }

    public void updateScrollDuringAnimation() {
    }

    public final PointF getScrollPoint() {
        return this.mDScroll;
    }

    public final void setScrollPoint(PointF point) {
        this.scrollTo(point.x, point.y);
    }

    public final PointF getScalePoint() {
        return this.mMultiTouchScalePoint;
    }

    public final void setScalePoint(PointF point) {
        this.mMultiTouchScalePoint.set(point);
    }

    public void scrollTo(int x, int y) {
        this.scrollTo((double)x, (double)y);
    }

    public void scrollBy(double x, double y) {
        this.scrollTo((double)this.mDScroll.x + x, (double)this.mDScroll.y + y);
    }

    public void scrollTo(double x, double y) {
        if (this.mScrollableAreaLimit != null) {
            RectF currentLimit = this.mScrollableAreaLimit;
            double xToTestWith = x;
            double yToTestWith = y;
            float width_2 = this.getMeasuredWidth() / 2;
            float height_2 = this.getMeasuredHeight() / 2;
            if (currentLimit.width() <= width_2 * 2.0f) {
                if (xToTestWith - (double)width_2 > (double)currentLimit.left) {
                    x = currentLimit.left + width_2;
                } else if (xToTestWith + (double)width_2 < (double)currentLimit.right) {
                    x = currentLimit.right - width_2;
                }
            } else if (xToTestWith - (double)width_2 < (double)currentLimit.left) {
                x = currentLimit.left + width_2;
            } else if (xToTestWith + (double)width_2 > (double)currentLimit.right) {
                x = currentLimit.right - width_2;
            }
            if (currentLimit.height() <= height_2 * 2.0f) {
                if (yToTestWith - (double)height_2 > (double)currentLimit.top) {
                    y = currentLimit.top + height_2;
                } else if (yToTestWith + (double)height_2 < (double)currentLimit.bottom) {
                    y = currentLimit.bottom - height_2;
                }
            } else if (yToTestWith - (double)height_2 < (double)currentLimit.top) {
                y = currentLimit.top + height_2;
            } else if (yToTestWith + (double)height_2 > (double)currentLimit.bottom) {
                y = currentLimit.bottom - height_2;
            }
        }
        if (this.isAnimating()) {
            float deltaX = (float)(x - (double)this.mDScroll.x);
            float deltaY = (float)(y - (double)this.mDScroll.y);
            this.mController.offsetDeltaScroll(deltaX, deltaY);
        }
        this.mDScroll.set((float)x, (float)y);
        int intX = (int)Math.round(x);
        int intY = (int)Math.round(y);
        this.mProjection = null;
        super.scrollTo(intX, intY);
        if (this.mListeners.size() > 0) {
            ScrollEvent event = new ScrollEvent(this, intX, intY, this.mController.currentlyInUserAction());
            for (MapListener listener : this.mListeners) {
                listener.onScroll(event);
            }
        }
    }

    public void setBackgroundColor(int pColor) {
        this.mMapOverlay.setLoadingBackgroundColor(pColor);
        this.invalidate();
    }

    protected void onDraw(Canvas c) {
        super.onDraw(c);
        this.mProjection = this.updateProjection();
        c.save();
        c.translate((float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        c.scale(this.mMultiTouchScale, this.mMultiTouchScale, this.mMultiTouchScalePoint.x, this.mMultiTouchScalePoint.y);
        c.rotate(this.mapOrientation, this.mProjection.getScreenRect().exactCenterX(), this.mProjection.getScreenRect().exactCenterY());
        this.getOverlayManager().draw(c, this);
        c.restore();
    }

    private Projection updateProjection() {
        return new Projection(this);
    }

    public boolean isUsingSafeCanvas() {
        return this.getOverlayManager().isUsingSafeCanvas();
    }

    public void setUseSafeCanvas(boolean useSafeCanvas) {
        this.getOverlayManager().setUseSafeCanvas(useSafeCanvas);
    }

    protected void onDetachedFromWindow() {
        this.onDetach();
        super.onDetachedFromWindow();
    }

    public boolean isAnimating() {
        return this.mIsAnimating.get();
    }

    public TileLoadedListener getTileLoadedListener() {
        return this.tileLoadedListener;
    }

    public void setMapViewListener(MapViewListener listener) {
        this.mMapViewListener = listener;
    }

    public void setOnTileLoadedListener(TileLoadedListener aTileLoadedListener) {
        this.tileLoadedListener = aTileLoadedListener;
    }

    public void setOnTilesLoadedListener(TilesLoadedListener aTilesLoadedListener) {
        this.tilesLoadedListener = aTilesLoadedListener;
    }

    public TilesLoadedListener getTilesLoadedListener() {
        return this.tilesLoadedListener;
    }

    public String toString() {
        return "MapView {" + this.getTileProvider() + "}";
    }

    public void setDefaultPinRes(int res) {
        this.mDefaultPinRes = res;
    }

    public void setDefaultPinDrawable(Drawable drawable2) {
        this.mDefaultPinDrawable = drawable2;
    }

    public Drawable getDefaultPinDrawable() {
        if (this.mDefaultPinDrawable == null && this.mDefaultPinRes != 0) {
            BitmapFactory.Options opts = BitmapUtils.getBitmapOptions(this.getResources().getDisplayMetrics());
            this.mDefaultPinDrawable = new BitmapDrawable(this.getResources(), BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.mDefaultPinRes, (BitmapFactory.Options)opts));
        }
        return this.mDefaultPinDrawable;
    }

    public void setDefaultPinAnchor(PointF point) {
        this.mDefaultPinAnchor = point;
    }

    public PointF getDefaultPinAnchor() {
        return this.mDefaultPinAnchor;
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams
    implements MapViewLayouts {
        public ILatLng geoPoint;
        public int alignment;
        public int offsetX;
        public int offsetY;

        public LayoutParams(int width, int height, ILatLng aGeoPoint, int aAlignment, int aOffsetX, int aOffsetY) {
            super(width, height);
            this.geoPoint = aGeoPoint != null ? aGeoPoint : new LatLng(0.0, 0.0);
            this.alignment = aAlignment;
            this.offsetX = aOffsetX;
            this.offsetY = aOffsetY;
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            this.geoPoint = new LatLng(0.0, 0.0);
            this.alignment = 8;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

