/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.places.autocomplete.ui;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.mapbox.api.geocoding.v5.models.CarmenFeature;
import com.mapbox.mapboxsdk.places.R;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.ui.ResultClickCallback;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.ui.ResultItemDecoration;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.ui.SearchResultAdapter;
import java.util.ArrayList;
import java.util.List;

public class ResultView
extends LinearLayout {
    private final List<CarmenFeature> results = new ArrayList<CarmenFeature>();
    private SearchResultAdapter adapter;

    public ResultView(@NonNull Context context) {
        this(context, null);
    }

    public ResultView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public ResultView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initializeResultList();
    }

    public List<CarmenFeature> getResultsList() {
        return this.results;
    }

    public void notifyDataSetChanged() {
        this.adapter.notifyDataSetChanged();
    }

    private void initialize(Context context) {
        this.inflateView(context);
        this.adapter = new SearchResultAdapter(this.getContext(), this.results);
    }

    void inflateView(Context context) {
        ResultView.inflate((Context)context, (int)R.layout.mapbox_view_results, (ViewGroup)this);
    }

    public void setOnItemClickListener(ResultClickCallback onItemClickListener) {
        if (this.adapter != null) {
            this.adapter.setOnItemClickListener(onItemClickListener);
        }
    }

    private void initializeResultList() {
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.rv_search_results);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        layoutManager.setAutoMeasureEnabled(true);
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new ResultItemDecoration(this.getContext()));
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        recyclerView.setNestedScrollingEnabled(false);
        recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }
}

