/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.places.autocomplete;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.mapbox.api.geocoding.v5.models.CarmenFeature;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.data.SearchHistoryDatabase;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.model.PlaceOptions;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.ui.PlaceAutocompleteActivity;
import java.util.ArrayList;

public final class PlaceAutocomplete {
    private PlaceAutocomplete() {
    }

    public static CarmenFeature getPlace(Intent data) {
        String json = data.getStringExtra("com.mapbox.mapboxsdk.plugins.places.carmenfeat");
        return CarmenFeature.fromJson((String)json);
    }

    public static void clearRecentHistory(Context context) {
        SearchHistoryDatabase database = SearchHistoryDatabase.getInstance(context);
        SearchHistoryDatabase.deleteAllData(database);
    }

    public static class IntentBuilder {
        private final ArrayList<String> countries = new ArrayList();
        private final Intent intent = new Intent();

        public IntentBuilder accessToken(@NonNull String accessToken) {
            this.intent.putExtra("com.mapbox.mapboxsdk.plugins.places.accessToken", accessToken);
            return this;
        }

        public IntentBuilder placeOptions(PlaceOptions placeOptions) {
            this.intent.putExtra("com.mapbox.mapboxsdk.plugins.places.placeOptions", (Parcelable)placeOptions);
            return this;
        }

        public Intent build(Activity activity) {
            this.intent.putStringArrayListExtra("com.mapbox.mapboxsdk.plugins.places.countries", this.countries);
            this.intent.setClass((Context)activity, PlaceAutocompleteActivity.class);
            return this.intent;
        }
    }
}

