/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.places.autocomplete;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MediatorLiveData;
import android.arch.lifecycle.Observer;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.data.SearchHistoryDatabase;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.data.entity.SearchHistoryEntity;
import java.util.List;

public final class DataRepository {
    private static DataRepository instance;
    private final SearchHistoryDatabase database;
    private MediatorLiveData<List<SearchHistoryEntity>> observableSearchHistory;

    private DataRepository(final SearchHistoryDatabase database) {
        this.database = database;
        this.observableSearchHistory = new MediatorLiveData();
        this.observableSearchHistory.addSource(database.searchHistoryDao().getAll(), (Observer)new Observer<List<SearchHistoryEntity>>(){

            public void onChanged(@Nullable List<SearchHistoryEntity> searchHistoryEntities) {
                if (database.getDatabaseCreated().getValue() != null) {
                    DataRepository.this.observableSearchHistory.postValue(searchHistoryEntities);
                }
            }
        });
    }

    public static DataRepository getInstance(SearchHistoryDatabase database) {
        if (instance == null) {
            instance = new DataRepository(database);
        }
        return instance;
    }

    public LiveData<List<SearchHistoryEntity>> getSearchHistory() {
        return this.observableSearchHistory;
    }

    public void addSearchHistoryEntity(SearchHistoryEntity searchHistory) {
        SearchHistoryDatabase.insertData(this.database, searchHistory);
    }
}

