/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.locationlayer.camera;

import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.geometry.LatLng;

public class LatLngAnimator
extends ValueAnimator {
    private LatLng target;

    public LatLngAnimator(@NonNull LatLng previous, @NonNull LatLng target) {
        this.setObjectValues(new Object[]{previous, target});
        this.setEvaluator(new LatLngEvaluator());
        this.target = target;
    }

    public LatLng getTarget() {
        return this.target;
    }

    private static class LatLngEvaluator
    implements TypeEvaluator<LatLng> {
        private final LatLng latLng = new LatLng();

        private LatLngEvaluator() {
        }

        public LatLng evaluate(float fraction, LatLng startValue, LatLng endValue) {
            this.latLng.setLatitude(startValue.getLatitude() + (endValue.getLatitude() - startValue.getLatitude()) * (double)fraction);
            this.latLng.setLongitude(startValue.getLongitude() + (endValue.getLongitude() - startValue.getLongitude()) * (double)fraction);
            return this.latLng;
        }
    }
}

