/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.locationlayer;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.WindowManager;
import com.mapbox.mapboxsdk.plugins.locationlayer.CompassListener;
import java.util.ArrayList;
import java.util.List;
import timber.log.Timber;

class CompassManager
implements SensorEventListener {
    private static final int SENSOR_DELAY_MICROS = 100000;
    private final WindowManager windowManager;
    private final SensorManager sensorManager;
    private final List<CompassListener> compassListeners = new ArrayList<CompassListener>();
    @Nullable
    private Sensor compassSensor;
    private int lastAccuracy;
    private float lastHeading;
    private long compassUpdateNextTimestamp;

    CompassManager(@NonNull Context context) {
        this.windowManager = (WindowManager)context.getSystemService("window");
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.compassSensor = this.sensorManager.getDefaultSensor(11);
        if (this.compassSensor == null) {
            Timber.d((String)"Rotation vector sensor not supported on device, falling back to orientation.", (Object[])new Object[0]);
            this.compassSensor = this.sensorManager.getDefaultSensor(3);
        }
    }

    void addCompassListener(@NonNull CompassListener compassListener) {
        if (this.compassListeners.isEmpty()) {
            this.onStart();
        }
        this.compassListeners.add(compassListener);
    }

    void removeCompassListener(@NonNull CompassListener compassListener) {
        this.compassListeners.remove(compassListener);
        if (this.compassListeners.isEmpty()) {
            this.onStop();
        }
    }

    void onStart() {
        if (this.isSensorAvailable()) {
            this.sensorManager.registerListener((SensorEventListener)this, this.compassSensor, 100000);
        }
    }

    void onStop() {
        if (this.isSensorAvailable()) {
            this.sensorManager.unregisterListener((SensorEventListener)this, this.compassSensor);
        }
    }

    boolean isSensorAvailable() {
        return this.compassSensor != null;
    }

    public void onSensorChanged(SensorEvent event) {
        long currentTime = SystemClock.elapsedRealtime();
        if (currentTime < this.compassUpdateNextTimestamp) {
            return;
        }
        if (this.lastAccuracy == 0) {
            Timber.d((String)"Compass sensor is unreliable, device calibration is needed.", (Object[])new Object[0]);
            return;
        }
        if (event.sensor.getType() == 11) {
            this.updateOrientation(event.values);
            this.compassUpdateNextTimestamp = currentTime + 500L;
        } else if (event.sensor.getType() == 3) {
            this.notifyCompassChangeListeners((event.values[0] + 360.0f) % 360.0f);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        if (this.lastAccuracy != accuracy) {
            for (CompassListener compassListener : this.compassListeners) {
                compassListener.onCompassAccuracyChange(accuracy);
            }
            this.lastAccuracy = accuracy;
        }
    }

    private void updateOrientation(float[] rotationVector) {
        int worldAxisForDeviceAxisY;
        int worldAxisForDeviceAxisX;
        float[] rotationMatrix = new float[9];
        SensorManager.getRotationMatrixFromVector((float[])rotationMatrix, (float[])rotationVector);
        switch (this.windowManager.getDefaultDisplay().getRotation()) {
            case 1: {
                worldAxisForDeviceAxisX = 3;
                worldAxisForDeviceAxisY = 129;
                break;
            }
            case 2: {
                worldAxisForDeviceAxisX = 129;
                worldAxisForDeviceAxisY = 131;
                break;
            }
            case 3: {
                worldAxisForDeviceAxisX = 131;
                worldAxisForDeviceAxisY = 1;
                break;
            }
            default: {
                worldAxisForDeviceAxisX = 1;
                worldAxisForDeviceAxisY = 3;
            }
        }
        float[] adjustedRotationMatrix = new float[9];
        SensorManager.remapCoordinateSystem((float[])rotationMatrix, (int)worldAxisForDeviceAxisX, (int)worldAxisForDeviceAxisY, (float[])adjustedRotationMatrix);
        float[] orientation = new float[3];
        SensorManager.getOrientation((float[])adjustedRotationMatrix, (float[])orientation);
        this.notifyCompassChangeListeners((float)Math.toDegrees(orientation[0]));
    }

    private void notifyCompassChangeListeners(float heading) {
        for (CompassListener compassListener : this.compassListeners) {
            compassListener.onCompassChanged(heading);
        }
        this.lastHeading = heading;
    }

    int getLastAccuracy() {
        return this.lastAccuracy;
    }

    float getLastHeading() {
        return this.lastHeading;
    }
}

