/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.localization;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class MapLocale {
    public static final String LOCAL_NAME = "name";
    public static final String ENGLISH = "name_en";
    public static final String FRENCH = "name_fr";
    public static final String ARABIC = "name_ar";
    public static final String SPANISH = "name_es";
    public static final String GERMAN = "name_de";
    public static final String PORTUGUESE = "name_pt";
    public static final String RUSSIAN = "name_ru";
    public static final String CHINESE = "name_zh";
    static final String TRADITIONAL_CHINESE = "name_zh-Hant";
    public static final String SIMPLIFIED_CHINESE = "name_zh-Hans";
    public static final String JAPANESE = "name_ja";
    public static final String KOREAN = "name_ko";
    static final LatLngBounds USA_BBOX = new LatLngBounds.Builder().include(new LatLng(49.388611, -124.733253)).include(new LatLng(24.544245, -66.954811)).build();
    static final LatLngBounds UK_BBOX = new LatLngBounds.Builder().include(new LatLng(59.360249, -8.623555)).include(new LatLng(49.906193, 1.759)).build();
    static final LatLngBounds CANADA_BBOX = new LatLngBounds.Builder().include(new LatLng(83.110626, -141.0)).include(new LatLng(41.67598, -52.636291)).build();
    static final LatLngBounds CHINA_BBOX = new LatLngBounds.Builder().include(new LatLng(53.56086, 73.557693)).include(new LatLng(15.775416, 134.773911)).build();
    static final LatLngBounds TAIWAN_BBOX = new LatLngBounds.Builder().include(new LatLng(26.389444, 118.115255566105)).include(new LatLng(21.733333, 122.107778)).build();
    static final LatLngBounds GERMANY_BBOX = new LatLngBounds.Builder().include(new LatLng(55.055637, 5.865639)).include(new LatLng(47.275776, 15.039889)).build();
    static final LatLngBounds KOREA_BBOX = new LatLngBounds.Builder().include(new LatLng(38.612446, 125.887108)).include(new LatLng(33.190945, 129.584671)).build();
    static final LatLngBounds JAPAN_BBOX = new LatLngBounds.Builder().include(new LatLng(45.52314, 122.93853)).include(new LatLng(24.249472, 145.820892)).build();
    static final LatLngBounds FRANCE_BBOX = new LatLngBounds.Builder().include(new LatLng(51.092804, -5.142222)).include(new LatLng(41.371582, 9.561556)).build();
    static final LatLngBounds RUSSIA_BBOX = new LatLngBounds.Builder().include(new LatLng(81.856903, -168.997849)).include(new LatLng(41.185902, 19.638861)).build();
    static final LatLngBounds SPAIN_BBOX = new LatLngBounds.Builder().include(new LatLng(27.4335426, -18.3936845)).include(new LatLng(43.9933088, 4.5918885)).build();
    static final LatLngBounds PORTUGAL_BBOX = new LatLngBounds.Builder().include(new LatLng(27.4335426, -18.3936845)).include(new LatLng(42.280468655, -6.3890876937)).build();
    static final LatLngBounds BRAZIL_BBOX = new LatLngBounds.Builder().include(new LatLng(5.2842873, -33.8689056)).include(new LatLng(-28.6341164, -73.9830625)).build();
    public static final MapLocale FRANCE = new MapLocale("name_fr", FRANCE_BBOX);
    public static final MapLocale GERMANY = new MapLocale("name_de", GERMANY_BBOX);
    public static final MapLocale JAPAN = new MapLocale("name_ja", JAPAN_BBOX);
    public static final MapLocale KOREA = new MapLocale("name_ko", KOREA_BBOX);
    public static final MapLocale CHINA = new MapLocale("name_zh-Hans", CHINA_BBOX);
    public static final MapLocale TAIWAN = new MapLocale("name_zh-Hant", TAIWAN_BBOX);
    public static final MapLocale CHINESE_HANS = new MapLocale("name_zh-Hans");
    public static final MapLocale CHINESE_HANT = new MapLocale("name_zh-Hant");
    public static final MapLocale UK = new MapLocale("name_en", UK_BBOX);
    public static final MapLocale US = new MapLocale("name_en", USA_BBOX);
    public static final MapLocale CANADA = new MapLocale("name_en", CANADA_BBOX);
    public static final MapLocale CANADA_FRENCH = new MapLocale("name_fr", CANADA_BBOX);
    public static final MapLocale RUSSIA = new MapLocale("name_ru", RUSSIA_BBOX);
    public static final MapLocale SPAIN = new MapLocale("name_es", SPAIN_BBOX);
    public static final MapLocale PORTUGAL = new MapLocale("name_pt", PORTUGAL_BBOX);
    public static final MapLocale BRAZIL = new MapLocale("name_pt", BRAZIL_BBOX);
    private static final Map<Locale, MapLocale> LOCALE_SET = new HashMap<Locale, MapLocale>();
    private final LatLngBounds countryBounds;
    private final String mapLanguage;

    public MapLocale(@NonNull String mapLanguage) {
        this(mapLanguage, null);
    }

    public MapLocale(@NonNull LatLngBounds countryBounds) {
        this(LOCAL_NAME, countryBounds);
    }

    public MapLocale(@NonNull String mapLanguage, @Nullable LatLngBounds countryBounds) {
        this.countryBounds = countryBounds;
        this.mapLanguage = mapLanguage;
    }

    @NonNull
    public String getMapLanguage() {
        return this.mapLanguage;
    }

    @Nullable
    public LatLngBounds getCountryBounds() {
        return this.countryBounds;
    }

    public static void addMapLocale(@NonNull Locale locale, @NonNull MapLocale mapLocale) {
        LOCALE_SET.put(locale, mapLocale);
    }

    @Nullable
    public static MapLocale getMapLocale(@NonNull Locale locale) {
        return MapLocale.getMapLocale(locale, false);
    }

    @Nullable
    public static MapLocale getMapLocale(@NonNull Locale locale, boolean acceptFallback) {
        MapLocale foundLocale = LOCALE_SET.get(locale);
        if (acceptFallback && foundLocale == null) {
            foundLocale = MapLocale.getMapLocaleFallback(locale);
        }
        return foundLocale;
    }

    @Nullable
    private static MapLocale getMapLocaleFallback(@NonNull Locale locale) {
        String fallbackCode = locale.getLanguage().substring(0, 2);
        MapLocale foundMapLocale = null;
        for (Locale possibleLocale : LOCALE_SET.keySet()) {
            if (!possibleLocale.getLanguage().equals(fallbackCode)) continue;
            foundMapLocale = LOCALE_SET.get(possibleLocale);
            break;
        }
        return foundMapLocale;
    }

    static {
        LOCALE_SET.put(Locale.US, US);
        LOCALE_SET.put(Locale.CANADA_FRENCH, CANADA_FRENCH);
        LOCALE_SET.put(Locale.CANADA, CANADA);
        LOCALE_SET.put(Locale.CHINA, CHINESE_HANS);
        LOCALE_SET.put(Locale.TAIWAN, TAIWAN);
        LOCALE_SET.put(Locale.UK, UK);
        LOCALE_SET.put(Locale.JAPAN, JAPAN);
        LOCALE_SET.put(Locale.KOREA, KOREA);
        LOCALE_SET.put(Locale.GERMANY, GERMANY);
        LOCALE_SET.put(Locale.FRANCE, FRANCE);
        LOCALE_SET.put(new Locale("ru", "RU"), RUSSIA);
        LOCALE_SET.put(new Locale("es", "ES"), SPAIN);
        LOCALE_SET.put(new Locale("pt", "PT"), PORTUGAL);
        LOCALE_SET.put(new Locale("pt", "BR"), BRAZIL);
        if (Build.VERSION.SDK_INT >= 21) {
            Locale zh_CN_Hans = new Locale.Builder().setLanguage("zh").setRegion("CN").setScript("Hans").build();
            Locale zh_HK_Hans = new Locale.Builder().setLanguage("zh").setRegion("HK").setScript("Hans").build();
            Locale zh_MO_Hans = new Locale.Builder().setLanguage("zh").setRegion("MO").setScript("Hans").build();
            Locale zh_SG_Hans = new Locale.Builder().setLanguage("zh").setRegion("SG").setScript("Hans").build();
            Locale zh_TW_Hant = new Locale.Builder().setLanguage("zh").setRegion("TW").setScript("Hant").build();
            Locale zh_HK_Hant = new Locale.Builder().setLanguage("zh").setRegion("HK").setScript("Hant").build();
            Locale zh_MO_Hant = new Locale.Builder().setLanguage("zh").setRegion("MO").setScript("Hant").build();
            LOCALE_SET.put(zh_CN_Hans, CHINESE_HANS);
            LOCALE_SET.put(zh_HK_Hans, CHINESE_HANS);
            LOCALE_SET.put(zh_MO_Hans, CHINESE_HANS);
            LOCALE_SET.put(zh_SG_Hans, CHINESE_HANS);
            LOCALE_SET.put(zh_TW_Hant, TAIWAN);
            LOCALE_SET.put(zh_HK_Hant, CHINESE_HANT);
            LOCALE_SET.put(zh_MO_Hant, CHINESE_HANT);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Languages {
    }
}

