/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.pdf;

import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.forms.FieldSet;
import com.manydesigns.elements.forms.Form;
import com.manydesigns.elements.xml.XmlBuffer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;

public class FormPdfExporter {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    private final Form form;
    private final Source xsltSource;
    private String title;

    public FormPdfExporter(Form form, Source xsltSource) {
        this.form = form;
        this.xsltSource = xsltSource;
    }

    public void export(OutputStream out) throws FOPException, IOException, TransformerException {
        FopFactory fopFactory = FopFactory.newInstance((URI)new File(".").toURI());
        Fop fop = fopFactory.newFop("application/pdf", out);
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = factory.newTransformer(this.xsltSource);
        transformer.setParameter("versionParam", "2.0");
        Reader reader = this.composeXml();
        StreamSource src = new StreamSource(reader);
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        transformer.transform(src, res);
        reader.close();
        out.flush();
    }

    protected Reader composeXml() {
        XmlBuffer xb = new XmlBuffer();
        xb.writeXmlHeader("UTF-8");
        xb.openElement("class");
        xb.openElement("table");
        if (this.title != null) {
            xb.write(this.title);
        }
        xb.closeElement("table");
        for (FieldSet fieldset : this.form) {
            xb.openElement("tableData");
            xb.openElement("rows");
            for (Field field : fieldset.fields()) {
                xb.openElement("row");
                xb.openElement("nameColumn");
                xb.write(field.getLabel());
                xb.closeElement("nameColumn");
                xb.openElement("value");
                xb.write(field.getStringValue());
                xb.closeElement("value");
                xb.closeElement("row");
            }
            xb.closeElement("rows");
            xb.closeElement("tableData");
        }
        xb.closeElement("class");
        return new StringReader(xb.toString());
    }

    public Form getForm() {
        return this.form;
    }

    public Source getXsltSource() {
        return this.xsltSource;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

