/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.Mode;
import com.manydesigns.elements.fields.TextField;
import com.manydesigns.elements.reflection.PropertyAccessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExpTextField
extends TextField {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    protected final Pattern pattern;
    protected String errorString;

    public RegExpTextField(PropertyAccessor accessor, Mode mode, String regExp) {
        this(accessor, mode, null, regExp);
    }

    public RegExpTextField(PropertyAccessor accessor, Mode mode, String prefix, String regExp) {
        super(accessor, mode, prefix);
        this.pattern = Pattern.compile(regExp);
        this.setErrorString(this.getText("", regExp));
    }

    @Override
    public boolean validate() {
        if (this.mode.isView(this.insertable, this.updatable) || this.mode.isBulk() && !this.bulkChecked) {
            return true;
        }
        if (!super.validate()) {
            return false;
        }
        if (this.stringValue == null || this.stringValue.length() == 0) {
            return true;
        }
        Matcher matcher = this.pattern.matcher(this.stringValue);
        if (!matcher.matches()) {
            this.errors.add(this.errorString);
            return false;
        }
        return true;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public void setErrorString(String errorString) {
        this.errorString = errorString;
    }
}

