/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.xls;

import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.forms.TableForm;
import com.manydesigns.elements.xls.XlsUtil;
import java.io.IOException;
import java.io.OutputStream;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.lang.StringUtils;

public class TableFormXlsExporter {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    private final TableForm form;
    private String title;
    private boolean useTemporaryFileDuringWrite = false;

    public TableFormXlsExporter(TableForm form) {
        this.form = form;
    }

    public void export(OutputStream outputStream) throws IOException, WriteException {
        WorkbookSettings workbookSettings = new WorkbookSettings();
        workbookSettings.setUseTemporaryFileDuringWrite(this.useTemporaryFileDuringWrite);
        WritableWorkbook workbook = Workbook.createWorkbook((OutputStream)outputStream, (WorkbookSettings)workbookSettings);
        if (StringUtils.isBlank((String)this.title)) {
            this.title = "export";
        }
        WritableSheet sheet = workbook.createSheet(this.title, 0);
        this.addHeaderToSheet(sheet);
        int i = 1;
        for (TableForm.Row row : this.form.getRows()) {
            this.exportRows(sheet, i, row);
            ++i;
        }
        int count = this.form.getColumns().length;
        XlsUtil.autoSizeColumns(sheet, count);
        workbook.write();
        workbook.close();
        outputStream.flush();
    }

    private void addHeaderToSheet(WritableSheet sheet) throws WriteException {
        WritableCellFormat formatCell = this.headerExcel();
        int l = 0;
        for (TableForm.Column col : this.form.getColumns()) {
            sheet.addCell((WritableCell)new Label(l, 0, col.getLabel(), (CellFormat)formatCell));
            ++l;
        }
    }

    private void exportRows(WritableSheet sheet, int i, TableForm.Row row) throws WriteException {
        int j = 0;
        for (Field field : row) {
            XlsUtil.addFieldToCell(sheet, i, j, field);
            ++j;
        }
    }

    private WritableCellFormat headerExcel() {
        WritableFont fontCell = new WritableFont(WritableFont.ARIAL, 12, WritableFont.BOLD, false);
        return new WritableCellFormat(fontCell);
    }

    public TableForm getForm() {
        return this.form;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isUseTemporaryFileDuringWrite() {
        return this.useTemporaryFileDuringWrite;
    }

    public void setUseTemporaryFileDuringWrite(boolean useTemporaryFileDuringWrite) {
        this.useTemporaryFileDuringWrite = useTemporaryFileDuringWrite;
    }
}

