/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.util;

import java.io.File;
import java.text.MessageFormat;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomUtil {
    public static final String copyright = "Copyright (C) 2005-2017 ManyDesigns srl";
    public static final int RANDOM_CODE_LENGTH = 25;
    public static final Logger logger = LoggerFactory.getLogger(RandomUtil.class);
    protected static final File tempDir = new File(System.getProperty("java.io.tmpdir", "/tmp"));

    public static File getTempDir() {
        return tempDir;
    }

    public static String createRandomId() {
        return RandomUtil.createRandomId(25);
    }

    public static String createRandomId(int length) {
        return RandomStringUtils.random((int)length, (String)"abcdefghijklmnopqrstuvwxyz0123456789");
    }

    public static File getTempCodeFile(String fileNameFormat, String randomCode) {
        return RandomUtil.getCodeFile(tempDir, fileNameFormat, randomCode);
    }

    public static File getCodeFile(File dir, String fileNameFormat, String code) {
        return new File(dir, RandomUtil.getCodeFileName(fileNameFormat, code));
    }

    public static String getCodeFileName(String fileNameFormat, String randomCode) {
        return MessageFormat.format(fileNameFormat, randomCode);
    }
}

