/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.ElementsProperties;
import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.KeyValueAccessor;
import com.manydesigns.elements.Mode;
import com.manydesigns.elements.annotations.ColSpan;
import com.manydesigns.elements.annotations.CssClass;
import com.manydesigns.elements.annotations.Enabled;
import com.manydesigns.elements.annotations.ForceNewRow;
import com.manydesigns.elements.annotations.Help;
import com.manydesigns.elements.annotations.Id;
import com.manydesigns.elements.annotations.InputName;
import com.manydesigns.elements.annotations.Insertable;
import com.manydesigns.elements.annotations.Required;
import com.manydesigns.elements.annotations.Updatable;
import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.fields.FieldUtils;
import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.xml.XhtmlBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractField<T>
implements Field<T> {
    public static final String COPYRIGHT = "Copyright (C) 2005-2017 ManyDesigns srl";
    public static final String INPUT_CONTAINER_CSS_CLASS = "input-container";
    public static final String FORM_LABEL_CSS_CLASS = "control-label";
    public static final String EDITABLE_FIELD_CSS_CLASS = "form-control";
    public static final String STATIC_VALUE_CSS_CLASS = "form-control-static";
    protected final Configuration elementsConfiguration;
    protected final PropertyAccessor accessor;
    protected final Mode mode;
    protected String id;
    protected String bulkCheckboxName;
    protected boolean bulkChecked;
    protected String inputName;
    protected String label;
    protected String href;
    protected String title;
    protected boolean required = false;
    protected boolean enabled = true;
    protected boolean insertable = true;
    protected boolean updatable = true;
    protected boolean forceNewRow = false;
    protected int colSpan = 1;
    protected String help;
    @NotNull
    protected String fieldCssClass;
    protected List<String> errors = new ArrayList<String>();
    public static final Logger logger = LoggerFactory.getLogger(AbstractField.class);

    public AbstractField(@NotNull PropertyAccessor accessor, @NotNull Mode mode) {
        this(accessor, mode, null);
    }

    public AbstractField(@NotNull PropertyAccessor accessor, @NotNull Mode mode, @Nullable String prefix) {
        Required requiredAnnotation;
        Updatable updatableAnnotation;
        Insertable insertableAnnotation;
        Enabled enabledAnnotation;
        this.elementsConfiguration = ElementsProperties.getConfiguration();
        this.accessor = accessor;
        this.mode = mode;
        String localId = accessor.isAnnotationPresent(Id.class) ? accessor.getAnnotation(Id.class).value() : accessor.getName();
        Object[] idArgs = new Object[]{prefix, localId};
        this.id = StringUtils.join((Object[])idArgs);
        String localInputName = accessor.isAnnotationPresent(InputName.class) ? accessor.getAnnotation(InputName.class).value() : accessor.getName();
        Object[] inputNameArgs = new Object[]{prefix, localInputName};
        this.inputName = StringUtils.join((Object[])inputNameArgs);
        Object[] bulkInputNameArgs = new Object[]{this.inputName, "_bulk"};
        this.bulkCheckboxName = StringUtils.join((Object[])bulkInputNameArgs);
        this.label = FieldUtils.getLabel(accessor);
        if (accessor.isAnnotationPresent(Help.class)) {
            this.help = accessor.getAnnotation(Help.class).value();
            logger.debug("Help annotation present with value: {}", (Object)this.help);
            this.help = this.getText(this.help, new Object[0]);
        }
        if ((enabledAnnotation = accessor.getAnnotation(Enabled.class)) != null) {
            this.enabled = enabledAnnotation.value();
            logger.debug("Enabled annotation present with value: {}", (Object)this.enabled);
        }
        if ((insertableAnnotation = accessor.getAnnotation(Insertable.class)) != null) {
            this.insertable = insertableAnnotation.value();
            logger.debug("Insertable annotation present with value: {}", (Object)this.insertable);
        }
        if ((updatableAnnotation = accessor.getAnnotation(Updatable.class)) != null) {
            this.updatable = updatableAnnotation.value();
            logger.debug("Updatable annotation present with value: {}", (Object)this.updatable);
        }
        if ((requiredAnnotation = accessor.getAnnotation(Required.class)) != null) {
            this.required = requiredAnnotation.value();
            logger.debug("Required annotation present with value: {}", (Object)this.required);
        }
        if (accessor.isAnnotationPresent(ForceNewRow.class)) {
            this.forceNewRow = true;
            logger.debug("ForceNewRow annotation present");
        }
        if (accessor.isAnnotationPresent(ColSpan.class)) {
            this.colSpan = accessor.getAnnotation(ColSpan.class).value();
            logger.debug("ColSpan annotation present with value: " + this.colSpan);
        }
        if (accessor.isAnnotationPresent(CssClass.class)) {
            Object[] cssClasses = accessor.getAnnotation(CssClass.class).value();
            this.fieldCssClass = StringUtils.join((Object[])cssClasses, (String)" ");
        } else {
            this.fieldCssClass = "";
        }
    }

    @Override
    public void toXhtml(@NotNull XhtmlBuffer xb) {
        if (this.isReadOnly()) {
            this.openVisibleField(xb);
            this.valueToXhtml(xb);
            this.closeVisibleField(xb);
        } else if (this.mode.isEdit()) {
            this.openVisibleField(xb);
            this.valueToXhtml(xb);
            this.helpToXhtml(xb);
            this.errorsToXhtml(xb);
            this.closeVisibleField(xb);
        } else if (this.mode.isPreview()) {
            this.openVisibleField(xb);
            this.valueToXhtml(xb);
            this.closeVisibleField(xb);
        } else if (this.mode.isHidden()) {
            this.valueToXhtml(xb);
        } else {
            throw new IllegalStateException("Unknown mode: " + (Object)((Object)this.mode));
        }
    }

    protected void openVisibleField(XhtmlBuffer xb) {
        xb.openElement("div");
        String cssClass = "form-group";
        cssClass = this.isReadOnly() ? cssClass + " readonly" : cssClass + " readwrite";
        if (this.isBlank()) {
            cssClass = cssClass + " no-value";
        }
        if (!this.isValid()) {
            cssClass = cssClass + " has-error";
        }
        if (this.hasRequiredFields()) {
            cssClass = cssClass + " required";
        }
        xb.addAttribute("class", cssClass);
        this.labelToXhtml(xb);
        xb.openElement("div");
        xb.addAttribute("class", "input-container " + this.fieldCssClass);
    }

    public boolean isValid() {
        return this.errors.isEmpty();
    }

    public boolean isReadOnly() {
        return this.mode.isView(this.insertable, this.updatable);
    }

    public boolean isBlank() {
        return StringUtils.isBlank((String)this.getStringValue());
    }

    protected void closeVisibleField(XhtmlBuffer xb) {
        xb.closeElement("div");
        xb.closeElement("div");
    }

    @Override
    public void labelToXhtml(XhtmlBuffer xb) {
        boolean capitalize;
        if (StringUtils.isBlank((String)this.label)) {
            return;
        }
        xb.openElement("label");
        if (!this.isReadOnly()) {
            xb.addAttribute("for", this.id);
        }
        xb.addAttribute("class", FORM_LABEL_CSS_CLASS);
        if (this.mode.isBulk() && this.mode.isEdit() && !this.isReadOnly()) {
            String cid = this.id + "_check";
            xb.openElement("div");
            xb.addAttribute("class", "pull-left checkbox");
            xb.writeInputCheckbox(cid, this.bulkCheckboxName, "checked", this.bulkChecked, false, "");
            xb.openElement("label");
            xb.addAttribute("for", cid);
            xb.addAttribute("class", "pull-left");
            xb.closeElement("label");
            xb.closeElement("div");
        }
        String actualLabel = (capitalize = this.elementsConfiguration.getBoolean("fields.label.capitalize")) ? StringUtils.capitalize((String)this.label) : this.label;
        xb.write(actualLabel);
        xb.closeElement("label");
    }

    @Override
    public void helpToXhtml(XhtmlBuffer xb) {
        if (this.help != null) {
            xb.openElement("span");
            xb.addAttribute("class", "help-block");
            xb.write(this.help);
            xb.closeElement("span");
        }
    }

    @Override
    public void errorsToXhtml(XhtmlBuffer xb) {
        if (!this.isValid()) {
            xb.openElement("span");
            xb.addAttribute("class", "help-block");
            for (String error : this.errors) {
                xb.write(error);
                xb.writeBr();
            }
            xb.closeElement("span");
        }
    }

    public String getText(String key, Object ... args) {
        return ElementsThreadLocals.getTextProvider().getText(key, args);
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        this.bulkChecked = req.getParameter(this.bulkCheckboxName) != null;
    }

    @Override
    public void readFromObject(Object obj) {
    }

    @Override
    public void readFrom(KeyValueAccessor keyValueAccessor) {
        if (this.isReadOnly()) {
            return;
        }
        if (!keyValueAccessor.has(this.accessor.getName())) {
            return;
        }
        Object value = keyValueAccessor.get(this.accessor.getName());
        if (value instanceof String) {
            this.setStringValue((String)value);
        } else {
            this.setValue(this.maybeConvertValue(value));
        }
    }

    protected T maybeConvertValue(Object value) {
        return (T)value;
    }

    @Override
    public void writeTo(KeyValueAccessor keyValueAccessor) {
        keyValueAccessor.set(this.accessor.getName(), this.getValue());
    }

    @Override
    public String getDisplayValue() {
        return this.getStringValue();
    }

    @Override
    public PropertyAccessor getPropertyAccessor() {
        return this.accessor;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getInputName() {
        return this.inputName;
    }

    @Override
    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    @Override
    public void setHelp(String help) {
        this.help = help;
    }

    @Override
    public Mode getMode() {
        return this.mode;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    @Override
    public boolean isForceNewRow() {
        return this.forceNewRow;
    }

    @Override
    public void setForceNewRow(boolean forceNewRow) {
        this.forceNewRow = forceNewRow;
    }

    @Override
    public int getColSpan() {
        return this.colSpan;
    }

    @Override
    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean hasRequiredFields() {
        return this.required && !this.isReadOnly();
    }

    @NotNull
    public String getFieldCssClass() {
        return this.fieldCssClass;
    }

    public void setFieldCssClass(@NotNull String fieldCssClass) {
        this.fieldCssClass = fieldCssClass;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void writeToObject(@NotNull Object obj, @Nullable Object value) {
        this.writeToObject(this.accessor, obj, value);
    }

    protected void writeToObject(@NotNull PropertyAccessor accessor, @NotNull Object obj, @Nullable Object value) {
        if (this.isReadOnly() || this.mode.isBulk() && !this.bulkChecked) {
            return;
        }
        Object convertedValue = OgnlUtils.convertValue(value, accessor.getType());
        accessor.set(obj, convertedValue);
    }
}

