/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.Mode;
import com.manydesigns.elements.annotations.MaxLength;
import com.manydesigns.elements.blobs.Blob;
import com.manydesigns.elements.blobs.BlobManager;
import com.manydesigns.elements.fields.AbstractField;
import com.manydesigns.elements.fields.MultipartRequestField;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.util.MemoryUtil;
import com.manydesigns.elements.xml.XhtmlBuffer;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.controller.StripesRequestWrapper;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

public abstract class AbstractBlobField
extends AbstractField<Blob>
implements MultipartRequestField<Blob> {
    public static final String copyright = "Copyright (C) 2005-2017 ManyDesigns srl";
    public static final String UPLOAD_KEEP = "_keep";
    public static final String UPLOAD_MODIFY = "_modify";
    public static final String UPLOAD_DELETE = "_delete";
    public static final String OPERATION_SUFFIX = "_operation";
    public static final String CODE_SUFFIX = "_code";
    public static final String INNER_SUFFIX = "_inner";
    protected final int size;
    protected String innerId;
    protected String operationInputName;
    protected String codeInputName;
    protected Blob blob;
    protected String blobError;

    public AbstractBlobField(PropertyAccessor accessor, Mode mode) {
        this(accessor, mode, null);
    }

    public AbstractBlobField(@NotNull PropertyAccessor accessor, @NotNull Mode mode, @Nullable String prefix) {
        super(accessor, mode, prefix);
        this.innerId = this.id + INNER_SUFFIX;
        this.operationInputName = this.inputName + OPERATION_SUFFIX;
        this.codeInputName = this.inputName + CODE_SUFFIX;
        this.size = accessor.isAnnotationPresent(MaxLength.class) ? Math.min(25, accessor.getAnnotation(MaxLength.class).value()) : 25;
    }

    @Override
    public void valueToXhtml(XhtmlBuffer xb) {
        if (this.mode.isView(this.insertable, this.updatable)) {
            this.valueToXhtmlView(xb);
        } else if (this.mode.isEdit()) {
            this.valueToXhtmlEdit(xb);
        } else if (this.mode.isPreview()) {
            this.valueToXhtmlPreview(xb);
        } else if (this.mode.isHidden()) {
            this.valueToXhtmlHidden(xb);
        } else {
            throw new IllegalStateException("Unknown mode: " + (Object)((Object)this.mode));
        }
    }

    @Override
    public String getStringValue() {
        if (this.blob == null) {
            return null;
        }
        return this.blob.getFilename();
    }

    @Override
    public void setStringValue(String stringValue) {
        if (this.blob != null) {
            this.blob.setFilename(stringValue);
        }
    }

    public void valueToXhtmlPreview(XhtmlBuffer xb) {
        this.valueToXhtmlView(xb);
        this.valueToXhtmlHidden(xb);
    }

    private void valueToXhtmlHidden(XhtmlBuffer xb) {
        xb.writeInputHidden(this.operationInputName, UPLOAD_KEEP);
        if (this.blob != null) {
            xb.writeInputHidden(this.codeInputName, this.blob.getCode());
        }
    }

    public void valueToXhtmlView(XhtmlBuffer xb) {
        xb.openElement("p");
        xb.addAttribute("id", this.id);
        xb.addAttribute("class", "form-control-static");
        if (this.blobError != null) {
            xb.openElement("div");
            xb.addAttribute("class", "blob-error");
            xb.write(this.blobError);
            xb.closeElement("div");
        } else if (this.blob != null) {
            this.writeBlobFilenameAndSize(xb);
        }
        xb.closeElement("p");
    }

    public void writeBlobFilenameAndSize(XhtmlBuffer xb) {
        if (this.href != null) {
            xb.openElement("a");
            xb.addAttribute("href", this.href);
        }
        xb.write(this.blob.getFilename());
        if (this.href != null) {
            xb.closeElement("a");
        }
        xb.write(" (");
        xb.write(MemoryUtil.bytesToHumanString(this.blob.getSize()));
        xb.write(")");
    }

    private void valueToXhtmlEdit(XhtmlBuffer xb) {
        if (this.blob == null || this.blobError != null) {
            xb.writeInputHidden(this.operationInputName, UPLOAD_MODIFY);
            xb.writeInputFile(this.id, this.inputName, false);
        } else {
            xb.openElement("p");
            xb.addAttribute("class", "form-control-static");
            xb.addAttribute("id", this.id);
            this.writeBlobFilenameAndSize(xb);
            xb.closeElement("p");
            xb.openElement("div");
            xb.addAttribute("class", "radio radio-inline");
            String radioId = this.id + UPLOAD_KEEP;
            String script = "var inptxt = this.ownerDocument.getElementById('" + StringEscapeUtils.escapeJavaScript((String)this.innerId) + "');inptxt.disabled=true;inptxt.value='';";
            script = script + "$('#" + StringEscapeUtils.escapeJavaScript((String)this.innerId) + "').fileinput('disable');";
            script = script + "$('#fileinput_" + StringEscapeUtils.escapeJavaScript((String)this.id) + "').hide();";
            this.printRadio(xb, radioId, "elements.field.upload.keep", UPLOAD_KEEP, true, script);
            radioId = this.id + UPLOAD_MODIFY;
            script = "var inptxt = this.ownerDocument.getElementById('" + StringEscapeUtils.escapeJavaScript((String)this.innerId) + "');inptxt.disabled=false;inptxt.value='';";
            script = script + "$('#" + StringEscapeUtils.escapeJavaScript((String)this.innerId) + "').fileinput('enable');";
            script = script + "$('#fileinput_" + StringEscapeUtils.escapeJavaScript((String)this.id) + "').show();";
            this.printRadio(xb, radioId, "elements.field.upload.update", UPLOAD_MODIFY, false, script);
            if (!this.isRequired()) {
                radioId = this.id + UPLOAD_DELETE;
                script = "var inptxt = this.ownerDocument.getElementById('" + StringEscapeUtils.escapeJavaScript((String)this.innerId) + "');inptxt.disabled=true;inptxt.value='';";
                script = script + "$('#" + StringEscapeUtils.escapeJavaScript((String)this.innerId) + "').fileinput('disable');";
                script = script + "$('#fileinput_" + StringEscapeUtils.escapeJavaScript((String)this.id) + "').hide();";
                this.printRadio(xb, radioId, "elements.field.upload.delete", UPLOAD_DELETE, false, script);
            }
            xb.closeElement("div");
            xb.openElement("div");
            xb.addAttribute("class", "fileinput");
            xb.addAttribute("style", "display:none");
            xb.addAttribute("id", "fileinput_" + this.id);
            xb.writeInputFile(this.innerId, this.inputName, true);
            xb.writeInputHidden(this.codeInputName, this.blob.getCode());
            xb.closeElement("div");
        }
    }

    protected void printRadio(XhtmlBuffer xb, String radioId, String labelKey, String value, boolean checked, String script) {
        xb.writeInputRadio(radioId, this.operationInputName, value, checked, false, script);
        xb.openElement("label");
        xb.addAttribute("for", radioId);
        xb.write(this.getText(labelKey, new Object[0]));
        xb.closeElement("label");
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        super.readFromRequest(req);
        if (this.mode.isView(this.insertable, this.updatable)) {
            return;
        }
        String updateTypeStr = req.getParameter(this.operationInputName);
        if (UPLOAD_MODIFY.equals(updateTypeStr)) {
            this.saveUpload(req);
        } else if (UPLOAD_DELETE.equals(updateTypeStr)) {
            this.forgetBlob();
        } else {
            this.keepOldBlob(req);
        }
    }

    protected void forgetBlob() {
        this.blob = null;
    }

    protected void keepOldBlob(HttpServletRequest req) {
        String code = req.getParameter(this.codeInputName);
        if (!StringUtils.isBlank((String)code)) {
            this.blob = new Blob(code);
        }
    }

    protected void saveUpload(HttpServletRequest req) {
        StripesRequestWrapper stripesRequest = StripesRequestWrapper.findStripesWrapper((ServletRequest)req);
        FileBean fileBean = stripesRequest.getFileParameterValue(this.inputName);
        if (fileBean != null) {
            try {
                this.newBlob(fileBean);
            }
            catch (IOException e) {
                logger.error("Could not read upload", (Throwable)e);
                this.forgetBlob();
                this.blobError = this.getText("elements.error.field.fileblob.uploadFailed", new Object[0]);
                try {
                    fileBean.delete();
                }
                catch (IOException e1) {
                    logger.error("Could not delete FileBean", (Throwable)e1);
                }
            }
        } else {
            logger.debug("An update of a blob was requested, but nothing was uploaded. The previous value will be kept.");
            this.keepOldBlob(req);
        }
    }

    protected void newBlob(final FileBean fileBean) throws IOException {
        this.blob = new Blob(this.generateNewCode()){

            @Override
            public void dispose() {
                super.dispose();
                try {
                    fileBean.delete();
                }
                catch (IOException e) {
                    AbstractField.logger.warn("Could not delete file bean", (Throwable)e);
                }
            }
        };
        this.blob.setInputStream(fileBean.getInputStream());
        this.blob.setFilename(fileBean.getFileName());
        this.blob.setContentType(fileBean.getContentType());
        this.blob.setCreateTimestamp(new DateTime());
        this.blob.setPropertiesLoaded(true);
    }

    public abstract String generateNewCode();

    @Override
    public boolean validate() {
        if (this.mode.isView(this.insertable, this.updatable) || this.mode.isBulk() && !this.bulkChecked) {
            return true;
        }
        boolean result = true;
        if (this.required && this.blob == null) {
            this.errors.add(this.getText("elements.error.field.required", new Object[0]));
            result = false;
        }
        return result;
    }

    @Override
    public Blob getValue() {
        return this.blob;
    }

    @Override
    public void setValue(Blob blob) {
        this.blob = blob;
    }

    public abstract boolean isSaveBlobOnObject();

    public String getCodeInputName() {
        return this.codeInputName;
    }

    public String getOperationInputName() {
        return this.operationInputName;
    }

    public void setOperationInputName(String operationInputName) {
        this.operationInputName = operationInputName;
    }

    public String getBlobError() {
        return this.blobError;
    }

    public void setBlobError(String blobError) {
        this.blobError = blobError;
    }

    public void loadBlob(BlobManager blobManager, boolean loadContents) {
        Blob blob = this.getValue();
        if (blob != null && blob.getCode() != null) {
            try {
                this.loadBlob(blobManager, blob, loadContents);
                this.setBlobError(null);
            }
            catch (Exception e) {
                logger.debug("Could not load blob with code " + blob.getCode() + " from BlobManager " + blobManager, (Throwable)e);
                this.setBlobError(ElementsThreadLocals.getText("elements.error.field.fileblob.cannotLoad", new Object[0]));
            }
        }
    }

    protected void loadBlob(BlobManager blobManager, Blob blob, boolean loadContents) throws IOException {
        if (!blob.isPropertiesLoaded()) {
            blobManager.loadMetadata(blob);
        }
        if (loadContents) {
            blobManager.openStream(blob);
        }
    }
}

