/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.reflection.decorators;

import com.manydesigns.elements.reflection.AbstractAnnotatedAccessor;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.JavaClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.reflection.decorators.PropertyAccessorDecorator;
import java.lang.annotation.Annotation;
import org.apache.commons.lang.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class ClassAccessorDecorator
extends AbstractAnnotatedAccessor
implements ClassAccessor {
    public static final String copyright = "Copyright (C) 2005-2016, ManyDesigns srl";
    private final ClassAccessor delegate;
    private final PropertyAccessor[] properties;
    private final PropertyAccessor[] keyProperties;

    protected ClassAccessorDecorator(ClassAccessor delegate) {
        if (ClassAccessorDecorator.class.equals(this.getClass())) {
            throw new IllegalStateException("This constructor is supposed to be called on subclasses that act as decorator definitions");
        }
        ClassAccessor decoratorAccessor = this.getDecoratorAccessor();
        ClassAccessorDecorator decorator = this;
        this.delegate = delegate;
        this.properties = new PropertyAccessor[delegate.getProperties().length];
        this.keyProperties = new PropertyAccessor[delegate.getKeyProperties().length];
        this.init(delegate, decoratorAccessor, decorator);
    }

    public ClassAccessorDecorator(ClassAccessor delegate, ClassAccessor decoratorAccessor, @Nullable Object decorator) {
        this.delegate = delegate;
        this.properties = new PropertyAccessor[delegate.getProperties().length];
        this.keyProperties = new PropertyAccessor[delegate.getKeyProperties().length];
        this.init(delegate, decoratorAccessor, decorator);
    }

    public ClassAccessorDecorator(ClassAccessor delegate, ClassAccessor decoratorAccessor) {
        this(delegate, decoratorAccessor, null);
    }

    private void init(ClassAccessor delegate, ClassAccessor decoratorAccessor, Object decorator) {
        int p = 0;
        int k = 0;
        for (PropertyAccessor propertyAccessor : delegate.getProperties()) {
            try {
                PropertyAccessor decoratingProperty = decoratorAccessor.getProperty(propertyAccessor.getName());
                PropertyAccessorDecorator propertyAccessorDecorator = new PropertyAccessorDecorator(propertyAccessor, decoratingProperty);
                this.properties[p] = propertyAccessorDecorator;
                if (decoratingProperty.getType().isAssignableFrom(PropertyAccessor.class) && decorator != null) {
                    decoratingProperty.set(decorator, propertyAccessorDecorator);
                }
            }
            catch (NoSuchFieldException e) {
                this.properties[p] = propertyAccessor;
            }
            if (ArrayUtils.contains((Object[])delegate.getKeyProperties(), (Object)propertyAccessor)) {
                this.keyProperties[k++] = this.properties[p];
            }
            ++p;
        }
        for (Annotation annotation : delegate.getAnnotations()) {
            this.annotations.put(annotation.getClass().getInterfaces()[0], annotation);
        }
        for (Annotation annotation : decoratorAccessor.getAnnotations()) {
            this.annotations.put(annotation.getClass().getInterfaces()[0], annotation);
        }
    }

    protected ClassAccessor getDecoratorAccessor() {
        return JavaClassAccessor.getClassAccessor(this.getClass());
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public PropertyAccessor getProperty(String propertyName) throws NoSuchFieldException {
        for (PropertyAccessor propertyAccessor : this.properties) {
            if (!propertyAccessor.getName().equals(propertyName)) continue;
            return propertyAccessor;
        }
        throw new NoSuchFieldException(propertyName);
    }

    @Override
    public PropertyAccessor[] getProperties() {
        return this.properties;
    }

    @Override
    public PropertyAccessor[] getKeyProperties() {
        return this.keyProperties;
    }

    @Override
    public Object newInstance() {
        return this.delegate.newInstance();
    }

    @Override
    public Class<?> getType() {
        return this.delegate.getType();
    }
}

