/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.forms;

import com.manydesigns.elements.Mode;
import com.manydesigns.elements.annotations.InSummary;
import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.fields.SelectField;
import com.manydesigns.elements.forms.AbstractFormBuilder;
import com.manydesigns.elements.forms.TableForm;
import com.manydesigns.elements.options.SelectionModel;
import com.manydesigns.elements.options.SelectionProvider;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.JavaClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.text.TextFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableFormBuilder
extends AbstractFormBuilder {
    public static final String copyright = "Copyright (C) 2005-2025 ManyDesigns srl";
    public static final int DEFAULT_N_ROWS = 1;
    protected final Map<String, TextFormat> headerTextFormats = new HashMap<String, TextFormat>();
    protected final Map<String, TextFormat> hrefTextFormats = new HashMap<String, TextFormat>();
    protected final Map<String, TextFormat> titleTextFormats = new HashMap<String, TextFormat>();
    protected List<PropertyAccessor> propertyAccessors;
    protected int nRows = 1;
    protected final List<Map<String[], SelectionProvider>> rowSelectionProviders = new ArrayList<Map<String[], SelectionProvider>>(this.nRows);
    public static final Logger logger = LoggerFactory.getLogger(TableFormBuilder.class);

    public TableFormBuilder(Class aClass) {
        this(JavaClassAccessor.getClassAccessor(aClass));
    }

    public TableFormBuilder(ClassAccessor classAccessor) {
        super(classAccessor);
    }

    public TableFormBuilder configFields(String ... fieldNames) {
        this.propertyAccessors = new ArrayList<PropertyAccessor>();
        for (String currentField : fieldNames) {
            try {
                PropertyAccessor accessor = this.classAccessor.getProperty(currentField);
                this.propertyAccessors.add(accessor);
            }
            catch (NoSuchFieldException e) {
                logger.warn("Field not found: {}", (Object)currentField);
            }
        }
        return this;
    }

    public TableFormBuilder configPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public TableFormBuilder configNRows(int nRows) {
        this.nRows = nRows;
        while (this.rowSelectionProviders.size() < nRows) {
            this.rowSelectionProviders.add(new HashMap());
        }
        return this;
    }

    public TableFormBuilder configMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public TableFormBuilder configSelectionProvider(SelectionProvider selectionProvider, String ... fieldNames) {
        this.selectionProviders.put(fieldNames, selectionProvider);
        return this;
    }

    public TableFormBuilder configSelectionProvider(int row, SelectionProvider selectionProvider, String ... fieldNames) {
        this.rowSelectionProviders.get(row).put(fieldNames, selectionProvider);
        return this;
    }

    public void configReflectiveFields() {
        this.propertyAccessors = new ArrayList<PropertyAccessor>();
        for (PropertyAccessor current : this.classAccessor.getProperties()) {
            if (!this.isPropertyVisible(current)) continue;
            this.propertyAccessors.add(current);
        }
    }

    public boolean isPropertyVisible(PropertyAccessor current) {
        if (!this.isPropertyEnabled(current)) {
            return false;
        }
        InSummary inSummaryAnnotation = current.getAnnotation(InSummary.class);
        if (inSummaryAnnotation != null && !inSummaryAnnotation.value()) {
            logger.debug("Skipping non-in-summary field: {}", (Object)current.getName());
            return false;
        }
        return true;
    }

    public TableFormBuilder configHeaderTextFormat(String fieldName, TextFormat hrefTextFormat) {
        this.headerTextFormats.put(fieldName, hrefTextFormat);
        return this;
    }

    public TableFormBuilder configHrefTextFormat(String fieldName, TextFormat hrefTextFormat) {
        this.hrefTextFormats.put(fieldName, hrefTextFormat);
        return this;
    }

    public TableFormBuilder configTitleTextFormat(String fieldName, TextFormat titleTextFormat) {
        this.titleTextFormats.put(fieldName, titleTextFormat);
        return this;
    }

    public TableForm build() {
        if (this.propertyAccessors == null) {
            this.configReflectiveFields();
        }
        this.removeUnusedSelectionProviders(this.propertyAccessors);
        PropertyAccessor[] propertyAccessorsArray = new PropertyAccessor[this.propertyAccessors.size()];
        this.propertyAccessors.toArray(propertyAccessorsArray);
        TableForm tableForm = new TableForm(this.nRows, propertyAccessorsArray);
        if (null != this.prefix && this.prefix.length() > 0) {
            tableForm.setPrefix(this.prefix);
        }
        this.setupColumns(tableForm);
        this.setupRows(tableForm);
        return tableForm;
    }

    protected void setupColumns(TableForm tableForm) {
        for (TableForm.Column column : tableForm.getColumns()) {
            String propertyName = column.getPropertyAccessor().getName();
            column.setHeaderTextFormat(this.headerTextFormats.get(propertyName));
            column.setHrefTextFormat(this.hrefTextFormats.get(propertyName));
            column.setTitleTextFormat(this.titleTextFormats.get(propertyName));
        }
    }

    protected void setupRows(TableForm tableForm) {
        int index = 0;
        for (TableForm.Row row : tableForm.getRows()) {
            String rowPrefix = StringUtils.join((Object[])new Object[]{this.prefix, "row", index, "_"});
            for (PropertyAccessor propertyAccessor : this.propertyAccessors) {
                Field field = this.buildField(propertyAccessor, rowPrefix);
                if (field == null) {
                    logger.warn("Cannot instanciate field for property {}", (Object)propertyAccessor);
                    continue;
                }
                row.add(field);
            }
            for (Map.Entry entry : this.selectionProviders.entrySet()) {
                this.setupSelectionProvidersForRow(tableForm, row, entry);
            }
            for (Map.Entry entry : this.rowSelectionProviders.get(index).entrySet()) {
                this.setupSelectionProvidersForRow(tableForm, row, entry);
            }
            ++index;
        }
    }

    protected void setupSelectionProvidersForRow(TableForm tableForm, TableForm.Row row, Map.Entry<String[], SelectionProvider> current) {
        String[] fieldNames = current.getKey();
        SelectionProvider selectionProvider = current.getValue();
        SelectionModel selectionModel = selectionProvider.createSelectionModel();
        SelectField previousField = null;
        for (int i = 0; i < fieldNames.length; ++i) {
            int fieldIndex = this.findFieldIndexByName(tableForm, fieldNames[i]);
            SelectField selectField = (SelectField)row.get(fieldIndex);
            selectField.setSelectionModel(selectionModel);
            selectField.setSelectionModelIndex(i);
            if (previousField != null) {
                selectField.setPreviousSelectField(previousField);
                previousField.setNextSelectField(selectField);
            }
            previousField = selectField;
        }
    }

    private int findFieldIndexByName(TableForm tableForm, String fieldName) {
        TableForm.Column[] columns = tableForm.getColumns();
        for (int index = 0; index < columns.length; ++index) {
            TableForm.Column column = columns[index];
            if (!column.getPropertyAccessor().getName().equals(fieldName)) continue;
            return index;
        }
        return -1;
    }

    protected Field buildField(PropertyAccessor propertyAccessor, String rowPrefix) {
        SelectField field = null;
        String fieldName = propertyAccessor.getName();
        for (Map.Entry current : this.selectionProviders.entrySet()) {
            Object[] fieldNames = (String[])current.getKey();
            int index = ArrayUtils.indexOf((Object[])fieldNames, (Object)fieldName);
            if (index < 0) continue;
            field = this.buildSelectField(propertyAccessor, null, rowPrefix);
            break;
        }
        return this.buildField(propertyAccessor, field, rowPrefix);
    }

    public List<PropertyAccessor> getPropertyAccessors() {
        return this.propertyAccessors != null ? Collections.unmodifiableList(this.propertyAccessors) : null;
    }
}

