/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.servlet;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.xml.XhtmlBuffer;
import com.manydesigns.elements.xml.XhtmlFragment;
import java.io.Writer;
import java.util.Map;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteTag
extends TagSupport {
    public static final String copyright = "Copyright (C) 2005-2024 ManyDesigns srl";
    public static final String APPLICATION_SCOPE = "APPLICATION";
    public static final String SESSION_SCOPE = "SESSION";
    public static final String REQUEST_SCOPE = "REQUEST";
    public static final String PAGE_SCOPE = "PAGE";
    protected String name;
    protected String property;
    protected String scope;
    public static final Logger logger = LoggerFactory.getLogger(WriteTag.class);

    public int doStartTag() {
        JspWriter out = this.pageContext.getOut();
        try {
            this.doTag(out);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        return 0;
    }

    private void doTag(JspWriter out) throws OgnlException {
        Integer scopeCode;
        if (this.scope == null) {
            scopeCode = null;
        } else if (APPLICATION_SCOPE.equals(this.scope)) {
            scopeCode = 4;
        } else if (SESSION_SCOPE.equals(this.scope)) {
            scopeCode = 3;
        } else if (REQUEST_SCOPE.equals(this.scope)) {
            scopeCode = 2;
        } else if (PAGE_SCOPE.equals(this.scope)) {
            scopeCode = 1;
        } else {
            logger.warn("Unknown scope: {}", (Object)this.scope);
            return;
        }
        Object bean = scopeCode != null ? this.pageContext.getAttribute(this.name, scopeCode.intValue()) : this.pageContext.findAttribute(this.name);
        if (bean == null) {
            logger.warn("Bean {} not found in scope {}", (Object)this.name, (Object)this.scope);
            return;
        }
        if (this.property != null) {
            OgnlContext ognlContext = ElementsThreadLocals.getOgnlContext();
            bean = OgnlUtils.getValueQuietly(this.property, (Map)ognlContext, bean);
        }
        if (bean instanceof XhtmlFragment) {
            XhtmlFragment xhtmlFragment = (XhtmlFragment)bean;
            XhtmlBuffer xb = new XhtmlBuffer((Writer)out);
            xhtmlFragment.toXhtml(xb);
        } else {
            logger.warn("Bean {} scope {} property {} not of type XhtmlFragment: {}", (Object[])new String[]{this.name, this.scope, this.property, bean != null ? bean.getClass().getName() : null});
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

