/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.reflection;

import com.manydesigns.elements.reflection.AbstractAnnotatedAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.reflection.ReflectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaPropertyAccessor
extends AbstractAnnotatedAccessor
implements PropertyAccessor {
    public static final String copyright = "Copyright (C) 2005-2024 ManyDesigns srl";
    private final PropertyDescriptor propertyDescriptor;
    private final Method getter;
    private final Method setter;
    public static final Logger logger = LoggerFactory.getLogger(JavaPropertyAccessor.class);

    public JavaPropertyAccessor(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
        this.getter = propertyDescriptor.getReadMethod();
        this.setter = propertyDescriptor.getWriteMethod();
        try {
            Field field = this.getter.getDeclaringClass().getDeclaredField(propertyDescriptor.getName());
            Annotation[] annotationArray = field.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation ann = annotationArray[i];
                this.annotations.put(ann.annotationType(), ann);
            }
        }
        catch (NoSuchFieldException e) {
            logger.debug("No field for " + propertyDescriptor.getName(), (Throwable)e);
        }
        for (Annotation ann : this.getter.getAnnotations()) {
            this.annotations.put(ann.annotationType(), ann);
        }
        if (this.setter == null) {
            logger.debug("Setter not available for: {}", (Object)propertyDescriptor.getName());
        } else {
            for (Annotation ann : this.setter.getAnnotations()) {
                this.annotations.put(ann.annotationType(), ann);
            }
        }
    }

    @Override
    public String getName() {
        return this.propertyDescriptor.getName();
    }

    @Override
    public Class getType() {
        return this.getter.getReturnType();
    }

    @Override
    public int getModifiers() {
        return this.getter.getModifiers();
    }

    @Override
    public Object get(Object obj) {
        try {
            return this.getter.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(String.format("Cannot get property: %s", this.getName()), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(String.format("Cannot get property: %s", this.getName()), e);
        }
    }

    @Override
    public void set(Object obj, Object value) {
        if (this.setter == null) {
            throw new ReflectionException(String.format("Setter not available for property: %s", this.getName()));
        }
        try {
            this.setter.invoke(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(String.format("Cannot set property: %s", this.getName()), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(String.format("Cannot set property: %s", this.getName()), e);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).toString();
    }
}

