/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.reflection;

import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AggregateClassAccessor
implements ClassAccessor {
    public static final String copyright = "Copyright (C) 2005-2024 ManyDesigns srl";
    protected final List<ClassAccessor> accessors;
    protected final List<String> aliases;
    protected String name;
    protected Class<? extends List> collectionClass = ArrayList.class;
    protected PropertyAccessor[] properties;
    protected PropertyAccessor[] keyProperties;

    public AggregateClassAccessor(List<ClassAccessor> accessors) {
        this.accessors = accessors;
        this.aliases = Arrays.asList(new String[accessors.size()]);
        this.computeProperties();
    }

    public AggregateClassAccessor(ClassAccessor ... accessors) {
        this(Arrays.asList(accessors));
    }

    public void alias(int index, String alias) {
        this.aliases.set(index, alias);
        this.computeProperties();
    }

    public String getAlias(int index) {
        return this.aliases.get(index);
    }

    public List<ClassAccessor> getAccessors() {
        return this.accessors;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.collectionClass != null ? this.collectionClass : Object[].class;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<? extends List> getCollectionClass() {
        return this.collectionClass;
    }

    public void setCollectionClass(Class<? extends List> collectionClass) {
        this.collectionClass = collectionClass;
    }

    protected void computeProperties() {
        ArrayList<AliasPropertyAccessor> allProperties = new ArrayList<AliasPropertyAccessor>();
        int index = 0;
        for (ClassAccessor accessor : this.getAccessors()) {
            String alias = this.aliases.get(index);
            if (alias != null) {
                allProperties.add(new AliasPropertyAccessor(alias, index, accessor));
            }
            PropertyAccessor[] properties = accessor.getProperties();
            PropertyAccessor[] wrappers = new PropertyAccessor[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                wrappers[i] = new PropertyAccessorWrapper(accessor, properties[i], index);
            }
            Collections.addAll(allProperties, wrappers);
            ++index;
        }
        this.properties = allProperties.toArray(new PropertyAccessor[allProperties.size()]);
        this.computeKeyProperties();
    }

    protected void computeKeyProperties() {
        ArrayList allProperties = new ArrayList();
        int index = 0;
        for (ClassAccessor accessor : this.getAccessors()) {
            PropertyAccessor[] properties = accessor.getKeyProperties();
            PropertyAccessor[] wrappers = new PropertyAccessor[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                wrappers[i] = new PropertyAccessorWrapper(accessor, properties[i], index);
            }
            Collections.addAll(allProperties, wrappers);
            ++index;
        }
        this.keyProperties = allProperties.toArray(new PropertyAccessor[allProperties.size()]);
    }

    @Override
    public PropertyAccessor getProperty(String propertyName) throws NoSuchFieldException {
        for (PropertyAccessor propertyAccessor : this.properties) {
            if (!propertyAccessor.getName().equals(propertyName)) continue;
            return propertyAccessor;
        }
        throw new NoSuchFieldException(propertyName);
    }

    @Override
    public PropertyAccessor[] getProperties() {
        return this.properties;
    }

    @Override
    public PropertyAccessor[] getKeyProperties() {
        return this.keyProperties;
    }

    @Override
    public Object newInstance() {
        if (this.collectionClass != null) {
            List list = (List)ReflectionUtil.newInstance(this.collectionClass);
            for (ClassAccessor accessor : this.accessors) {
                list.add(accessor.newInstance());
            }
            return list;
        }
        Object[] objects = new Object[this.accessors.size()];
        int i = 0;
        for (ClassAccessor accessor : this.accessors) {
            objects[i++] = accessor.newInstance();
        }
        return objects;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        for (ClassAccessor accessor : this.accessors) {
            if (!accessor.isAnnotationPresent(annotationClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (ClassAccessor accessor : this.accessors) {
            if (!accessor.isAnnotationPresent(annotationClass)) continue;
            return accessor.getAnnotation(annotationClass);
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        ArrayList allAnnotations = new ArrayList();
        for (ClassAccessor accessor : this.getAccessors()) {
            Annotation[] annotations = accessor.getAnnotations();
            Collections.addAll(allAnnotations, annotations);
        }
        return allAnnotations.toArray(new Annotation[allAnnotations.size()]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        ArrayList allAnnotations = new ArrayList();
        for (ClassAccessor accessor : this.getAccessors()) {
            Annotation[] annotations = accessor.getDeclaredAnnotations();
            Collections.addAll(allAnnotations, annotations);
        }
        return allAnnotations.toArray(new Annotation[allAnnotations.size()]);
    }

    public class AliasPropertyAccessor
    implements PropertyAccessor {
        protected final String name;
        protected final int index;
        protected final ClassAccessor accessor;

        public AliasPropertyAccessor(String name, int index, ClassAccessor accessor) {
            this.name = name;
            this.index = index;
            this.accessor = accessor;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.accessor.getType();
        }

        @Override
        public int getModifiers() {
            return 1;
        }

        @Override
        public Object get(Object obj) {
            if (obj instanceof List) {
                return ((List)obj).get(this.index);
            }
            return ((Object[])obj)[this.index];
        }

        @Override
        public void set(Object obj, Object value) {
            if (obj instanceof List) {
                ((List)obj).set(this.index, value);
            } else {
                ((Object[])obj)[this.index] = value;
            }
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.accessor.isAnnotationPresent(annotationClass);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.accessor.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.accessor.getAnnotations();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.accessor.getDeclaredAnnotations();
        }
    }

    public class PropertyAccessorWrapper
    implements PropertyAccessor {
        protected final ClassAccessor classAccessor;
        protected final PropertyAccessor delegate;
        protected final int index;

        public PropertyAccessorWrapper(ClassAccessor accessor, PropertyAccessor propertyAccessor, int index) {
            this.classAccessor = accessor;
            this.delegate = propertyAccessor;
            this.index = index;
        }

        @Override
        public String getName() {
            String alias = AggregateClassAccessor.this.aliases.get(this.index);
            String accessorName = alias != null ? alias : "[" + this.index + "]";
            return accessorName + "." + this.delegate.getName();
        }

        @Override
        public Class getType() {
            return this.delegate.getType();
        }

        @Override
        public int getModifiers() {
            return this.delegate.getModifiers();
        }

        protected Object getObject(Object collection) {
            if (collection instanceof List) {
                return ((List)collection).get(this.index);
            }
            return ((Object[])collection)[this.index];
        }

        @Override
        public Object get(Object obj) {
            return this.delegate.get(this.getObject(obj));
        }

        @Override
        public void set(Object obj, Object value) {
            this.delegate.set(this.getObject(obj), value);
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.delegate.isAnnotationPresent(annotationClass);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.delegate.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.delegate.getAnnotations();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.delegate.getDeclaredAnnotations();
        }
    }
}

