/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.reflection;

import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.reflection.ReflectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaPropertyAccessor
implements PropertyAccessor {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    private final PropertyDescriptor propertyDescriptor;
    private final Method getter;
    private final Method setter;
    public static final Logger logger = LoggerFactory.getLogger(JavaPropertyAccessor.class);

    public JavaPropertyAccessor(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
        this.getter = propertyDescriptor.getReadMethod();
        this.setter = propertyDescriptor.getWriteMethod();
        if (this.setter == null) {
            logger.debug("Setter not available for: {}", (Object)propertyDescriptor.getName());
        }
    }

    @Override
    public String getName() {
        return this.propertyDescriptor.getName();
    }

    @Override
    public Class getType() {
        return this.getter.getReturnType();
    }

    @Override
    public int getModifiers() {
        return this.getter.getModifiers();
    }

    @Override
    public Object get(Object obj) {
        try {
            return this.getter.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(String.format("Cannot get property: %s", this.getName()), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(String.format("Cannot get property: %s", this.getName()), e);
        }
    }

    @Override
    public void set(Object obj, Object value) {
        if (this.setter == null) {
            throw new ReflectionException(String.format("Setter not available for property: %s", this.getName()));
        }
        try {
            this.setter.invoke(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(String.format("Cannot set property: %s", this.getName()), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(String.format("Cannot set property: %s", this.getName()), e);
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getter.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getter.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getter.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getter.getDeclaredAnnotations();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).toString();
    }
}

