/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.i18n;

import com.manydesigns.elements.i18n.TextProvider;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class SimpleTextProvider
implements TextProvider {
    public static final String DEFAULT_MESSAGE_RESOURCE = "com.manydesigns.elements.messages";
    protected final Locale locale;
    protected final String messageResource;
    protected final ResourceBundle resourceBundle;

    public static SimpleTextProvider create() {
        return SimpleTextProvider.create(Locale.getDefault(), DEFAULT_MESSAGE_RESOURCE);
    }

    public static SimpleTextProvider create(Locale locale) {
        return SimpleTextProvider.create(locale, DEFAULT_MESSAGE_RESOURCE);
    }

    public static SimpleTextProvider create(String messageResource) {
        return SimpleTextProvider.create(Locale.getDefault(), messageResource);
    }

    public static SimpleTextProvider create(Locale locale, String messageResource) {
        return new SimpleTextProvider(locale, messageResource);
    }

    private SimpleTextProvider(Locale locale, String messageResource) {
        ResourceBundle tmpBundle;
        this.locale = locale;
        this.messageResource = messageResource;
        try {
            tmpBundle = locale == null ? ResourceBundle.getBundle(messageResource) : ResourceBundle.getBundle(messageResource, locale);
        }
        catch (Throwable e) {
            tmpBundle = null;
        }
        this.resourceBundle = tmpBundle;
    }

    @Override
    public String getText(String key, Object ... args) {
        String localizedString = this.getLocalizedString(key);
        return MessageFormat.format(localizedString, args);
    }

    public String getLocalizedString(String key) {
        try {
            if (this.resourceBundle == null) {
                return key;
            }
            return this.resourceBundle.getString(key);
        }
        catch (Throwable e) {
            return key;
        }
    }
}

