/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.tools;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

interface Encoder
extends Library {
    public static final Logger LOGGER;
    public static final String OS_NAME;
    public static final String OS_ARCH;

    public static void swapIntBytes(byte[] bytes) {
        if (!2.$assertionsDisabled && bytes.length % 4 != 0) {
            throw new AssertionError();
        }
        for (int i = 0; i < bytes.length; i += 4) {
            byte tmp = bytes[i];
            bytes[i] = bytes[i + 3];
            bytes[i + 3] = tmp;
            byte tmp2 = bytes[i + 1];
            bytes[i + 1] = bytes[i + 2];
            bytes[i + 2] = tmp2;
        }
    }

    public static BufferedImage readImageFromClasspath(Class<? extends Encoder> encoderClass, String fileName) throws IOException {
        String resourceStr = "/" + fileName + ".png";
        try (InputStream inputStream = encoderClass.getResourceAsStream(resourceStr);){
            if (inputStream != null) {
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                return bufferedImage;
            }
            throw new IOException("Resource '" + resourceStr + "' not found in " + encoderClass.getCanonicalName());
        }
    }

    public static void encoderTest(Class<? extends Encoder> encoderClass, String fileName, int channels) throws IOException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Encoder.encoderTest(encoderClass, fileName, channels, 5, true);
    }

    public static void encoderTest(Class<? extends Encoder> encoderClass, String fileName, int channels, int compressLevel, boolean writeTempFiles) throws IOException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        BufferedImage image = Encoder.readImageFromClasspath(encoderClass, fileName);
        Method encode = encoderClass.getMethod("encode", BufferedImage.class, Integer.TYPE, Integer.TYPE);
        byte[] data = (byte[])encode.invoke(null, image, channels, compressLevel);
        if (writeTempFiles) {
            File file = File.createTempFile(encoderClass.getSimpleName() + "_" + fileName + "_" + channels + "_", ".png");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(data);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
    }

    public static void extractFilesFromURI(URI uri, String target) throws IOException {
        LOGGER.info("Extract native libraries from: " + uri.toASCIIString());
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        try (FileSystem ignored = FileSystems.newFileSystem(uri, env);){
            Encoder.extract(uri, target);
        }
        catch (Exception ex) {
            Encoder.extract(uri, target);
        }
    }

    public static void extract(URI uri, String target) throws IOException {
        final Path uriPath = Paths.get(uri);
        final File targetFolder = new File(target);
        targetFolder.deleteOnExit();
        Files.walkFileTree(uriPath, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, targetFolder.toPath().resolve(uriPath.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(targetFolder.toPath().resolve(uriPath.relativize(dir).toString()), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static byte[] getRGBABytes(BufferedImage image, int channels) {
        BufferedImage convertedImage = new BufferedImage(image.getWidth(), image.getHeight(), channels == 4 ? 6 : 5);
        convertedImage.getGraphics().drawImage(image, 0, 0, null);
        DataBufferByte dataBuffer = (DataBufferByte)convertedImage.getRaster().getDataBuffer();
        return dataBuffer.getData();
    }

    public static Object load(Class<? extends Library> clazz, String libraryName) {
        String resourcePath = "/lib";
        String prefix = "lib";
        String extension = ".so";
        String targetFolder = System.getProperty("java.io.tmpdir") + File.separator + libraryName + File.separator;
        String strippedLibraryName = libraryName.startsWith(prefix) ? libraryName.substring(prefix.length()) : libraryName;
        String name = targetFolder;
        if (OS_NAME.startsWith("linux")) {
            name = name + "linux";
        } else if (OS_NAME.startsWith("windows")) {
            name = name + "windows";
            prefix = "";
            extension = ".dll";
        } else if (OS_NAME.startsWith("mac") || OS_NAME.startsWith("osx")) {
            name = name + "macos";
            extension = ".dylib";
        } else if (OS_NAME.startsWith("solaris") || OS_NAME.startsWith("sunos")) {
            name = name + "sunos";
        } else if (OS_NAME.startsWith("aix")) {
            name = name + "aix";
            extension = ".a";
        } else if (OS_NAME.startsWith("hpux")) {
            name = name + "hpux";
            extension = ".sl";
        } else if (OS_NAME.startsWith("os400") && (OS_NAME.length() <= 5 || !Character.isDigit(OS_NAME.charAt(5)))) {
            name = name + "os400";
        } else if (OS_NAME.startsWith("freebsd")) {
            name = name + "freebsd";
        } else if (OS_NAME.startsWith("openbsd")) {
            name = name + "openbsd";
        } else if (OS_NAME.startsWith("netbsd")) {
            name = name + "netbsd";
        } else if (OS_NAME.startsWith("zos")) {
            name = name + "zos";
        }
        if (OS_ARCH.matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            name = name + File.separator + "x86-64";
        } else if (OS_ARCH.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            name = name + File.separator + "x86-32";
        } else if (OS_ARCH.matches("^(ia64w?|itanium64)$")) {
            name = name + File.separator + "itanium-64";
        } else if ("ia64n".equals(OS_ARCH)) {
            name = name + File.separator + "itanium-32";
        } else if (OS_ARCH.matches("^(sparc|sparc32)$")) {
            name = name + File.separator + "sparc-32";
        } else if (OS_ARCH.matches("^(sparcv9|sparc64)$")) {
            name = name + File.separator + "sparc-64";
        } else if (OS_ARCH.matches("^(arm|arm32)$")) {
            name = name + File.separator + "arm-32";
        } else if ("aarch64".equals(OS_ARCH)) {
            name = name + File.separator + "aarch-64";
        } else if (OS_ARCH.matches("^(mips|mips32)$")) {
            name = name + File.separator + "mips-32";
        } else if (OS_ARCH.matches("^(mipsel|mips32el)$")) {
            name = name + File.separator + "mipsel-32";
        } else if ("mips64".equals(OS_ARCH)) {
            name = name + File.separator + "mips-64";
        } else if ("mips64el".equals(OS_ARCH)) {
            name = name + File.separator + "mipsel-64";
        } else if (OS_ARCH.matches("^(ppc|ppc32)$")) {
            name = name + File.separator + "ppc-32";
        } else if (OS_ARCH.matches("^(ppcle|ppc32le)$")) {
            name = name + File.separator + "ppcle-32";
        } else if ("ppc64".equals(OS_ARCH)) {
            name = name + File.separator + "ppc-64";
        } else if ("ppc64le".equals(OS_ARCH)) {
            name = name + File.separator + "ppcle-64";
        } else if ("s390".equals(OS_ARCH)) {
            name = name + File.separator + "s390-32";
        } else if ("s390x".equals(OS_ARCH)) {
            name = name + File.separator + "s390-64";
        } else if (OS_ARCH.matches("^(riscv|riscv32)$")) {
            name = name + File.separator + "riscv";
        } else if ("riscv64".equals(OS_ARCH)) {
            name = name + File.separator + "riscv64";
        } else if ("e2k".equals(OS_ARCH)) {
            name = name + File.separator + "e2k";
        } else if ("loongarch64".equals(OS_ARCH)) {
            name = name + File.separator + "loongarch-64";
        }
        name = name + File.separator + prefix + strippedLibraryName + extension;
        if (new File(name).isFile()) {
            LOGGER.info("Load native library from " + name);
        } else {
            LOGGER.info("Extract and Load native library from " + name);
            URL resource = clazz.getResource(resourcePath + "/" + strippedLibraryName);
            if (resource != null) {
                try {
                    Encoder.extractFilesFromURI(resource.toURI(), targetFolder);
                }
                catch (IOException | URISyntaxException ex) {
                    throw new RuntimeException("Failed to extract " + resource + " from " + clazz.getCanonicalName() + " to " + targetFolder, ex);
                }
            } else {
                throw new RuntimeException("Resource " + resourcePath + "/" + strippedLibraryName + " does not exist in " + clazz.getCanonicalName());
            }
        }
        return Native.load((String)name, clazz);
    }

    public static byte[] encode(BufferedImage image, int numberOfChannels, int flags) {
        return null;
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        LOGGER = Logger.getLogger(Encoder.class.getName());
        OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
        OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    public static class ByteArray
    extends Structure {
        public Pointer data;
        public NativeLong size;

        protected List<String> getFieldOrder() {
            return Arrays.asList("data", "size");
        }
    }
}

