/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core;

import com.mangopay.MangoPayApi;
import com.mangopay.core.Pagination;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

class UrlTool {
    private MangoPayApi _root;

    public UrlTool(MangoPayApi root) {
        this._root = root;
    }

    private String getHost() throws Exception {
        if (this._root.Config.BaseUrl == null || this._root.Config.BaseUrl.length() == 0) {
            throw new Exception("MangoPayApi.Config.BaseUrl setting is not defined.");
        }
        URL baseUrl = new URL(this._root.Config.BaseUrl);
        return baseUrl.getHost();
    }

    public String getRestUrl(String urlKey) throws UnsupportedEncodingException {
        return this.getRestUrl(urlKey, true, null, null);
    }

    public String getRestUrl(String urlKey, Boolean addClientId) throws UnsupportedEncodingException {
        return this.getRestUrl(urlKey, addClientId, null, null);
    }

    public String getRestUrl(String urlKey, Boolean addClientId, Pagination pagination) throws UnsupportedEncodingException {
        return this.getRestUrl(urlKey, addClientId, pagination, null);
    }

    public String getRestUrl(String urlKey, Boolean addClientId, Pagination pagination, Map<String, String> additionalUrlParams) throws UnsupportedEncodingException {
        String url = addClientId == false ? "/v2.01" + urlKey : "/v2.01/" + this._root.Config.ClientId + urlKey;
        Boolean paramsAdded = false;
        if (pagination != null) {
            url = url + "?page=" + pagination.Page + "&per_page=" + pagination.ItemsPerPage;
            paramsAdded = true;
        }
        if (additionalUrlParams != null) {
            for (Map.Entry<String, String> entry : additionalUrlParams.entrySet()) {
                url = url + (paramsAdded != false ? "&" : "?");
                url = url + entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), "ISO-8859-1");
                paramsAdded = true;
            }
        }
        return url;
    }

    public String getFullUrl(String restUrl) {
        String result = "";
        try {
            result = new URL(this._root.Config.BaseUrl).getProtocol() + "://" + this.getHost() + restUrl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

