/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mangopay.MangoPayApi;
import com.mangopay.core.Address;
import com.mangopay.core.AuthenticationHelper;
import com.mangopay.core.Dto;
import com.mangopay.core.Pagination;
import com.mangopay.core.ResponseException;
import com.mangopay.core.UrlTool;
import com.mangopay.core.enumerations.PersonType;
import com.mangopay.entities.BankAccount;
import com.mangopay.entities.IdempotencyResponse;
import com.mangopay.entities.PayIn;
import com.mangopay.entities.PayOut;
import com.mangopay.entities.User;
import com.mangopay.entities.UserLegal;
import com.mangopay.entities.UserNatural;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestTool {
    private MangoPayApi _root;
    private Boolean _debugMode;
    private Boolean _authRequired;
    private Map<String, String> _requestHttpHeaders;
    private HttpURLConnection _connection;
    private String _requestType;
    private Map<String, String> _requestData;
    private int _responseCode;
    private Pagination _pagination;
    private Logger _logger;

    public RestTool(MangoPayApi root, Boolean authRequired) throws Exception {
        this._root = root;
        this._authRequired = authRequired;
        this._debugMode = this._root.Config.DebugMode;
        this._logger = LoggerFactory.getLogger(RestTool.class);
    }

    public void addRequestHttpHeader(Map<String, String> httpHeader) {
        if (this._requestHttpHeaders == null) {
            this._requestHttpHeaders = new HashMap<String, String>();
        }
        this._requestHttpHeaders.putAll(httpHeader);
    }

    public void addRequestHttpHeader(final String key, final String value) {
        this.addRequestHttpHeader((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(key, value);
            }
        });
    }

    public <T extends Dto> T request(Class<T> classOfT, String urlMethod, String requestType, Map<String, String> requestData, Pagination pagination, T entity) throws Exception {
        return this.request(classOfT, null, urlMethod, requestType, requestData, pagination, entity);
    }

    public <T extends Dto> T request(Class<T> classOfT, String idempotencyKey, String urlMethod, String requestType, Map<String, String> requestData, Pagination pagination, T entity) throws Exception {
        this._requestType = requestType;
        this._requestData = requestData;
        T responseResult = this.doRequest(classOfT, idempotencyKey, urlMethod, pagination, entity);
        if (pagination != null) {
            pagination = this._pagination;
        }
        return responseResult;
    }

    public <T extends Dto> T request(Class<T> classOfT, String idempotencyKey, String urlMethod, String requestType) throws Exception {
        return this.request(classOfT, idempotencyKey, urlMethod, requestType, null, null, null);
    }

    public <T extends Dto> T request(Class<T> classOfT, String idempotencyKey, String urlMethod, String requestType, Map<String, String> requestData) throws Exception {
        return this.request(classOfT, idempotencyKey, urlMethod, requestType, requestData, null, null);
    }

    public <T extends Dto> T request(Class<T> classOfT, String idempotencyKey, String urlMethod, String requestType, Map<String, String> requestData, Pagination pagination) throws Exception {
        return this.request(classOfT, idempotencyKey, urlMethod, requestType, requestData, pagination, null);
    }

    public <T extends Dto> List<T> requestList(Class<T[]> classOfT, Class<T> classOfTItem, String urlMethod, String requestType, Map<String, String> requestData, Pagination pagination, Map<String, String> additionalUrlParams) throws Exception {
        this._requestType = requestType;
        this._requestData = requestData;
        List<T> responseResult = this.doRequestList(classOfT, classOfTItem, urlMethod, pagination, additionalUrlParams);
        if (pagination != null) {
            pagination = this._pagination;
        }
        return responseResult;
    }

    public <T extends Dto> List<T> requestList(Class<T[]> classOfT, Class<T> classOfTItem, String urlMethod, String requestType) throws Exception {
        return this.requestList(classOfT, classOfTItem, urlMethod, requestType, null, null, null);
    }

    public <T extends Dto> List<T> requestList(Class<T[]> classOfT, Class<T> classOfTItem, String urlMethod, String requestType, Map<String, String> requestData) throws Exception {
        return this.requestList(classOfT, classOfTItem, urlMethod, requestType, requestData, null, null);
    }

    public <T extends Dto> List<T> requestList(Class<T[]> classOfT, Class<T> classOfTItem, String urlMethod, String requestType, Map<String, String> requestData, Pagination pagination) throws Exception {
        return this.requestList(classOfT, classOfTItem, urlMethod, requestType, requestData, pagination, null);
    }

    private <T extends Dto> T doRequest(Class<T> classOfT, String idempotencyKey, String urlMethod, Pagination pagination, T entity) throws Exception {
        Dto response = null;
        try {
            StringBuffer resp;
            UrlTool urlTool = new UrlTool(this._root);
            String restUrl = urlTool.getRestUrl(urlMethod, this._authRequired, pagination, null);
            URL url = new URL(urlTool.getFullUrl(restUrl));
            if (this._debugMode.booleanValue()) {
                this._logger.info("FullUrl: {}", (Object)urlTool.getFullUrl(restUrl));
            }
            this._connection = (HttpURLConnection)url.openConnection();
            this._connection.setConnectTimeout(this._root.Config.getConnectTimeout());
            this._connection.setReadTimeout(this._root.Config.getReadTimeout());
            this._connection.setRequestMethod(this._requestType);
            Map<String, String> httpHeaders = this.getHttpHeaders(restUrl);
            for (Map.Entry<String, String> entry : httpHeaders.entrySet()) {
                this._connection.addRequestProperty(entry.getKey(), entry.getValue());
                if (!this._debugMode.booleanValue()) continue;
                this._logger.info("HTTP Header: {}", (Object)(entry.getKey() + ": " + entry.getValue()));
            }
            if (idempotencyKey != null && !idempotencyKey.trim().isEmpty()) {
                this._connection.addRequestProperty("Idempotency-Key", idempotencyKey);
            }
            this._connection.setUseCaches(false);
            this._connection.setDoInput(true);
            this._connection.setDoOutput(true);
            if (pagination != null) {
                this._pagination = pagination;
            }
            if (this._debugMode.booleanValue()) {
                this._logger.info("RequestType: {}", (Object)this._requestType);
            }
            if (this._requestData != null || entity != null) {
                String requestBody = "";
                if (entity != null) {
                    HashMap<String, Object> requestData = this.buildRequestData(classOfT, entity);
                    Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                    requestBody = gson.toJson(requestData);
                }
                if (this._requestData != null) {
                    String params = "";
                    for (Map.Entry<String, String> entry : this._requestData.entrySet()) {
                        params = params + String.format("&%s=%s", URLEncoder.encode(entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8"));
                    }
                    requestBody = params.replaceFirst("&", "");
                }
                if (this._debugMode.booleanValue()) {
                    this._logger.info("RequestData: {}", this._requestData);
                    this._logger.info("RequestBody: {}", (Object)requestBody);
                }
                OutputStreamWriter osw = new OutputStreamWriter(this._connection.getOutputStream(), "UTF-8");
                Object i$ = null;
                try {
                    osw.write(requestBody);
                    osw.flush();
                }
                catch (Throwable throwable) {
                    i$ = throwable;
                    throw throwable;
                }
                finally {
                    if (osw != null) {
                        if (i$ != null) {
                            try {
                                osw.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)i$).addSuppressed(x2);
                            }
                        } else {
                            osw.close();
                        }
                    }
                }
            }
            this._responseCode = this._connection.getResponseCode();
            InputStream is = this._responseCode != 200 && this._responseCode != 204 ? this._connection.getErrorStream() : this._connection.getInputStream();
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
                String line;
                resp = new StringBuffer();
                while ((line = rd.readLine()) != null) {
                    resp.append(line);
                }
            }
            String responseString = resp.toString();
            if (this._debugMode.booleanValue()) {
                if (this._responseCode == 200 || this._responseCode == 204) {
                    this._logger.info("Response OK: {}", (Object)responseString);
                } else {
                    this._logger.info("Response ERROR: {}", (Object)responseString);
                }
            }
            if (this._responseCode == 200) {
                this.readResponseHeaders(this._connection);
                response = (Dto)this.castResponseToEntity(classOfT, new JsonParser().parse(responseString).getAsJsonObject());
                if (this._debugMode.booleanValue()) {
                    this._logger.info("Response object: {}", (Object)response.toString());
                }
            }
            this.checkResponseCode(responseString);
        }
        catch (Exception ex) {
            if (this._debugMode.booleanValue()) {
                this._logger.error("EXCEPTION: {}", (Object)Arrays.toString(ex.getStackTrace()));
            }
            throw ex;
        }
        return (T)response;
    }

    private void readResponseHeaders(HttpURLConnection conn) {
        for (Map.Entry<String, List<String>> k : conn.getHeaderFields().entrySet()) {
            for (String v : k.getValue()) {
                String linkValue;
                String[] links;
                if (this._debugMode.booleanValue()) {
                    this._logger.info("Response header: {}", (Object)(k.getKey() + ":" + v));
                }
                if (k.getKey() == null) continue;
                if (k.getKey().equals("X-Number-Of-Pages")) {
                    this._pagination.TotalPages = Integer.parseInt(v);
                }
                if (k.getKey().equals("X-Number-Of-Items")) {
                    this._pagination.TotalItems = Integer.parseInt(v);
                }
                if (!k.getKey().equals("Link") || (links = (linkValue = v).split(",")) == null || links.length <= 0) continue;
                for (String link : links) {
                    link = link.replaceAll(Matcher.quoteReplacement("<\""), "");
                    link = link.replaceAll(Matcher.quoteReplacement("\">"), "");
                    link = link.replaceAll(Matcher.quoteReplacement(" rel=\""), "");
                    String[] oneLink = (link = link.replaceAll(Matcher.quoteReplacement("\""), "")).split(";");
                    if (oneLink == null || oneLink.length <= 1 || oneLink[0] == null || oneLink[1] == null) continue;
                    this._pagination.Links = oneLink;
                }
            }
        }
    }

    private <T extends Dto> HashMap<String, Object> buildRequestData(Class<T> classOfT, T entity) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> readOnlyProperties = entity.getReadOnlyProperties();
        String fieldName = "";
        for (Field f : entity.getClass().getFields()) {
            boolean isList = false;
            for (Class<?> i : f.getType().getInterfaces()) {
                if (!i.getName().equals("java.util.List")) continue;
                isList = true;
                break;
            }
            fieldName = f.getName();
            boolean isReadOnly = false;
            for (String s : readOnlyProperties) {
                if (!s.equals(fieldName)) continue;
                isReadOnly = true;
                break;
            }
            if (isReadOnly) continue;
            if (this.canReadSubRequestData(classOfT, fieldName).booleanValue()) {
                HashMap subRequestData;
                block10: {
                    subRequestData = new HashMap();
                    try {
                        Method m = RestTool.class.getDeclaredMethod("buildRequestData", Class.class, Dto.class);
                        subRequestData = (HashMap)m.invoke((Object)this, f.getType(), f.get(entity));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                        if (!this._debugMode.booleanValue()) break block10;
                        this._logger.error("EXCEPTION: {}", (Object)Arrays.toString(ex.getStackTrace()));
                    }
                }
                for (Map.Entry e : subRequestData.entrySet()) {
                    result.put((String)e.getKey(), e.getValue());
                }
                continue;
            }
            try {
                if (!isList) {
                    result.put(fieldName, f.get(entity));
                    continue;
                }
                result.put(fieldName, ((List)f.get(entity)).toArray());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                // empty catch block
            }
        }
        return result;
    }

    private <T> Boolean canReadSubRequestData(Class<T> classOfT, String fieldName) {
        if (classOfT.getName().equals(PayIn.class.getName()) && (fieldName.equals("PaymentDetails") || fieldName.equals("ExecutionDetails"))) {
            return true;
        }
        if (classOfT.getName().equals(PayOut.class.getName()) && fieldName.equals("MeanOfPaymentDetails")) {
            return true;
        }
        if (classOfT.getName().equals(BankAccount.class.getName()) && fieldName.equals("Details")) {
            return true;
        }
        return false;
    }

    public <T> T castResponseToEntity(Class<T> classOfT, JsonObject response) throws Exception {
        return this.castResponseToEntity(classOfT, response, false);
    }

    private <T> T castResponseToEntity(Class<T> classOfT, JsonObject response, boolean asDependentObject) throws Exception {
        try {
            if (this._debugMode.booleanValue()) {
                this._logger.info("Entity type: {}", (Object)classOfT.getName());
            }
            if (classOfT.getName().equals(IdempotencyResponse.class.getName())) {
                IdempotencyResponse resp = new IdempotencyResponse();
                for (Map.Entry entry : response.entrySet()) {
                    if (((String)entry.getKey()).equals("StatusCode")) {
                        resp.StatusCode = ((JsonElement)entry.getValue()).getAsString();
                        continue;
                    }
                    if (((String)entry.getKey()).equals("ContentLength")) {
                        resp.ContentLength = ((JsonElement)entry.getValue()).getAsString();
                        continue;
                    }
                    if (((String)entry.getKey()).equals("ContentType")) {
                        resp.ContentType = ((JsonElement)entry.getValue()).getAsString();
                        continue;
                    }
                    if (((String)entry.getKey()).equals("Date")) {
                        resp.Date = ((JsonElement)entry.getValue()).getAsString();
                        continue;
                    }
                    if (((String)entry.getKey()).equals("Resource")) {
                        resp.Resource = ((JsonElement)entry.getValue()).toString();
                        continue;
                    }
                    if (!((String)entry.getKey()).equals("RequestURL")) continue;
                    resp.RequestURL = ((JsonElement)entry.getValue()).toString();
                }
                return (T)resp;
            }
            Object result = null;
            if (classOfT.getName().equals(User.class.getName())) {
                for (Map.Entry entry : response.entrySet()) {
                    if (!((String)entry.getKey()).equals("PersonType")) continue;
                    String userType = ((JsonElement)entry.getValue()).getAsString();
                    if (userType.equals(PersonType.NATURAL.toString())) {
                        result = new UserNatural();
                        break;
                    }
                    if (userType.equals(PersonType.LEGAL.toString())) {
                        result = new UserLegal();
                        break;
                    }
                    throw new Exception(String.format("Unknown type of user: %s", ((JsonElement)entry.getValue()).getAsString()));
                }
            } else {
                result = classOfT.newInstance();
            }
            Map<String, Type> subObjects = ((Dto)result).getSubObjects();
            Map<String, Map<String, Map<String, Class<?>>>> dependentObjects = ((Dto)result).getDependentObjects();
            block4: for (Field f : result.getClass().getFields()) {
                String name = f.getName();
                boolean isList = false;
                for (Class<?> i : f.getType().getInterfaces()) {
                    if (!i.getName().equals("java.util.List")) continue;
                    isList = true;
                    break;
                }
                if (!asDependentObject && dependentObjects.containsKey(name)) {
                    Map<String, Map<String, Class<?>>> allowedTypes = dependentObjects.get(name);
                    for (Map.Entry entry : response.entrySet()) {
                        if (!((String)entry.getKey()).equals(name)) continue;
                        String paymentTypeDef = ((JsonElement)entry.getValue()).getAsString();
                        if (!allowedTypes.containsKey(paymentTypeDef)) break;
                        Map<String, Class<?>> targetObjectsDef = allowedTypes.get(paymentTypeDef);
                        for (Map.Entry<String, Class<?>> e : targetObjectsDef.entrySet()) {
                            Field targetField = classOfT.getDeclaredField(e.getKey());
                            if (isList) {
                                targetField.set(result, Arrays.asList(this.castResponseToEntity(e.getValue(), response, true)));
                                continue;
                            }
                            targetField.set(result, this.castResponseToEntity(e.getValue(), response, true));
                        }
                    }
                }
                for (Map.Entry entry : response.entrySet()) {
                    if (!((String)entry.getKey()).equals(name)) continue;
                    if (subObjects.containsKey(name)) {
                        if (entry.getValue() instanceof JsonNull) {
                            f.set(result, null);
                            continue block4;
                        }
                        f.set(result, this.castResponseToEntity(f.getType(), ((JsonElement)entry.getValue()).getAsJsonObject()));
                        continue block4;
                    }
                    String fieldTypeName = f.getType().getName();
                    boolean fieldIsArray = false;
                    for (Class<?> i : f.getType().getInterfaces()) {
                        if (!i.getName().equals("java.util.List")) continue;
                        fieldIsArray = true;
                        break;
                    }
                    if (this._debugMode.booleanValue()) {
                        this._logger.info("Recognized field: {}", (Object)String.format("[%s] %s%s", name, fieldTypeName, fieldIsArray ? "[]" : ""));
                    }
                    if (fieldIsArray) {
                        Class<?> i;
                        ParameterizedType genericType = (ParameterizedType)f.getGenericType();
                        Class genericTypeClass = (Class)genericType.getActualTypeArguments()[0];
                        if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
                        JsonArray ja = ((JsonElement)entry.getValue()).getAsJsonArray();
                        i = ja.iterator();
                        Class<?> classOfList = Class.forName(fieldTypeName);
                        Method addMethod = classOfList.getDeclaredMethod("add", Object.class);
                        Method toArrayMethod = classOfList.getDeclaredMethod("add", Object.class);
                        Object o = classOfList.newInstance();
                        while (i.hasNext()) {
                            JsonElement e = (JsonElement)i.next();
                            if (genericTypeClass.getName().equals(String.class.getName())) {
                                addMethod.invoke(o, e.getAsJsonPrimitive().getAsString());
                                continue;
                            }
                            if (genericTypeClass.getName().equals(Integer.TYPE.getName())) {
                                addMethod.invoke(o, e.getAsJsonPrimitive().getAsInt());
                                continue;
                            }
                            if (genericTypeClass.getName().equals(Long.TYPE.getName())) {
                                addMethod.invoke(o, e.getAsJsonPrimitive().getAsLong());
                                continue;
                            }
                            if (genericTypeClass.getName().equals(Double.class.getName())) {
                                addMethod.invoke(o, e.getAsJsonPrimitive().getAsDouble());
                                continue;
                            }
                            if (!genericTypeClass.isEnum()) continue;
                            Class cls = genericTypeClass;
                            Object val = Enum.valueOf(cls, e.getAsJsonPrimitive().getAsString());
                            addMethod.invoke(o, val);
                        }
                        f.set(result, o);
                        continue;
                    }
                    if (((JsonElement)entry.getValue()).isJsonNull()) continue block4;
                    if (fieldTypeName.equals(Integer.TYPE.getName())) {
                        f.setInt(result, ((JsonElement)entry.getValue()).getAsInt());
                        continue block4;
                    }
                    if (fieldTypeName.equals(Integer.class.getName())) {
                        f.set(result, ((JsonElement)entry.getValue()).getAsInt());
                        continue block4;
                    }
                    if (fieldTypeName.equals(Long.TYPE.getName())) {
                        f.setLong(result, ((JsonElement)entry.getValue()).getAsLong());
                        continue block4;
                    }
                    if (fieldTypeName.equals(Double.class.getName())) {
                        f.set(result, ((JsonElement)entry.getValue()).getAsDouble());
                        continue block4;
                    }
                    if (fieldTypeName.equals(String.class.getName())) {
                        f.set(result, ((JsonElement)entry.getValue()).getAsString());
                        continue block4;
                    }
                    if (fieldTypeName.equals(Boolean.class.getName())) {
                        f.set(result, ((JsonElement)entry.getValue()).getAsBoolean());
                        continue block4;
                    }
                    if (!f.getType().isEnum()) continue block4;
                    Class<?> cls = f.getType();
                    Object val = Enum.valueOf(cls, ((JsonElement)entry.getValue()).getAsString());
                    f.set(result, val);
                    continue block4;
                }
            }
            if (classOfT.getName().equals(Address.class.getName()) && !((Address)result).isValid().booleanValue()) {
                result = null;
            }
            return (T)result;
        }
        catch (Exception e) {
            if (this._debugMode.booleanValue()) {
                this._logger.error("EXCEPTION: {}", (Object)Arrays.toString(e.getStackTrace()));
            }
            throw e;
        }
    }

    private <T extends Dto> List<T> doRequestList(Class<T[]> classOfT, Class<T> classOfTItem, String urlMethod, Pagination pagination) throws Exception {
        return this.doRequestList(classOfT, classOfTItem, urlMethod, pagination, null);
    }

    private <T extends Dto> List<T> doRequestList(Class<T[]> classOfT, Class<T> classOfTItem, String urlMethod, Pagination pagination, Map<String, String> additionalUrlParams) throws Exception {
        ArrayList<Dto> response = new ArrayList<Dto>();
        try {
            StringBuffer resp;
            UrlTool urlTool = new UrlTool(this._root);
            String restUrl = urlTool.getRestUrl(urlMethod, this._authRequired, pagination, additionalUrlParams);
            URL url = new URL(urlTool.getFullUrl(restUrl));
            if (this._debugMode.booleanValue()) {
                this._logger.info("FullUrl: {}", (Object)urlTool.getFullUrl(restUrl));
            }
            this._connection = (HttpURLConnection)url.openConnection();
            this._connection.setRequestMethod(this._requestType);
            Map<String, String> httpHeaders = this.getHttpHeaders(restUrl);
            for (Map.Entry<String, String> entry2 : httpHeaders.entrySet()) {
                this._connection.addRequestProperty(entry2.getKey(), entry2.getValue());
                if (!this._debugMode.booleanValue()) continue;
                this._logger.info("HTTP Header: {}", (Object)(entry2.getKey() + ": " + entry2.getValue()));
            }
            this._connection.setUseCaches(false);
            this._connection.setDoInput(true);
            this._connection.setDoOutput(true);
            if (pagination != null) {
                this._pagination = pagination;
            }
            if (this._debugMode.booleanValue()) {
                this._logger.info("RequestType: {}", (Object)this._requestType);
            }
            if (this._requestData != null) {
                String params = "";
                for (Map.Entry<String, String> entry : this._requestData.entrySet()) {
                    params = params + String.format("&%s=%s", URLEncoder.encode(entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8"));
                }
                String requestBody = params.replaceFirst("&", "");
                Throwable throwable = null;
                try (DataOutputStream wr = new DataOutputStream(this._connection.getOutputStream());){
                    wr.writeBytes(requestBody);
                    wr.flush();
                }
                catch (Throwable x2) {
                    Throwable throwable2 = x2;
                    throw x2;
                }
                if (this._debugMode.booleanValue()) {
                    this._logger.info("RequestData: {}", this._requestData);
                    this._logger.info("RequestBody: {}", (Object)requestBody);
                }
            }
            this._responseCode = this._connection.getResponseCode();
            InputStream is = this._responseCode != 200 ? this._connection.getErrorStream() : this._connection.getInputStream();
            Throwable throwable = null;
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(is));){
                String line;
                resp = new StringBuffer();
                while ((line = rd.readLine()) != null) {
                    resp.append(line);
                    resp.append('\r');
                }
            }
            catch (Throwable x2) {
                Throwable throwable3 = x2;
                throw x2;
            }
            String responseString = resp.toString();
            if (this._debugMode.booleanValue()) {
                if (this._responseCode == 200) {
                    this._logger.info("Response OK: {}", (Object)responseString);
                } else {
                    this._logger.info("Response ERROR: {}", (Object)responseString);
                }
            }
            if (this._responseCode == 200) {
                this.readResponseHeaders(this._connection);
                JsonArray jsonArray = new JsonParser().parse(responseString).getAsJsonArray();
                for (int x = 0; x < jsonArray.size(); ++x) {
                    JsonObject jo = jsonArray.get(x).getAsJsonObject();
                    Dto toAdd = (Dto)this.castResponseToEntity(classOfTItem, jo);
                    response.add(toAdd);
                }
                if (this._debugMode.booleanValue()) {
                    this._logger.info("Response object: {}", (Object)((Object)response).toString());
                    this._logger.info("Elements count: {}", (Object)response.size());
                }
            }
            this.checkResponseCode(responseString);
        }
        catch (Exception ex) {
            if (this._debugMode.booleanValue()) {
                this._logger.error("EXCEPTION: {}", (Object)Arrays.toString(ex.getStackTrace()));
            }
            throw ex;
        }
        return response;
    }

    private Map<String, String> getHttpHeaders(String restUrl) throws Exception {
        if (this._requestHttpHeaders != null) {
            return this._requestHttpHeaders;
        }
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Content-Type", "application/json");
        if (this._authRequired.booleanValue()) {
            AuthenticationHelper authHlp = new AuthenticationHelper(this._root);
            httpHeaders.putAll(authHlp.getHttpHeaderKey());
        }
        return httpHeaders;
    }

    private void checkResponseCode(String message) throws ResponseException {
        if (this._responseCode != 200 && this._responseCode != 204) {
            HashMap<Integer, String> responseCodes = new HashMap<Integer, String>(){
                {
                    this.put(206, "PartialContent");
                    this.put(400, "Bad request");
                    this.put(401, "Unauthorized");
                    this.put(403, "Prohibition to use the method");
                    this.put(404, "Not found");
                    this.put(405, "Method not allowed");
                    this.put(413, "Request entity too large");
                    this.put(422, "Unprocessable entity");
                    this.put(500, "Internal server error");
                    this.put(501, "Not implemented");
                }
            };
            ResponseException responseException = new ResponseException(message);
            responseException.ResponseHttpCode = this._responseCode;
            responseException.ResponseHttpDescription = responseCodes.containsKey(this._responseCode) ? (String)responseCodes.get(this._responseCode) : "Unknown response error";
            if (message != null) {
                JsonObject error = new JsonParser().parse(message).getAsJsonObject();
                for (Map.Entry entry : error.entrySet()) {
                    switch (((String)entry.getKey()).toLowerCase()) {
                        case "message": {
                            responseException.ApiMessage = ((JsonElement)entry.getValue()).getAsString();
                            break;
                        }
                        case "type": {
                            responseException.Type = ((JsonElement)entry.getValue()).getAsString();
                            break;
                        }
                        case "id": {
                            responseException.Id = ((JsonElement)entry.getValue()).getAsString();
                            break;
                        }
                        case "date": {
                            responseException.Date = (int)((JsonElement)entry.getValue()).getAsDouble();
                            break;
                        }
                        case "errors": {
                            if (entry.getValue() == null || ((JsonElement)entry.getValue()).isJsonNull()) break;
                            for (Map.Entry errorEntry : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                                if (!responseException.Errors.containsKey(errorEntry.getKey())) {
                                    responseException.Errors.put((String)errorEntry.getKey(), ((JsonElement)errorEntry.getValue()).getAsString());
                                    continue;
                                }
                                String description = responseException.Errors.get(errorEntry.getKey());
                                description = " | " + ((JsonElement)errorEntry.getValue()).getAsString();
                                responseException.Errors.put((String)errorEntry.getKey(), description);
                            }
                            break;
                        }
                    }
                }
            }
            throw responseException;
        }
    }
}

