/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core;

import com.mangopay.MangoPayApi;
import com.mangopay.core.APIs.ApiBase;
import com.mangopay.core.DefaultStorageStrategy;
import com.mangopay.core.OAuthToken;
import com.mangopay.core.interfaces.IStorageStrategy;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class AuthorizationTokenManager
extends ApiBase {
    private IStorageStrategy _storageStrategy;

    public AuthorizationTokenManager(MangoPayApi root) {
        super(root);
        this.registerCustomStorageStrategy(new DefaultStorageStrategy());
    }

    public OAuthToken getToken() throws Exception {
        OAuthToken token = this._storageStrategy.get(this.GetEnvKey());
        if (token == null || token.IsExpired().booleanValue()) {
            this.storeToken(this._root.AuthenticationManager.createToken());
        }
        return this._storageStrategy.get(this.GetEnvKey());
    }

    public void storeToken(OAuthToken token) {
        this._storageStrategy.store(token, this.GetEnvKey());
    }

    public void registerCustomStorageStrategy(IStorageStrategy customStorageStrategy) {
        this._storageStrategy = customStorageStrategy;
    }

    private String GetEnvKey() {
        String input = this._root.Config.BaseUrl + this._root.Config.ClientId + this._root.Config.ClientPassword;
        String md5 = "";
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(input.getBytes(), 0, input.length());
            md5 = new BigInteger(1, m.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return md5;
    }
}

