/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core.APIs;

import com.mangopay.MangoPayApi;
import com.mangopay.core.APIs.ApiBase;
import com.mangopay.core.FilterTransactions;
import com.mangopay.core.Pagination;
import com.mangopay.core.Sorting;
import com.mangopay.core.enumerations.KycDocumentType;
import com.mangopay.entities.BankAccount;
import com.mangopay.entities.Card;
import com.mangopay.entities.KycDocument;
import com.mangopay.entities.KycPage;
import com.mangopay.entities.Transaction;
import com.mangopay.entities.User;
import com.mangopay.entities.UserLegal;
import com.mangopay.entities.UserNatural;
import com.mangopay.entities.Wallet;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class ApiUsers
extends ApiBase {
    public ApiUsers(MangoPayApi root) {
        super(root);
    }

    public User get(String userId) throws Exception {
        return this.getObject(User.class, "users_get", userId);
    }

    public User create(User user) throws Exception {
        return this.create(null, user);
    }

    public User create(String idempotencyKey, User user) throws Exception {
        User response = null;
        if (user instanceof UserNatural) {
            response = this.createObject(UserNatural.class, idempotencyKey, "users_createnaturals", (UserNatural)user);
        } else if (user instanceof UserLegal) {
            response = this.createObject(UserLegal.class, idempotencyKey, "users_createlegals", (UserLegal)user);
        } else {
            throw new Exception("Unsupported user entity type.");
        }
        return response;
    }

    public List<User> getAll(Pagination pagination, Sorting sorting) throws Exception {
        return this.getList(User[].class, User.class, "users_all", pagination, sorting);
    }

    public List<User> getAll() throws Exception {
        return this.getAll(null, null);
    }

    public UserNatural getNatural(String userId) throws Exception {
        return this.getObject(UserNatural.class, "users_getnaturals", userId);
    }

    public UserLegal getLegal(String userId) throws Exception {
        return this.getObject(UserLegal.class, "users_getlegals", userId);
    }

    public User update(User user) throws Exception {
        String methodKey = "";
        if (user instanceof UserNatural) {
            methodKey = "users_savenaturals";
        } else if (user instanceof UserLegal) {
            methodKey = "users_savelegals";
        } else {
            throw new Exception("Unsupported user entity type.");
        }
        return this.updateObject(User.class, methodKey, user);
    }

    public BankAccount createBankAccount(String userId, BankAccount bankAccount) throws Exception {
        return this.createBankAccount(null, userId, bankAccount);
    }

    public BankAccount createBankAccount(String idempotencyKey, String userId, BankAccount bankAccount) throws Exception {
        String type = this.getBankAccountType(bankAccount);
        return this.createObject(BankAccount.class, idempotencyKey, "users_createbankaccounts_" + type, bankAccount, userId);
    }

    public BankAccount updateBankAccount(String userId, BankAccount bankAccount, String bankAccountId) throws Exception {
        return this.updateObject(BankAccount.class, "users_savebankaccount", bankAccount, userId, bankAccountId);
    }

    public List<BankAccount> getBankAccounts(String userId, Pagination pagination, Sorting sorting) throws Exception {
        return this.getList(BankAccount[].class, BankAccount.class, "users_allbankaccount", pagination, userId, sorting);
    }

    public List<BankAccount> getBankAccounts(String userId) throws Exception {
        return this.getBankAccounts(userId, null, null);
    }

    public BankAccount getBankAccount(String userId, String bankAccountId) throws Exception {
        return this.getObject(BankAccount.class, "users_getbankaccount", userId, bankAccountId);
    }

    public List<Wallet> getWallets(String userId, Pagination pagination, Sorting sorting) throws Exception {
        return this.getList(Wallet[].class, Wallet.class, "users_allwallets", pagination, userId, sorting);
    }

    public List<Wallet> getWallets(String userId) throws Exception {
        return this.getWallets(userId, null, null);
    }

    public List<Transaction> getTransactions(String userId, Pagination pagination, FilterTransactions filter, Sorting sorting) throws Exception {
        return this.getList(Transaction[].class, Transaction.class, "users_alltransactions", pagination, userId, filter.getValues(), sorting);
    }

    public List<Card> getCards(String userId, Pagination pagination, Sorting sorting) throws Exception {
        return this.getList(Card[].class, Card.class, "users_allcards", pagination, userId, sorting);
    }

    public void createKycPage(String userId, String kycDocumentId, byte[] binaryData) throws Exception {
        this.createKycPage(null, userId, kycDocumentId, binaryData);
    }

    public void createKycPage(String idempotencyKey, String userId, String kycDocumentId, byte[] binaryData) throws Exception {
        String fileContent;
        KycPage kycPage = new KycPage();
        kycPage.File = fileContent = new String(Base64.encodeBase64((byte[])binaryData));
        this.createObject(KycPage.class, idempotencyKey, "kyc_page_create", kycPage, userId, kycDocumentId);
    }

    public void createKycPage(String userId, String kycDocumentId, String filePath) throws Exception {
        Path path = Paths.get(filePath, new String[0]);
        byte[] fileArray = Files.readAllBytes(path);
        this.createKycPage(userId, kycDocumentId, fileArray);
    }

    public void createKycPage(String idempotencyKey, String userId, String kycDocumentId, String filePath) throws Exception {
        Path path = Paths.get(filePath, new String[0]);
        byte[] fileArray = Files.readAllBytes(path);
        this.createKycPage(idempotencyKey, userId, kycDocumentId, fileArray);
    }

    public KycDocument createKycDocument(String userId, KycDocumentType type) throws Exception {
        return this.createKycDocument(null, userId, type);
    }

    public KycDocument createKycDocument(String idempotencyKey, String userId, KycDocumentType type) throws Exception {
        KycDocument kycDocument = new KycDocument();
        kycDocument.Type = type;
        return this.createObject(KycDocument.class, idempotencyKey, "users_createkycdocument", kycDocument, userId);
    }

    public KycDocument getKycDocument(String userId, String kycDocumentId) throws Exception {
        return this.getObject(KycDocument.class, "users_getkycdocument", userId, kycDocumentId);
    }

    public KycDocument updateKycDocument(String userId, KycDocument kycDocument) throws Exception {
        return this.updateObject(KycDocument.class, "users_savekycdocument", kycDocument, userId);
    }

    public List<KycDocument> getKycDocuments(String userId, Pagination pagination, Sorting sorting) throws Exception {
        return this.getList(KycDocument[].class, KycDocument.class, "users_allkycdocuments", pagination, userId, sorting);
    }

    private String getBankAccountType(BankAccount bankAccount) throws Exception {
        if (bankAccount.Details == null) {
            throw new Exception("Details is not defined.");
        }
        String className = bankAccount.Details.getClass().getSimpleName().replace("BankAccountDetails", "");
        return className.toLowerCase();
    }
}

