/*
 * Decompiled with CFR 0.152.
 */
package com.mangopay.core.APIs;

import com.mangopay.MangoPayApi;
import com.mangopay.core.APIs.ApiBase;
import com.mangopay.core.FilterDisputeDocuments;
import com.mangopay.core.FilterDisputes;
import com.mangopay.core.FilterTransactions;
import com.mangopay.core.Money;
import com.mangopay.core.Pagination;
import com.mangopay.core.Sorting;
import com.mangopay.entities.Dispute;
import com.mangopay.entities.DisputeDocument;
import com.mangopay.entities.DisputePage;
import com.mangopay.entities.Repudiation;
import com.mangopay.entities.SettlementTransfer;
import com.mangopay.entities.Transaction;
import com.mangopay.entities.Transfer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class ApiDisputes
extends ApiBase {
    public ApiDisputes(MangoPayApi root) {
        super(root);
    }

    public Dispute get(String disputeId) throws Exception {
        return this.getObject(Dispute.class, "disputes_get", disputeId);
    }

    public List<Dispute> getAll(Pagination pagination, FilterDisputes filters, Sorting sorting) throws Exception {
        if (filters == null) {
            filters = new FilterDisputes();
        }
        return this.getList(Dispute[].class, Dispute.class, "disputes_get_all", pagination, null, filters.getValues(), sorting);
    }

    public List<Dispute> getAll() throws Exception {
        return this.getAll(null, null, null);
    }

    public List<Transaction> getTransactions(String disputeId, Pagination pagination, FilterTransactions filters, Sorting sorting) throws Exception {
        if (filters == null) {
            filters = new FilterTransactions();
        }
        return this.getList(Transaction[].class, Transaction.class, "disputes_get_transactions", pagination, disputeId, filters.getValues(), sorting);
    }

    public List<Dispute> getDisputesForWallet(String walletId, Pagination pagination, FilterDisputes filters, Sorting sorting) throws Exception {
        if (filters == null) {
            filters = new FilterDisputes();
        }
        return this.getList(Dispute[].class, Dispute.class, "disputes_get_for_wallet", pagination, walletId, filters.getValues(), sorting);
    }

    public List<Dispute> getDisputesForUser(String userId, Pagination pagination, FilterDisputes filters, Sorting sorting) throws Exception {
        if (filters == null) {
            filters = new FilterDisputes();
        }
        return this.getList(Dispute[].class, Dispute.class, "disputes_get_for_user", pagination, userId, filters.getValues(), sorting);
    }

    public DisputeDocument getDocument(String documentId) throws Exception {
        return this.getObject(DisputeDocument.class, "disputes_document_get", documentId);
    }

    public List<DisputeDocument> getDocumentsForDispute(String disputeId, Pagination pagination, FilterDisputeDocuments filters, Sorting sorting) throws Exception {
        if (filters == null) {
            filters = new FilterDisputeDocuments();
        }
        return this.getList(DisputeDocument[].class, DisputeDocument.class, "disputes_document_get_for_dispute", pagination, disputeId, filters.getValues(), sorting);
    }

    public List<DisputeDocument> getDocumentsForClient(Pagination pagination, FilterDisputeDocuments filters, Sorting sorting) throws Exception {
        if (filters == null) {
            filters = new FilterDisputeDocuments();
        }
        return this.getList(DisputeDocument[].class, DisputeDocument.class, "disputes_document_get_for_client", pagination, null, filters.getValues(), sorting);
    }

    public Repudiation getRepudiation(String repudiationId) throws Exception {
        return this.getObject(Repudiation.class, "disputes_repudiation_get", repudiationId);
    }

    public Transfer createSettlementTransfer(SettlementTransfer settlementTransfer, String repudiationId) throws Exception {
        return this.createSettlementTransfer(null, settlementTransfer, repudiationId);
    }

    public Transfer createSettlementTransfer(String idempotencyKey, SettlementTransfer settlementTransfer, String repudiationId) throws Exception {
        Transfer settlement = new Transfer();
        settlement.AuthorId = settlementTransfer.AuthorId;
        settlement.DebitedFunds = settlementTransfer.DebitedFunds;
        settlement.Fees = settlementTransfer.Fees;
        return this.createObject(Transfer.class, idempotencyKey, "disputes_repudiation_create_settlement", settlement, repudiationId);
    }

    public Dispute updateTag(String tag, String disputeId) throws Exception {
        Dispute dispute = new Dispute();
        dispute.Tag = tag;
        return this.updateObject(Dispute.class, "disputes_save_tag", dispute, disputeId);
    }

    public DisputeDocument submitDisputeDocument(DisputeDocument disputeDocument, String disputeId) throws Exception {
        return this.updateObject(DisputeDocument.class, "disputes_document_submit", disputeDocument, disputeId);
    }

    public Dispute contestDispute(Money contestedFunds, String disputeId) throws Exception {
        Dispute disputeContest = new Dispute();
        disputeContest.ContestedFunds = contestedFunds;
        return this.updateObject(Dispute.class, "disputes_save_contest_funds", disputeContest, disputeId);
    }

    public Dispute resubmitDispute(String disputeId) throws Exception {
        Dispute dispute = new Dispute();
        return this.updateObject(Dispute.class, "disputes_save_contest_funds", dispute, disputeId);
    }

    public Dispute closeDispute(String disputeId) throws Exception {
        return this.updateObject(Dispute.class, "disputes_save_close", new Dispute(), disputeId);
    }

    public DisputeDocument createDisputeDocument(DisputeDocument disputeDocument, String disputeId) throws Exception {
        return this.createDisputeDocument(null, disputeDocument, disputeId);
    }

    public DisputeDocument createDisputeDocument(String idempotencyKey, DisputeDocument disputeDocument, String disputeId) throws Exception {
        return this.createObject(DisputeDocument.class, idempotencyKey, "disputes_document_create", disputeDocument, disputeId);
    }

    public void createDisputePage(String disputeId, String documentId, byte[] binaryData) throws Exception {
        this.createDisputePage(null, disputeId, documentId);
    }

    public void createDisputePage(String idempotencyKey, String disputeId, String documentId, byte[] binaryData) throws Exception {
        String fileContent;
        DisputePage disputePage = new DisputePage();
        disputePage.File = fileContent = new String(Base64.encodeBase64((byte[])binaryData));
        this.createObject(DisputePage.class, idempotencyKey, "disputes_document_page_create", disputePage, disputeId, documentId);
    }

    public void createDisputePage(String disputeId, String documentId, String filePath) throws IOException, Exception {
        this.createDisputePage(null, disputeId, documentId, filePath);
    }

    public void createDisputePage(String idempotencyKey, String disputeId, String documentId, String filePath) throws IOException, Exception {
        Path path = Paths.get(filePath, new String[0]);
        byte[] fileArray = Files.readAllBytes(path);
        this.createDisputePage(idempotencyKey, disputeId, documentId, fileArray);
    }
}

