/*
 * Decompiled with CFR 0.152.
 */
package com.makeramen;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import com.makeramen.R;
import com.makeramen.RoundedDrawable;

public class RoundedImageView
extends ImageView {
    public static final String TAG = "RoundedImageView";
    public static final int DEFAULT_RADIUS = 0;
    public static final int DEFAULT_BORDER_WIDTH = 0;
    private static final ImageView.ScaleType[] SCALE_TYPES = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    private int mCornerRadius = 0;
    private int mBorderWidth = 0;
    private ColorStateList mBorderColor = ColorStateList.valueOf((int)-16777216);
    private boolean mOval = false;
    private boolean mRoundBackground = false;
    private int mResource;
    private Drawable mDrawable;
    private Drawable mBackgroundDrawable;
    private ImageView.ScaleType mScaleType;

    public RoundedImageView(Context context) {
        super(context);
    }

    public RoundedImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundedImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RoundedImageView, defStyle, 0);
        int index = a.getInt(0, -1);
        if (index >= 0) {
            this.setScaleType(SCALE_TYPES[index]);
        } else {
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
        this.mCornerRadius = a.getDimensionPixelSize(1, -1);
        this.mBorderWidth = a.getDimensionPixelSize(2, -1);
        if (this.mCornerRadius < 0) {
            this.mCornerRadius = 0;
        }
        if (this.mBorderWidth < 0) {
            this.mBorderWidth = 0;
        }
        this.mBorderColor = a.getColorStateList(3);
        if (this.mBorderColor == null) {
            this.mBorderColor = ColorStateList.valueOf((int)-16777216);
        }
        this.mRoundBackground = a.getBoolean(4, false);
        this.mOval = a.getBoolean(5, false);
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs();
        a.recycle();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType == null) {
            throw new NullPointerException();
        }
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            switch (scaleType) {
                case CENTER: 
                case CENTER_CROP: 
                case CENTER_INSIDE: 
                case FIT_CENTER: 
                case FIT_START: 
                case FIT_END: 
                case FIT_XY: {
                    super.setScaleType(ImageView.ScaleType.FIT_XY);
                    break;
                }
                default: {
                    super.setScaleType(scaleType);
                }
            }
            this.updateDrawableAttrs();
            this.updateBackgroundDrawableAttrs();
            this.invalidate();
        }
    }

    public void setImageDrawable(Drawable drawable) {
        this.mResource = 0;
        this.mDrawable = RoundedDrawable.fromDrawable(drawable);
        this.updateDrawableAttrs();
        super.setImageDrawable(this.mDrawable);
    }

    public void setImageBitmap(Bitmap bm) {
        this.mResource = 0;
        this.mDrawable = RoundedDrawable.fromBitmap(bm);
        this.updateDrawableAttrs();
        super.setImageDrawable(this.mDrawable);
    }

    public void setImageResource(int resId) {
        if (this.mResource != resId) {
            this.mResource = resId;
            this.mDrawable = this.resolveResource();
            this.updateDrawableAttrs();
            super.setImageDrawable(this.mDrawable);
        }
    }

    private Drawable resolveResource() {
        Resources rsrc = this.getResources();
        if (rsrc == null) {
            return null;
        }
        Drawable d = null;
        if (this.mResource != 0) {
            try {
                d = rsrc.getDrawable(this.mResource);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("Unable to find resource: " + this.mResource), (Throwable)e);
                this.mResource = 0;
            }
        }
        return RoundedDrawable.fromDrawable(d);
    }

    public void setBackground(Drawable background) {
        this.setBackgroundDrawable(background);
    }

    private void updateDrawableAttrs() {
        this.updateAttrs(this.mDrawable, false);
    }

    private void updateBackgroundDrawableAttrs() {
        this.updateAttrs(this.mBackgroundDrawable, true);
    }

    private void updateAttrs(Drawable drawable, boolean background) {
        if (drawable == null) {
            return;
        }
        if (drawable instanceof RoundedDrawable) {
            ((RoundedDrawable)drawable).setScaleType(this.mScaleType).setCornerRadius(background && !this.mRoundBackground ? 0.0f : (float)this.mCornerRadius).setBorderWidth(background && !this.mRoundBackground ? 0 : this.mBorderWidth).setBorderColors(this.mBorderColor).setOval(this.mOval);
        } else if (drawable instanceof LayerDrawable) {
            LayerDrawable ld = (LayerDrawable)drawable;
            int layers = ld.getNumberOfLayers();
            for (int i = 0; i < layers; ++i) {
                this.updateAttrs(ld.getDrawable(i), background);
            }
        }
    }

    @Deprecated
    public void setBackgroundDrawable(Drawable background) {
        this.mBackgroundDrawable = RoundedDrawable.fromDrawable(background);
        this.updateBackgroundDrawableAttrs();
        super.setBackgroundDrawable(this.mBackgroundDrawable);
    }

    public int getCornerRadius() {
        return this.mCornerRadius;
    }

    public void setCornerRadius(int radius) {
        if (this.mCornerRadius == radius) {
            return;
        }
        this.mCornerRadius = radius;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs();
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(int width) {
        if (this.mBorderWidth == width) {
            return;
        }
        this.mBorderWidth = width;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs();
        this.invalidate();
    }

    public int getBorderColor() {
        return this.mBorderColor.getDefaultColor();
    }

    public void setBorderColor(int color) {
        this.setBorderColors(ColorStateList.valueOf((int)color));
    }

    public ColorStateList getBorderColors() {
        return this.mBorderColor;
    }

    public void setBorderColors(ColorStateList colors) {
        if (this.mBorderColor.equals(colors)) {
            return;
        }
        this.mBorderColor = colors != null ? colors : ColorStateList.valueOf((int)-16777216);
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs();
        if (this.mBorderWidth > 0) {
            this.invalidate();
        }
    }

    public boolean isOval() {
        return this.mOval;
    }

    public void setOval(boolean oval) {
        this.mOval = oval;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs();
        this.invalidate();
    }

    public boolean isRoundBackground() {
        return this.mRoundBackground;
    }

    public void setRoundBackground(boolean roundBackground) {
        if (this.mRoundBackground == roundBackground) {
            return;
        }
        this.mRoundBackground = roundBackground;
        this.updateBackgroundDrawableAttrs();
        this.invalidate();
    }
}

