/*
 * Decompiled with CFR 0.152.
 */
package com.mailosaur;

import com.google.api.client.http.HttpResponse;
import com.mailosaur.MailosaurClient;
import com.mailosaur.MailosaurException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;

public class Files {
    private MailosaurClient client;

    public Files(MailosaurClient client) {
        this.client = client;
    }

    public byte[] getAttachment(String attachmentId) throws MailosaurException, IOException {
        return this.client.requestFile("GET", "api/files/attachments/" + attachmentId).toByteArray();
    }

    public byte[] getEmail(String messageId) throws MailosaurException, IOException {
        return this.client.requestFile("GET", "api/files/email/" + messageId).toByteArray();
    }

    public byte[] getPreview(String previewId) throws MailosaurException, IOException {
        int timeout = 120000;
        int pollCount = 0;
        long startTime = new Date().getTime();
        while (true) {
            HttpResponse response;
            if ((response = this.client.request("GET", "api/files/screenshots/" + previewId)).getStatusCode() == 200) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                response.download((OutputStream)stream);
                return stream.toByteArray();
            }
            List headerValues = response.getHeaders().getHeaderStringValues("x-ms-delay");
            String[] delayStrings = (headerValues.size() == 0 ? "1000" : (String)headerValues.get(0)).split(",");
            int[] delayPattern = new int[delayStrings.length];
            for (int i = 0; i < delayStrings.length; ++i) {
                delayPattern[i] = Integer.parseInt(delayStrings[i].trim());
            }
            int delay = pollCount >= delayPattern.length ? delayPattern[delayPattern.length - 1] : delayPattern[pollCount];
            ++pollCount;
            if (new Date().getTime() - startTime + (long)delay > (long)timeout) {
                throw new MailosaurException("An email preview was not generated in time. The email client may not be available, or the preview ID [" + previewId + "] may be incorrect.", "preview_timeout");
            }
            try {
                Thread.sleep(delay);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

