/*
 * Decompiled with CFR 0.152.
 */
package com.mailosaur;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ObjectParser;
import com.mailosaur.exception.MailosaurException;
import com.mailosaur.model.DeleteResult;
import com.mailosaur.model.Email;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MailboxApi {
    static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    static final JsonFactory JSON_FACTORY = new GsonFactory();
    static final HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

        public void initialize(HttpRequest request) {
            request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
        }
    });
    final String BASE_URI = "https://api.mailosaur.com/v2";
    final String MAILBOX;
    final String API_KEY;

    public MailboxApi(String mailbox, String apiKey) {
        this.MAILBOX = mailbox;
        this.API_KEY = apiKey;
    }

    private String buildQueryString(Map<String, String> map) throws UnsupportedEncodingException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("key", this.API_KEY);
        if (map != null) {
            queryParams.putAll(map);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : queryParams.entrySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(URLEncoder.encode((String)entry.getKey(), "UTF-8")).append('=').append(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
        }
        return sb.toString();
    }

    private GenericUrl buildUrl(String path, Map<String, String> queryParams) throws UnsupportedEncodingException {
        return new GenericUrl("https://api.mailosaur.com/v2" + path + "?" + this.buildQueryString(queryParams));
    }

    private HttpRequest buildRequest(String method, String path) throws MailosaurException {
        return this.buildRequest(method, path, null);
    }

    private HttpRequest buildRequest(String method, String path, Map<String, String> queryParams) throws MailosaurException {
        try {
            GenericUrl url = this.buildUrl(path, queryParams);
            return method == "POST" ? requestFactory.buildPostRequest(url, null) : requestFactory.buildGetRequest(url);
        }
        catch (UnsupportedEncodingException e) {
            throw new MailosaurException("Unable to encode URL", e);
        }
        catch (IOException e) {
            throw new MailosaurException("Unable to build web request", e);
        }
    }

    private ByteArrayOutputStream downloadFileAsStream(String method, String urlStr) throws MailosaurException, IOException {
        String decoded = URLDecoder.decode(urlStr, "UTF-8");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.executeRequest(method, decoded, null).download((OutputStream)stream);
        return stream;
    }

    private String buildUrlPath(String ... args) throws MailosaurException {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            try {
                sb.append("/" + URLEncoder.encode(arg, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new MailosaurException("Unable to encode URL", e);
            }
        }
        return sb.toString();
    }

    private HttpResponse executeRequest(String method, String url, HashMap<String, String> queryParams) throws MailosaurException {
        IOException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                HttpRequest request = this.buildRequest(method, url, queryParams);
                return request.execute();
            }
            catch (IOException ioException) {
                ex = ioException;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new MailosaurException("Unable to parse API response", ex);
    }

    private Email[] getEmails(Map<String, String> searchCriteria) throws MailosaurException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("mailbox", this.MAILBOX);
        queryParams.putAll(searchCriteria);
        return (Email[])this.executeRequest("GET", "/emails", queryParams).parseAs(Email[].class);
    }

    public Email[] getEmails() throws MailosaurException, IOException {
        return this.getEmails(new HashMap<String, String>());
    }

    public Email[] getEmails(String searchPattern) throws MailosaurException, IOException {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("search", searchPattern);
        return this.getEmails(searchCriteria);
    }

    public Email[] getEmailsByRecipient(String recipientEmail) throws MailosaurException, IOException {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("recipient", recipientEmail);
        return this.getEmails(searchCriteria);
    }

    public Email getEmail(String emailId) throws MailosaurException, IOException {
        return (Email)this.executeRequest("GET", this.buildUrlPath("email", emailId), null).parseAs(Email.class);
    }

    public void deleteAllEmail() throws MailosaurException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("mailbox", this.MAILBOX);
        this.executeRequest("POST", "/emails/deleteall", queryParams);
    }

    public void deleteEmail(String emailId) throws MailosaurException, IOException {
        this.executeRequest("POST", this.buildUrlPath("email", emailId, "delete"), null).parseAs(DeleteResult.class);
    }

    public byte[] getAttachment(String attachmentId) throws MailosaurException, IOException {
        return this.downloadFileAsStream("GET", this.buildUrlPath("attachment", attachmentId)).toByteArray();
    }

    public byte[] getRawEmail(String rawId) throws MailosaurException, IOException {
        return this.downloadFileAsStream("GET", this.buildUrlPath("raw", rawId)).toByteArray();
    }

    public String generateEmailAddress() {
        String uuid = UUID.randomUUID().toString();
        return String.format("%s.%s@mailosaur.in", uuid, this.MAILBOX);
    }
}

