/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client;

import com.mailjet.client.MailjetRequest;
import com.mailjet.client.enums.ApiVersion;
import com.mailjet.client.errors.MailjetClientRequestException;
import com.mailjet.client.errors.MailjetException;
import com.mailjet.client.errors.MailjetRateLimitException;
import com.mailjet.client.errors.MailjetServerException;
import com.mailjet.client.errors.MailjetUnauthorizedException;
import com.mailjet.client.resource.Emailv31;

public final class MailjetResponseUtil {
    private static final int TOO_MANY_REQUEST_STATUS = 429;
    private static final int INTERNAL_SERVER_ERROR_STATUS = 500;
    private static final int BAD_REQUEST_ERROR_STATUS = 400;
    private static final int UNAUTHORIZED_STATUS = 401;
    public static final int CREATED_STATUS = 201;
    private static final String UNAUTHORIZED_MESSAGE = "Unauthorized. Please,verify your access key and access secret key or token for the given account";
    private static final String TOO_MANY_REQUESTS_EXCEPTION = "Too Many Requests";
    private static final String INTERNAL_SERVER_ERROR_GENERAL_EXCEPTION = "Internal Server Error: ";

    private MailjetResponseUtil() {
    }

    public static void validateMailjetResponse(MailjetRequest request, int responseCode, String responseBody) throws MailjetException {
        if (responseCode == 429) {
            throw new MailjetRateLimitException(TOO_MANY_REQUESTS_EXCEPTION);
        }
        if (responseCode == 401) {
            throw new MailjetUnauthorizedException(UNAUTHORIZED_MESSAGE);
        }
        if (responseCode >= 500) {
            throw new MailjetServerException(responseBody == null ? INTERNAL_SERVER_ERROR_GENERAL_EXCEPTION : responseBody);
        }
        if (responseCode >= 400 && !MailjetResponseUtil.isResponseIndicatesPartialSuccess(request, responseCode, responseBody)) {
            throw new MailjetClientRequestException(responseBody, responseCode);
        }
    }

    public static boolean isValidJSON(String json) {
        return json != null && json.trim().startsWith("{") && json.trim().endsWith("}");
    }

    private static boolean isResponseIndicatesPartialSuccess(MailjetRequest request, int responseCode, String responseBody) {
        return responseCode == 400 && MailjetResponseUtil.isValidJSON(responseBody) && ApiVersion.V3_1.equals((Object)request.getApiVersion()) && Emailv31.resource.getResource().equals(request.getResource());
    }
}

