/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.JschSession;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;

public abstract class JschConfigSessionFactory
extends SshSessionFactory {
    private final Map<String, JSch> byIdentityFile = new HashMap<String, JSch>();
    private JSch defaultJSch;
    private OpenSshConfig config;

    public synchronized RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
        String user = uri.getUser();
        String pass = uri.getPass();
        String host = uri.getHost();
        int port = uri.getPort();
        try {
            String pauth;
            String strictHostKeyCheckingPolicy;
            if (this.config == null) {
                this.config = OpenSshConfig.get(fs);
            }
            OpenSshConfig.Host hc = this.config.lookup(host);
            host = hc.getHostName();
            if (port <= 0) {
                port = hc.getPort();
            }
            if (user == null) {
                user = hc.getUser();
            }
            Session session = this.createSession(hc, user, host, port, fs);
            if (pass != null) {
                session.setPassword(pass);
            }
            if ((strictHostKeyCheckingPolicy = hc.getStrictHostKeyChecking()) != null) {
                session.setConfig("StrictHostKeyChecking", strictHostKeyCheckingPolicy);
            }
            if ((pauth = hc.getPreferredAuthentications()) != null) {
                session.setConfig("PreferredAuthentications", pauth);
            }
            if (!(credentialsProvider == null || hc.isBatchMode() && credentialsProvider.isInteractive())) {
                session.setUserInfo((UserInfo)new CredentialsProviderUserInfo(session, credentialsProvider));
            }
            this.configure(hc, session);
            if (!session.isConnected()) {
                session.connect(tms);
            }
            return new JschSession(session, uri);
        }
        catch (JSchException je) {
            Throwable c = je.getCause();
            if (c instanceof UnknownHostException) {
                throw new TransportException(uri, JGitText.get().unknownHost);
            }
            if (c instanceof ConnectException) {
                throw new TransportException(uri, c.getMessage());
            }
            throw new TransportException(uri, je.getMessage(), je);
        }
    }

    protected Session createSession(OpenSshConfig.Host hc, String user, String host, int port, FS fs) throws JSchException {
        return this.getJSch(hc, fs).getSession(user, host, port);
    }

    protected abstract void configure(OpenSshConfig.Host var1, Session var2);

    protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
        File identityFile;
        if (this.defaultJSch == null) {
            this.defaultJSch = this.createDefaultJSch(fs);
            for (Object name : this.defaultJSch.getIdentityNames()) {
                this.byIdentityFile.put((String)name, this.defaultJSch);
            }
        }
        if ((identityFile = hc.getIdentityFile()) == null) {
            return this.defaultJSch;
        }
        String identityKey = identityFile.getAbsolutePath();
        JSch jsch = this.byIdentityFile.get(identityKey);
        if (jsch == null) {
            jsch = new JSch();
            jsch.setHostKeyRepository(this.defaultJSch.getHostKeyRepository());
            jsch.addIdentity(identityKey);
            this.byIdentityFile.put(identityKey, jsch);
        }
        return jsch;
    }

    protected JSch createDefaultJSch(FS fs) throws JSchException {
        JSch jsch = new JSch();
        JschConfigSessionFactory.knownHosts(jsch, fs);
        JschConfigSessionFactory.identities(jsch, fs);
        return jsch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void knownHosts(JSch sch, FS fs) throws JSchException {
        File home = fs.userHome();
        if (home == null) {
            return;
        }
        File known_hosts = new File(new File(home, ".ssh"), "known_hosts");
        try {
            FileInputStream in = new FileInputStream(known_hosts);
            try {
                sch.setKnownHosts((InputStream)in);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                in.close();
                throw throwable;
            }
            in.close();
            {
            }
        }
        catch (FileNotFoundException none) {
        }
        catch (IOException err) {
            // empty catch block
        }
    }

    private static void identities(JSch sch, FS fs) {
        File home = fs.userHome();
        if (home == null) {
            return;
        }
        File sshdir = new File(home, ".ssh");
        if (sshdir.isDirectory()) {
            JschConfigSessionFactory.loadIdentity(sch, new File(sshdir, "identity"));
            JschConfigSessionFactory.loadIdentity(sch, new File(sshdir, "id_rsa"));
            JschConfigSessionFactory.loadIdentity(sch, new File(sshdir, "id_dsa"));
        }
    }

    private static void loadIdentity(JSch sch, File priv) {
        if (priv.isFile()) {
            try {
                sch.addIdentity(priv.getAbsolutePath());
            }
            catch (JSchException jSchException) {
                // empty catch block
            }
        }
    }
}

