/*
 * Decompiled with CFR 0.152.
 */
package com.maciejwalkowiak.wiremock.spring;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.maciejwalkowiak.wiremock.spring.InjectWireMock;
import com.maciejwalkowiak.wiremock.spring.Store;
import com.maciejwalkowiak.wiremock.spring.WireMock;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;

public class WireMockSpringExtension
implements BeforeEachCallback,
ParameterResolver {
    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Store.INSTANCE.findAllInstances(extensionContext).forEach(WireMockServer::resetAll);
        WireMockSpringExtension.injectWireMockInstances(extensionContext, WireMock.class, WireMock::value);
        WireMockSpringExtension.injectWireMockInstances(extensionContext, InjectWireMock.class, InjectWireMock::value);
    }

    private static <T extends Annotation> void injectWireMockInstances(ExtensionContext extensionContext, Class<T> annotation, Function<T, String> fn) throws IllegalAccessException {
        for (Object testInstance : extensionContext.getRequiredTestInstances().getAllInstances()) {
            List annotatedFields = AnnotationSupport.findAnnotatedFields(testInstance.getClass(), annotation);
            for (Field annotatedField : annotatedFields) {
                T annotationValue = annotatedField.getAnnotation(annotation);
                annotatedField.setAccessible(true);
                WireMockServer wiremock = Store.INSTANCE.findRequiredWireMockInstance(extensionContext, fn.apply(annotationValue));
                annotatedField.set(testInstance, wiremock);
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == WireMockServer.class && (parameterContext.isAnnotated(WireMock.class) || parameterContext.isAnnotated(InjectWireMock.class));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        String wireMockServerName = parameterContext.findAnnotation(WireMock.class).map(WireMock::value).orElseGet(() -> ((InjectWireMock)parameterContext.findAnnotation(InjectWireMock.class).get()).value());
        return Store.INSTANCE.findRequiredWireMockInstance(extensionContext, wireMockServerName);
    }
}

