/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AppThread;
import com.machinepublishers.jbrowserdriver.Context;
import com.machinepublishers.jbrowserdriver.ElementServer;
import com.machinepublishers.jbrowserdriver.HttpListener;
import com.machinepublishers.jbrowserdriver.JBrowserDriverServer;
import com.machinepublishers.jbrowserdriver.PopupHandler;
import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.StatusCode;
import com.machinepublishers.jbrowserdriver.Util;
import com.machinepublishers.jbrowserdriver.WindowServer;
import com.sun.javafx.webkit.Accessor;
import com.sun.webkit.LoadListenerClient;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;
import netscape.javascript.JSObject;
import org.openqa.selenium.Point;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLFrameElement;
import org.w3c.dom.html.HTMLIFrameElement;

class ContextItem {
    private static final AtomicLong currentItemId = new AtomicLong();
    final AtomicReference<WindowServer> window = new AtomicReference();
    final AtomicReference<Stage> stage = new AtomicReference();
    final AtomicReference<WebView> view = new AtomicReference();
    final AtomicReference<WebEngine> engine = new AtomicReference();
    final AtomicReference<HttpListener> httpListener = new AtomicReference();
    final AtomicBoolean initialized = new AtomicBoolean();
    final AtomicReference<String> itemId = new AtomicReference();
    final AtomicReference<Context> context = new AtomicReference();
    final StatusCode statusCode = new StatusCode();
    private final Object lock = new Object();
    private ElementServer frame;

    ContextItem() {
        this.itemId.set(Long.toString(currentItemId.getAndIncrement()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSObject selectedFrameDoc() {
        Object object = this.lock;
        synchronized (object) {
            Document doc;
            if (this.frame != null && this.ancestors(this.engine.get().getDocument(), this.frame.node()) != null) {
                if (this.frame.node() instanceof HTMLIFrameElement && (doc = ((HTMLIFrameElement)((Object)this.frame.node())).getContentDocument()) instanceof JSObject) {
                    return (JSObject)((Object)doc);
                }
                if (this.frame.node() instanceof HTMLFrameElement && (doc = ((HTMLFrameElement)((Object)this.frame.node())).getContentDocument()) instanceof JSObject) {
                    return (JSObject)((Object)doc);
                }
            }
            this.frame = null;
            doc = this.engine.get().getDocument();
            if (doc instanceof JSObject) {
                return (JSObject)((Object)doc);
            }
            return null;
        }
    }

    boolean containsFrame(JSObject doc) {
        return this.engine.get().getDocument().equals(doc) || this.ancestors(this.engine.get().getDocument(), doc) != null;
    }

    private List<Node> ancestors(Document doc, JSObject targetNode) {
        if (targetNode != null) {
            ArrayList<Node> list = new ArrayList<Node>();
            try {
                ArrayList elements = new ArrayList();
                elements.addAll(new ElementServer((JSObject)((Object)doc), this).findElementsByTagName("frame"));
                elements.addAll(new ElementServer((JSObject)((Object)doc), this).findElementsByTagName("iframe"));
                for (Object cur : elements) {
                    JSObject node = ((ElementServer)cur).node();
                    if (!(node instanceof Node)) continue;
                    list.add((Node)((Object)node));
                }
            }
            catch (RemoteException e) {
                Util.handleException(e);
            }
            for (Node cur : list) {
                List<Node> ancestors;
                Document curDoc = null;
                if (cur instanceof HTMLFrameElement) {
                    curDoc = ((HTMLFrameElement)cur).getContentDocument();
                } else if (cur instanceof HTMLIFrameElement) {
                    curDoc = ((HTMLIFrameElement)cur).getContentDocument();
                }
                Document targetDoc = null;
                if (targetNode instanceof HTMLFrameElement) {
                    targetDoc = ((HTMLFrameElement)((Object)targetNode)).getContentDocument();
                } else if (targetNode instanceof HTMLIFrameElement) {
                    targetDoc = ((HTMLIFrameElement)((Object)targetNode)).getContentDocument();
                } else if (targetNode instanceof Document) {
                    targetDoc = (Document)((Object)targetNode);
                }
                if (curDoc.equals(targetDoc)) {
                    ancestors = new ArrayList<Node>();
                    ancestors.add(cur);
                    return ancestors;
                }
                ancestors = this.ancestors(curDoc, targetNode);
                if (ancestors == null) continue;
                ancestors.add(cur);
                return ancestors;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point selectedFrameLocation() {
        Object object = this.lock;
        synchronized (object) {
            List<Node> ancestors;
            int xCoord = 0;
            int yCoord = 0;
            if (this.frame != null && (ancestors = this.ancestors(this.engine.get().getDocument(), this.frame.node())) != null) {
                for (Node cur : ancestors) {
                    try {
                        if (!(cur instanceof JSObject)) continue;
                        Point point = new ElementServer((JSObject)((Object)cur), this).getLocation();
                        xCoord += point.getX();
                        yCoord += point.getY();
                    }
                    catch (RemoteException e) {
                        Util.handleException(e);
                    }
                }
            }
            return new Point(xCoord, yCoord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deselectFrame() {
        Object object = this.lock;
        synchronized (object) {
            this.frame = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectFrame(ElementServer frame) {
        Object object = this.lock;
        synchronized (object) {
            this.frame = null;
            if (frame != null && frame.node() instanceof Document && !frame.node().equals(this.engine.get().getDocument())) {
                List<Node> ancestors = this.ancestors(this.engine.get().getDocument(), frame.node());
                if (ancestors != null && !ancestors.isEmpty() && ancestors.get(0) instanceof JSObject) {
                    try {
                        this.frame = new ElementServer((JSObject)((Object)ancestors.get(0)), this);
                    }
                    catch (RemoteException e) {
                        Util.handleException(e);
                    }
                }
            } else if (frame != null && (frame.node() instanceof HTMLIFrameElement || frame.node() instanceof HTMLFrameElement)) {
                this.frame = frame;
            }
        }
    }

    void init(JBrowserDriverServer driver, Context context) {
        if (this.initialized.compareAndSet(false, true)) {
            this.context.set(context);
            SettingsManager.register(this.stage, this.view);
            this.engine.set(this.view.get().getEngine());
            try {
                this.window.set(new WindowServer(this.stage, this.statusCode));
                context.alert.get().listen(this);
            }
            catch (RemoteException e) {
                Util.handleException(e);
            }
            ContextItem thisObject = this;
            AppThread.exec(this.statusCode, () -> {
                Settings settings = SettingsManager.settings();
                this.engine.get().setJavaScriptEnabled(settings.javascript());
                this.engine.get().setUserDataDirectory(context.userDataDirectory.get());
                this.httpListener.set(new HttpListener(thisObject, this.statusCode, context.timeouts.get().getPageLoadTimeoutObjMS()));
                this.httpListener.get().init();
                Accessor.getPageFor((WebEngine)this.view.get().getEngine()).addLoadListenerClient((LoadListenerClient)this.httpListener.get());
                this.engine.get().setCreatePopupHandler((Callback)new PopupHandler(driver, context));
                return null;
            });
        }
    }
}

