/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.Dimension;
import com.machinepublishers.jbrowserdriver.Point;
import com.machinepublishers.jbrowserdriver.SocketLock;
import com.machinepublishers.jbrowserdriver.Util;
import com.machinepublishers.jbrowserdriver.WindowRemote;
import org.openqa.selenium.WebDriver;

class Window
implements WebDriver.Window {
    private final WindowRemote remote;
    private final SocketLock lock;

    Window(WindowRemote remote, SocketLock lock) {
        this.remote = remote;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.openqa.selenium.Point getPosition() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.remoteGetPosition().toSelenium();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.openqa.selenium.Dimension getSize() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.remoteGetSize().toSelenium();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maximize() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.maximize();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition(org.openqa.selenium.Point point) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.remoteSetPosition(new Point(point));
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(org.openqa.selenium.Dimension dimension) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.remoteSetSize(new Dimension(dimension));
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullscreen() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.fullscreen();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }
}

