/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.StatusMonitor;
import com.machinepublishers.jbrowserdriver.StreamConnection;
import com.machinepublishers.jbrowserdriver.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.lang.StringUtils;

class ResponseHandler {
    private static final Pattern head = Pattern.compile("<head\\b[^>]*>", 2);
    private static final Pattern html = Pattern.compile("<html\\b[^>]*>", 2);
    private static final Pattern body = Pattern.compile("<body\\b[^>]*>", 2);
    private static final Set<Integer> redirectCodes = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(301, 302, 303, 307, 308)));

    ResponseHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InputStream handleResponse(StreamConnection conn, InputStream inputStream) throws IOException {
        String url = conn.getURL().toExternalForm();
        byte[] bytes = new byte[]{};
        try {
            byte[] newContent;
            bytes = "gzip".equalsIgnoreCase(conn.getContentEncoding()) ? Util.toBytes(new GZIPInputStream(inputStream)) : ("deflate".equalsIgnoreCase(conn.getContentEncoding()) ? Util.toBytes(new InflaterInputStream(inputStream)) : Util.toBytes(inputStream));
            conn.removeContentEncoding();
            conn.setContentLength(bytes.length);
            Settings settings = SettingsManager.settings();
            if (settings != null) {
                String disposition = conn.getHeaderField("Content-Disposition");
                if (settings.saveAttachments() && disposition != null && StatusMonitor.instance().isPrimaryDocument(true, url)) {
                    ResponseHandler.writeContentToDisk(bytes, StreamConnection.attachmentsDir(), url, conn.getContentTypeRaw(), disposition);
                }
                if (settings.saveMedia() && conn.isMedia()) {
                    ResponseHandler.writeContentToDisk(bytes, StreamConnection.mediaDir(), url, conn.getContentTypeRaw(), disposition);
                }
            }
            if ((newContent = ResponseHandler.getBody(conn, bytes, url)) != null) {
                bytes = newContent;
            }
        }
        catch (Throwable t) {
            LogsServer.instance().exception(t);
        }
        finally {
            Util.close(inputStream);
        }
        conn.setContentLength(bytes.length);
        return new ByteArrayInputStream(bytes);
    }

    private static void writeContentToDisk(byte[] content, File dir, String url, String contentType, String contentDisposition) {
        String filename = Util.randomFileName();
        File contentFile = new File(dir, filename + ".content");
        File metaFile = new File(dir, filename + ".metadata");
        contentFile.deleteOnExit();
        metaFile.deleteOnExit();
        try {
            Files.write(contentFile.toPath(), content, new OpenOption[0]);
            Files.write(metaFile.toPath(), ((StringUtils.isEmpty((String)url) ? "" : url) + "\n" + (StringUtils.isEmpty((String)contentType) ? "" : contentType) + "\n" + (StringUtils.isEmpty((String)contentDisposition) ? "" : contentDisposition)).getBytes("utf-8"), new OpenOption[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static byte[] getBody(StreamConnection connection, byte[] inflatedContent, String url) {
        Settings settings = SettingsManager.settings();
        try {
            if (settings.quickRender() && connection.isMedia()) {
                LogsServer.instance().trace("Media discarded: " + url);
                StatusMonitor.instance().addDiscarded(url);
                return new byte[0];
            }
            if (!redirectCodes.contains(connection.getResponseCode()) && (connection.getContentType() == null || connection.getContentType().indexOf("text/html") > -1) && StatusMonitor.instance().isPrimaryDocument(false, url)) {
                String intercepted = null;
                String charset = Util.charset(connection);
                String content = new String(inflatedContent, charset);
                Matcher matcher = head.matcher(content);
                intercepted = matcher.find() ? matcher.replaceFirst(matcher.group(0) + settings.script()) : ((matcher = html.matcher(content)).find() ? matcher.replaceFirst(matcher.group(0) + "<head>" + settings.script() + "</head>") : ((matcher = body.matcher(content)).find() ? "<html><head>" + settings.script() + "</head>" + content + "</html>" : content));
                return intercepted == null ? null : intercepted.getBytes(charset);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

