/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.KeyboardRemote;
import com.machinepublishers.jbrowserdriver.RemoteObject;
import com.machinepublishers.jbrowserdriver.Robot;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicReference;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Keyboard;

class KeyboardServer
extends RemoteObject
implements KeyboardRemote,
Keyboard {
    private final AtomicReference<Robot> robot;
    private boolean shiftPressed;
    private final Object lock = new Object();

    KeyboardServer(AtomicReference<Robot> robot) throws RemoteException {
        this.robot = robot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pressKey(CharSequence key) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shiftPressed) {
                this.shiftPressed = Keys.SHIFT.equals((Object)key) || Keys.LEFT_SHIFT.equals((Object)key);
            }
        }
        this.robot.get().keysPress(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseKey(CharSequence key) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shiftPressed) {
                this.shiftPressed = !Keys.SHIFT.equals((Object)key) && !Keys.LEFT_SHIFT.equals((Object)key);
            }
        }
        this.robot.get().keysRelease(key);
    }

    @Override
    public void sendKeys(CharSequence ... keys) {
        this.robot.get().keysType(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShiftPressed() {
        Object object = this.lock;
        synchronized (object) {
            return this.shiftPressed;
        }
    }
}

