/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.ImeHandler;
import com.machinepublishers.jbrowserdriver.ImeHandlerRemote;
import com.machinepublishers.jbrowserdriver.Logs;
import com.machinepublishers.jbrowserdriver.OptionsRemote;
import com.machinepublishers.jbrowserdriver.SocketLock;
import com.machinepublishers.jbrowserdriver.Timeouts;
import com.machinepublishers.jbrowserdriver.TimeoutsRemote;
import com.machinepublishers.jbrowserdriver.Util;
import com.machinepublishers.jbrowserdriver.Window;
import com.machinepublishers.jbrowserdriver.WindowRemote;
import java.util.Set;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;

class Options
implements WebDriver.Options {
    private final OptionsRemote remote;
    private final Logs logs;
    private final SocketLock lock;

    Options(OptionsRemote remote, Logs logs, SocketLock lock) {
        this.remote = remote;
        this.logs = logs;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.addCookie(cookie);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllCookies() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.deleteAllCookies();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCookie(Cookie cookie) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.deleteCookie(cookie);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCookieNamed(String name) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.deleteCookieNamed(name);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookie getCookieNamed(String name) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.getCookieNamed(name);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Cookie> getCookies() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.getCookies();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver.ImeHandler ime() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                ImeHandlerRemote imeHandler = this.remote.ime();
                if (imeHandler == null) {
                    return null;
                }
                return new ImeHandler(imeHandler, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    public org.openqa.selenium.logging.Logs logs() {
        return this.logs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver.Timeouts timeouts() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                TimeoutsRemote timeouts = this.remote.timeouts();
                if (timeouts == null) {
                    return null;
                }
                return new Timeouts(timeouts, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver.Window window() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                WindowRemote window = this.remote.window();
                if (window == null) {
                    return null;
                }
                return new Window(window, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }
}

