/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.LaxCookieSpecProvider;
import com.machinepublishers.jbrowserdriver.LogsServer;
import java.io.IOException;
import java.io.Serializable;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.message.BasicHeader;

class CookieStore
extends CookieHandler
implements org.apache.http.client.CookieStore,
Serializable {
    private static final CookieSpec spec = new LaxCookieSpecProvider().create(null);
    private final org.apache.http.client.CookieStore store = new BasicCookieStore();

    CookieStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        Map<String, List<String>> map;
        String cookies;
        String reqHost = CookieStore.canonicalHost(uri.getHost());
        String reqPath = CookieStore.canonicalPath(uri.getPath());
        boolean reqSecure = CookieStore.isSecure(uri.getScheme());
        boolean reqJavascript = CookieStore.isJavascript(uri.getScheme());
        StringBuilder builder = new StringBuilder();
        if (reqJavascript) {
            List list;
            org.apache.http.client.CookieStore cookieStore = this.store;
            synchronized (cookieStore) {
                this.store.clearExpired(new Date());
                list = this.store.getCookies();
            }
            for (Cookie cookie : list) {
                if (cookie.isSecure() && !reqSecure || !reqHost.endsWith(CookieStore.canonicalHost(cookie.getDomain())) || !reqPath.startsWith(CookieStore.canonicalPath(cookie.getPath()))) continue;
                if (builder.length() > 0) {
                    builder.append(';');
                }
                builder.append(cookie.getName());
                builder.append('=');
                builder.append(cookie.getValue());
            }
        }
        String string = cookies = builder.length() == 0 ? null : builder.toString();
        if (cookies != null) {
            map = new HashMap();
            map.put("Cookie", Arrays.asList(cookies));
        } else {
            map = Collections.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        if (CookieStore.isJavascript(uri.getScheme())) {
            for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
                for (String value : entry.getValue()) {
                    try {
                        List cookies = spec.parse((Header)new BasicHeader(entry.getKey(), value), new CookieOrigin(uri.getHost(), CookieStore.canonicalPort(uri.getScheme(), uri.getPort()), CookieStore.canonicalPath(uri.getPath()), CookieStore.isSecure(uri.getScheme())));
                        for (Cookie cookie : cookies) {
                            org.apache.http.client.CookieStore cookieStore = this.store;
                            synchronized (cookieStore) {
                                this.store.addCookie(cookie);
                            }
                        }
                    }
                    catch (MalformedCookieException e) {
                        LogsServer.instance().warn("Malformed cookie for cookie named " + entry.getKey() + ". " + e.getMessage());
                    }
                }
            }
        }
    }

    private static boolean isSecure(String scheme) {
        return "https".equalsIgnoreCase(scheme) || "javascripts".equalsIgnoreCase(scheme);
    }

    private static boolean isJavascript(String scheme) {
        return "javascripts".equalsIgnoreCase(scheme) || "javascript".equalsIgnoreCase(scheme);
    }

    private static int canonicalPort(String scheme, int port) {
        if (port > -1) {
            return port;
        }
        return CookieStore.isSecure(scheme) ? 443 : 80;
    }

    private static String canonicalHost(String host) {
        if (host == null || host.isEmpty()) {
            return "";
        }
        return host.startsWith(".") ? host.toLowerCase() : "." + host.toLowerCase();
    }

    private static String canonicalPath(String path) {
        String canonical = StringUtils.isEmpty((String)path) ? "/" : path;
        canonical = canonical.startsWith("/") ? canonical : "/" + canonical;
        canonical = canonical.endsWith("/") ? canonical : canonical + "/";
        return canonical.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        org.apache.http.client.CookieStore cookieStore = this.store;
        synchronized (cookieStore) {
            this.store.addCookie(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Cookie> getCookies() {
        org.apache.http.client.CookieStore cookieStore = this.store;
        synchronized (cookieStore) {
            return this.store.getCookies();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearExpired(Date date) {
        org.apache.http.client.CookieStore cookieStore = this.store;
        synchronized (cookieStore) {
            return this.store.clearExpired(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        org.apache.http.client.CookieStore cookieStore = this.store;
        synchronized (cookieStore) {
            this.store.clear();
        }
    }
}

