/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.params.HttpParams;

public class JbdResponse
implements CloseableHttpResponse {
    private final CloseableHttpResponse resp;

    public JbdResponse(CloseableHttpResponse resp) {
        this.resp = resp;
    }

    private void adjustHeaders() {
        this.resp.removeHeaders("Via");
        if (ArrayUtils.isEmpty((Object[])this.resp.getHeaders("Content-Type"))) {
            this.resp.addHeader("Content-Type", "text/html");
        }
    }

    public StatusLine getStatusLine() {
        return this.resp.getStatusLine();
    }

    public void setStatusLine(StatusLine statusline) {
        this.resp.setStatusLine(statusline);
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        this.resp.setStatusLine(ver, code);
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.resp.setStatusLine(ver, code, reason);
    }

    public void setStatusCode(int code) throws IllegalStateException {
        this.resp.setStatusCode(code);
    }

    public void setReasonPhrase(String reason) throws IllegalStateException {
        this.resp.setReasonPhrase(reason);
    }

    public HttpEntity getEntity() {
        this.adjustHeaders();
        return this.resp.getEntity();
    }

    public void setEntity(HttpEntity entity) {
        this.resp.setEntity(entity);
    }

    public Locale getLocale() {
        return this.resp.getLocale();
    }

    public void setLocale(Locale loc) {
        this.resp.setLocale(loc);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.resp.getProtocolVersion();
    }

    public boolean containsHeader(String name) {
        this.adjustHeaders();
        return this.resp.containsHeader(name);
    }

    public Header[] getHeaders(String name) {
        this.adjustHeaders();
        return this.resp.getHeaders(name);
    }

    public Header getFirstHeader(String name) {
        this.adjustHeaders();
        return this.resp.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        this.adjustHeaders();
        return this.resp.getLastHeader(name);
    }

    public Header[] getAllHeaders() {
        this.adjustHeaders();
        return this.resp.getAllHeaders();
    }

    public void addHeader(Header header) {
        this.resp.addHeader(header);
    }

    public void addHeader(String name, String value) {
        this.resp.addHeader(name, value);
    }

    public void setHeader(Header header) {
        this.resp.setHeader(header);
    }

    public void setHeader(String name, String value) {
        this.resp.setHeader(name, value);
    }

    public void setHeaders(Header[] headers) {
        this.resp.setHeaders(headers);
    }

    public void removeHeader(Header header) {
        this.resp.removeHeader(header);
    }

    public void removeHeaders(String name) {
        this.resp.removeHeaders(name);
    }

    public HeaderIterator headerIterator() {
        this.adjustHeaders();
        return this.resp.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        this.adjustHeaders();
        return this.resp.headerIterator(name);
    }

    public HttpParams getParams() {
        this.adjustHeaders();
        return this.resp.getParams();
    }

    public void setParams(HttpParams params) {
        this.resp.setParams(params);
    }

    public void close() throws IOException {
        this.resp.close();
    }
}

