/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.Alert;
import com.machinepublishers.jbrowserdriver.Element;
import com.machinepublishers.jbrowserdriver.JBrowserDriver;
import com.machinepublishers.jbrowserdriver.SocketLock;
import com.machinepublishers.jbrowserdriver.TargetLocatorRemote;
import com.machinepublishers.jbrowserdriver.Util;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

class TargetLocator
implements WebDriver.TargetLocator {
    private final TargetLocatorRemote remote;
    private final JBrowserDriver driver;
    private final SocketLock lock;

    TargetLocator(TargetLocatorRemote remote, JBrowserDriver driver, SocketLock lock) {
        this.remote = remote;
        this.driver = driver;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement activeElement() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.activeElement(), this.driver, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.openqa.selenium.Alert alert() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return new Alert(this.remote.alert(), this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver defaultContent() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.defaultContent();
            }
            return this.driver;
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver frame(int index) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.frame(index);
            }
            return this.driver;
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver frame(String nameOrId) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.frame(nameOrId);
            }
            return this.driver;
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    public WebDriver frame(WebElement element) {
        ((Element)element).activate();
        return this.driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver parentFrame() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.parentFrame();
            }
            return this.driver;
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver window(String windowHandle) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.window(windowHandle);
            }
            return this.driver;
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }
}

