/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.StreamConnection;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import sun.net.www.protocol.https.Handler;

class StreamHandler
implements URLStreamHandlerFactory {
    StreamHandler() {
    }

    static URLConnection defaultConnection(URL url) throws IOException {
        return "https".equals(url.getProtocol()) ? new HttpsHandler().defaultConnection(url) : new HttpHandler().defaultConnection(url);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if ("http".equals(protocol)) {
            return new HttpHandler();
        }
        if ("https".equals(protocol)) {
            return new HttpsHandler();
        }
        if ("about".equals(protocol)) {
            return new com.sun.webkit.network.about.Handler();
        }
        if ("data".equals(protocol)) {
            return new com.sun.webkit.network.data.Handler();
        }
        if ("file".equals(protocol)) {
            return new sun.net.www.protocol.file.Handler();
        }
        if ("ftp".equals(protocol)) {
            return new sun.net.www.protocol.ftp.Handler();
        }
        if ("jar".equals(protocol)) {
            return new sun.net.www.protocol.jar.Handler();
        }
        if ("mailto".equals(protocol)) {
            return new sun.net.www.protocol.mailto.Handler();
        }
        if ("netdoc".equals(protocol)) {
            return new sun.net.www.protocol.netdoc.Handler();
        }
        return null;
    }

    private static class HttpsHandler
    extends Handler {
        private HttpsHandler() {
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new StreamConnection(url);
        }

        private URLConnection defaultConnection(URL url) throws IOException {
            return super.openConnection(url);
        }
    }

    private static class HttpHandler
    extends sun.net.www.protocol.http.Handler {
        private HttpHandler() {
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new StreamConnection(url);
        }

        private URLConnection defaultConnection(URL url) throws IOException {
            return super.openConnection(url);
        }
    }
}

