/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.StreamConnection;
import com.machinepublishers.jbrowserdriver.Util;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class StatusMonitor {
    private static final StatusMonitor instance = new StatusMonitor();
    private final Object lock = new Object();
    private final Map<String, StreamConnection> connections = new HashMap<String, StreamConnection>();
    private final Set<String> primaryDocuments = new HashSet<String>();
    private final Set<String> discarded = new HashSet<String>();
    private final Map<String, String> redirects = new HashMap<String, String>();
    private final List<String> startedUrls = new ArrayList<String>();
    private boolean monitoring;

    StatusMonitor() {
    }

    static StatusMonitor instance() {
        return instance;
    }

    private static String canonicalUrl(String url) {
        if (url == null) {
            return null;
        }
        int fragmentIndex = url.indexOf("#");
        url = fragmentIndex > -1 ? url.substring(0, fragmentIndex) : url;
        return url.endsWith("/") ? url : url + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPrimaryDocument(String url) {
        Object object = this.lock;
        synchronized (object) {
            return this.primaryDocuments.contains(StatusMonitor.canonicalUrl(url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDiscarded(String url) {
        Object object = this.lock;
        synchronized (object) {
            return this.discarded.contains(StatusMonitor.canonicalUrl(url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRedirect(String original, String redirected) {
        original = StatusMonitor.canonicalUrl(original);
        redirected = StatusMonitor.canonicalUrl(redirected);
        if (original != null && redirected != null && !original.equals(redirected)) {
            Object object = this.lock;
            synchronized (object) {
                this.redirects.put(redirected, original);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String originalFromRedirect(String redirected) {
        Object object = this.lock;
        synchronized (object) {
            return this.redirects.get(StatusMonitor.canonicalUrl(redirected));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startStatusMonitor(String url) {
        Object object = this.lock;
        synchronized (object) {
            this.monitoring = true;
            this.startedUrls.add(StatusMonitor.canonicalUrl(url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPrimaryDocument(String url) {
        Object object = this.lock;
        synchronized (object) {
            this.primaryDocuments.add(StatusMonitor.canonicalUrl(url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStatusMonitor(URL url, StreamConnection conn) {
        Object object = this.lock;
        synchronized (object) {
            if (this.monitoring) {
                this.connections.put(StatusMonitor.canonicalUrl(url.toExternalForm()), conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDiscarded(String url) {
        Object object = this.lock;
        synchronized (object) {
            this.discarded.add(StatusMonitor.canonicalUrl(url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int stopStatusMonitor(String url) {
        StreamConnection conn = null;
        Object object = this.lock;
        synchronized (object) {
            this.monitoring = false;
            conn = this.connections.get(StatusMonitor.canonicalUrl(url));
            for (int i = this.startedUrls.size() - 1; conn == null && i > -1; --i) {
                conn = this.connections.get(this.startedUrls.get(i));
            }
        }
        int code = 499;
        if (conn != null) {
            try {
                code = conn.getResponseCode();
                code = code <= 0 ? 499 : code;
            }
            catch (Throwable t) {
                LogsServer.instance().exception(t);
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearStatusMonitor() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.monitoring) {
                for (StreamConnection conn : this.connections.values()) {
                    Util.close(conn);
                }
                StreamConnection.cleanUp();
                this.connections.clear();
                this.primaryDocuments.clear();
                this.discarded.clear();
                this.redirects.clear();
                this.startedUrls.clear();
            }
        }
    }
}

